/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode;

import com.google.protobuf.ByteString;
import com.vesoft.nebula.driver.graph.data.Edge;
import com.vesoft.nebula.driver.graph.data.NDuration;
import com.vesoft.nebula.driver.graph.data.NRecord;
import com.vesoft.nebula.driver.graph.data.Node;
import com.vesoft.nebula.driver.graph.data.Path;
import com.vesoft.nebula.driver.graph.data.ValueWrapper;
import com.vesoft.nebula.driver.graph.decode.BytesReader;
import com.vesoft.nebula.driver.graph.decode.ColumnType;
import com.vesoft.nebula.driver.graph.decode.DecodeUtils;
import com.vesoft.nebula.driver.graph.decode.VectorWrapper;
import com.vesoft.nebula.driver.graph.decode.datatype.BasicType;
import com.vesoft.nebula.driver.graph.decode.datatype.DataType;
import com.vesoft.nebula.driver.graph.decode.datatype.EdgeType;
import com.vesoft.nebula.driver.graph.decode.datatype.ListType;
import com.vesoft.nebula.driver.graph.decode.datatype.NodeType;
import com.vesoft.nebula.driver.graph.decode.datatype.PathType;
import com.vesoft.nebula.driver.graph.decode.datatype.RecordType;
import com.vesoft.nebula.driver.graph.decode.struct.AnyHeader;
import com.vesoft.nebula.driver.graph.decode.struct.AnyValue;
import com.vesoft.nebula.driver.graph.decode.struct.EdgeHeader;
import com.vesoft.nebula.driver.graph.decode.struct.ListHeader;
import com.vesoft.nebula.driver.graph.decode.struct.NodeHeader;
import com.vesoft.nebula.driver.graph.decode.struct.PathAdjHeader;
import com.vesoft.nebula.driver.graph.decode.struct.PathHeader;
import com.vesoft.nebula.driver.graph.decode.struct.PathSpecialMetaData;
import com.vesoft.nebula.driver.graph.decode.struct.PathVectorPair;
import com.vesoft.nebula.driver.graph.decode.struct.ResultGraphSchemas;
import com.vesoft.nebula.proto.graph.NestedVector;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ValueParser {
    private ResultGraphSchemas graphSchemas;
    private int timeZoneOffset;
    private ByteOrder byteOrder;
    private static final byte[] kOneBitmasks = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};

    public ValueParser(ResultGraphSchemas graphSchemas, int timeZoneOffset, ByteOrder byteOrder) {
        this.graphSchemas = graphSchemas;
        this.timeZoneOffset = timeZoneOffset;
        this.byteOrder = byteOrder;
    }

    public ValueWrapper decodeValueWrapper(VectorWrapper vector, DataType type, int rowIndex) {
        Object value = this.decodeValue(vector, type, rowIndex);
        if (type.getType() == ColumnType.COLUMN_TYPE_ANY) {
            AnyValue anyValue = (AnyValue)value;
            if (value == null) {
                return new ValueWrapper(null, type.getType());
            }
            return new ValueWrapper(anyValue.getValue(), anyValue.getType());
        }
        return new ValueWrapper(value, type.getType());
    }

    public Object decodeValue(VectorWrapper vector, DataType type, int rowIndex) {
        if (!vector.isNullAllSet() && !vector.getNullBitMap().toString(DecodeUtils.charset).isEmpty()) {
            int byteIndex = rowIndex / 8;
            int bitIndex = rowIndex % 8;
            if ((vector.getNullBitMap().byteAt(byteIndex) & kOneBitmasks[bitIndex]) == 0) {
                return null;
            }
        }
        Object value = null;
        switch (vector.getVectorType()) {
            case FLAT_VECTOR: {
                value = this.decodeFlatValue(vector, type, rowIndex);
                break;
            }
            case CONST_VECTOR: {
                if (vector.getConstValue() == null) {
                    ByteString vectorData = vector.getVectorData();
                    BytesReader reader = new BytesReader(vectorData);
                    Object constValue = this.decodeConstValue(reader, type.getType());
                    vector.setConstValue(constValue);
                }
                value = vector.getConstValue();
                break;
            }
            default: {
                throw new RuntimeException("do not support vector type: " + (Object)((Object)vector.getVectorType()));
            }
        }
        return value;
    }

    private Object decodeFlatValue(VectorWrapper vector, DataType type, int rowIndex) {
        ByteString vectorData = vector.getVectorData();
        switch (type.getType()) {
            case COLUMN_TYPE_NULL: {
                return null;
            }
            case COLUMN_TYPE_INT8: {
                ByteString valueData = this.getSubBytes(vectorData, 1, rowIndex);
                return DecodeUtils.bytesToInt8(valueData);
            }
            case COLUMN_TYPE_UINT8: {
                ByteString valueData = this.getSubBytes(vectorData, 1, rowIndex);
                return DecodeUtils.bytesToUInt8(valueData);
            }
            case COLUMN_TYPE_INT16: {
                ByteString valueData = this.getSubBytes(vectorData, 2, rowIndex);
                return DecodeUtils.bytesToInt16(valueData, this.byteOrder);
            }
            case COLUMN_TYPE_UINT16: {
                ByteString valueData = this.getSubBytes(vectorData, 2, rowIndex);
                return DecodeUtils.bytesToUInt16(valueData, this.byteOrder);
            }
            case COLUMN_TYPE_INT32: 
            case COLUMN_TYPE_UINT32: {
                ByteString valueData = this.getSubBytes(vectorData, 4, rowIndex);
                return DecodeUtils.bytesToInt32(valueData, this.byteOrder);
            }
            case COLUMN_TYPE_INT64: 
            case COLUMN_TYPE_UINT64: {
                ByteString valueData = this.getSubBytes(vectorData, 8, rowIndex);
                return DecodeUtils.bytesToInt64(valueData, this.byteOrder);
            }
            case COLUMN_TYPE_FLOAT32: {
                ByteString valueData = this.getSubBytes(vectorData, 4, rowIndex);
                return Float.valueOf(DecodeUtils.bytesToFloat(valueData, this.byteOrder));
            }
            case COLUMN_TYPE_FLOAT64: {
                ByteString valueData = this.getSubBytes(vectorData, 8, rowIndex);
                return DecodeUtils.bytesToDouble(valueData, this.byteOrder);
            }
            case COLUMN_TYPE_BOOL: {
                ByteString valueData = this.getSubBytes(vectorData, 1, rowIndex);
                return DecodeUtils.bytesToBool(valueData);
            }
            case COLUMN_TYPE_DECIMAL: {
                ByteString valueData = this.getSubBytes(vectorData, 16, rowIndex);
                return this.stringToDecimal(this.bytesToString(valueData, vector.getVector()));
            }
            case COLUMN_TYPE_STRING: {
                ByteString valueData = this.getSubBytes(vectorData, 16, rowIndex);
                return this.bytesToString(valueData, vector.getVector());
            }
            case COLUMN_TYPE_DATE: {
                ByteString valueData = this.getSubBytes(vectorData, 4, rowIndex);
                return this.bytesToDate(valueData);
            }
            case COLUMN_TYPE_LOCALTIME: {
                ByteString valueData = this.getSubBytes(vectorData, 8, rowIndex);
                return this.bytesToLocalTime(valueData);
            }
            case COLUMN_TYPE_ZONEDTIME: {
                ByteString valueData = this.getSubBytes(vectorData, 8, rowIndex);
                return this.bytesToZonedTime(valueData);
            }
            case COLUMN_TYPE_LOCALDATETIME: {
                ByteString valueData = this.getSubBytes(vectorData, 8, rowIndex);
                return this.bytesToLocalDateTime(valueData);
            }
            case COLUMN_TYPE_ZONEDDATETIME: {
                ByteString valueData = this.getSubBytes(vectorData, 8, rowIndex);
                return this.bytesToZonedDateTime(valueData);
            }
            case COLUMN_TYPE_DURATION: {
                ByteString valueData = this.getSubBytes(vectorData, 8, rowIndex);
                return this.bytesToDuration(valueData);
            }
            case COLUMN_TYPE_LIST: {
                ListType listType = (ListType)type;
                ArrayList<ValueWrapper> list = new ArrayList<ValueWrapper>();
                ByteString valueData = this.getSubBytes(vectorData, 8, rowIndex);
                ListHeader listHeader = new ListHeader(valueData, this.byteOrder);
                for (int i = 0; i < listHeader.getSize(); ++i) {
                    list.add(new ValueWrapper(this.decodeValue(vector.getVectorWrapper(0), listType.getValueType(), listHeader.getOffset() + i), listType.getValueType().getType()));
                }
                return list;
            }
            case COLUMN_TYPE_RECORD: {
                ByteString specialMetaData = vector.getSpecialMetaData();
                RecordType recordType = (RecordType)type;
                Map<String, DataType> fieldAndDataType = recordType.getFieldTypes();
                HashMap<String, ValueWrapper> map = new HashMap<String, ValueWrapper>();
                BytesReader reader = new BytesReader(specialMetaData);
                for (int i = 0; i < fieldAndDataType.size(); ++i) {
                    String fieldName = reader.readSizedString(this.byteOrder);
                    Object value = this.decodeValue(vector.getVectorWrapper(i), fieldAndDataType.get(fieldName), rowIndex);
                    map.put(fieldName, new ValueWrapper(value, fieldAndDataType.get(fieldName).getType()));
                }
                return new NRecord(map);
            }
            case COLUMN_TYPE_NODE: {
                NodeType nodeType = (NodeType)type;
                Map<Integer, Map<Integer, Map<String, DataType>>> nodePropColumnType = nodeType.getNodeTypes();
                Map<Integer, Map<Integer, Map<String, Integer>>> nodePropVectorIndex = vector.getGraphElementTypeIdAndPropVectorIndexMap(2);
                ByteString nodeHeaderBinary = this.getSubBytes(vectorData, 16, rowIndex);
                NodeHeader nodeHeader = new NodeHeader(nodeHeaderBinary, this.byteOrder);
                if (!nodePropColumnType.containsKey(nodeHeader.getGraphId()) || !nodePropColumnType.get(nodeHeader.getGraphId()).containsKey(nodeHeader.getNodeTypeId())) {
                    throw new RuntimeException(String.format("Value type for NODE does not contain graphId %d or node type id %d", nodeHeader.getGraphId(), nodeHeader.getNodeTypeId()));
                }
                Map<String, DataType> propTypeMap = nodePropColumnType.get(nodeHeader.getGraphId()).get(nodeHeader.getNodeTypeId());
                HashMap<String, ValueWrapper> props = new HashMap<String, ValueWrapper>();
                for (String propName : propTypeMap.keySet()) {
                    int vectorIndex = nodePropVectorIndex.get(nodeHeader.getGraphId()).get(nodeHeader.getNodeTypeId()).get(propName);
                    Object propValue = this.decodeValue(vector.getVectorWrapper(vectorIndex), propTypeMap.get(propName), rowIndex);
                    props.put(propName, new ValueWrapper(propValue, propTypeMap.get(propName).getType()));
                }
                return new Node(nodeHeader.getGraphId(), nodeHeader.getNodeTypeId(), nodeHeader.getNodeId(), props, this.graphSchemas);
            }
            case COLUMN_TYPE_EDGE: {
                EdgeType edgeType = (EdgeType)type;
                Map<Integer, Map<Integer, Map<String, DataType>>> edgePropColumnType = edgeType.getEdgeTypes();
                Map<Integer, Map<Integer, Map<String, Integer>>> edgePropVectorIndex = vector.getGraphElementTypeIdAndPropVectorIndexMap(4);
                ByteString edgeHeaderBinary = this.getSubBytes(vectorData, 32, rowIndex);
                EdgeHeader edgeHeader = new EdgeHeader(edgeHeaderBinary, this.byteOrder);
                int noDirectedTypeId = edgeHeader.getEdgeTypeId() & 0x3FFFFFFF;
                if (!edgePropColumnType.containsKey(edgeHeader.getGraphId()) || !edgePropColumnType.get(edgeHeader.getGraphId()).containsKey(noDirectedTypeId)) {
                    throw new RuntimeException(String.format("Value type for NODE does not contain graphId %d or edge type id %d", edgeHeader.getGraphId(), noDirectedTypeId));
                }
                Map<String, DataType> edgePropTypeMap = edgePropColumnType.get(edgeHeader.getGraphId()).get(noDirectedTypeId);
                HashMap<String, ValueWrapper> edgeProps = new HashMap<String, ValueWrapper>();
                for (String propName : edgePropTypeMap.keySet()) {
                    int vectorIndex = edgePropVectorIndex.get(edgeHeader.getGraphId()).get(noDirectedTypeId).get(propName);
                    Object propValue = this.decodeValue(vector.getVectorWrapper(vectorIndex), edgePropTypeMap.get(propName), rowIndex);
                    edgeProps.put(propName, new ValueWrapper(propValue, edgePropTypeMap.get(propName).getType()));
                }
                Edge edgeValue = new Edge(edgeHeader.getGraphId(), edgeHeader.getEdgeTypeId(), edgeHeader.getRank(), edgeHeader.getSrcId(), edgeHeader.getDstId(), edgeProps, this.graphSchemas);
                return edgeValue;
            }
            case COLUMN_TYPE_PATH: {
                PathType pathType = (PathType)type;
                ByteString pathHeaderBinary = this.getSubBytes(vectorData, 16, rowIndex);
                PathHeader pathHeader = new PathHeader(pathHeaderBinary, this.byteOrder);
                PathSpecialMetaData pathSpecialMetaData = vector.getPathSpecialMetaData();
                Map<Integer, Map<Integer, Integer>> nodeTypes = pathSpecialMetaData.getGraphIdAndNodeTypes();
                Map<Integer, Map<Integer, Integer>> edgeTypes = pathSpecialMetaData.getGraphIdAndEdgeTypes();
                Map<Integer, PathVectorPair> indexAndNodes = pathSpecialMetaData.getIndexAndNodes();
                Map<Integer, PathVectorPair> indexAndEdges = pathSpecialMetaData.getIndexAndEdges();
                ArrayList<ValueWrapper> elements = new ArrayList<ValueWrapper>();
                BasicType adjDataType = new BasicType(ColumnType.COLUMN_TYPE_INT64);
                Object firstNode = null;
                if (pathHeader.getSize() <= 0L) {
                    return new Path(elements);
                }
                PathVectorPair firstNodePair = indexAndNodes.get(pathHeader.getHeadNodeIndex());
                VectorWrapper firstNodeVector = firstNodePair.getVector();
                VectorWrapper firstNodeAdjVector = firstNodePair.getAdjVector();
                firstNode = this.decodeValue(firstNodeVector, pathType.getDataTypes().get(0), pathHeader.getHeadOffset());
                elements.add(new ValueWrapper(firstNode, ColumnType.COLUMN_TYPE_NODE));
                PathAdjHeader pathAdjHeader = new PathAdjHeader(new ValueWrapper(this.decodeValue(firstNodeAdjVector, adjDataType, pathHeader.getHeadOffset()), adjDataType.getType()).asLong());
                VectorWrapper adjVector = null;
                while (!pathAdjHeader.isEnd()) {
                    int vecIndex = pathAdjHeader.getVecIdxOfNextEle();
                    int vecOffset = pathAdjHeader.getOffsetOfNextEle();
                    if (pathAdjHeader.isNextEdge()) {
                        PathVectorPair edgeVectorPair = indexAndEdges.get(vecIndex);
                        Object edge = this.decodeValue(edgeVectorPair.getVector(), new EdgeType(pathType.getEdgeTypes()), vecOffset);
                        adjVector = edgeVectorPair.getAdjVector();
                        elements.add(new ValueWrapper(edge, ColumnType.COLUMN_TYPE_EDGE));
                        pathAdjHeader = new PathAdjHeader(new ValueWrapper(this.decodeValue(adjVector, adjDataType, vecOffset), adjDataType.getType()).asLong());
                        continue;
                    }
                    PathVectorPair nodeVectorPair = indexAndNodes.get(vecIndex);
                    Object node = this.decodeValue(nodeVectorPair.getVector(), new NodeType(pathType.getNodeTypes()), vecOffset);
                    adjVector = nodeVectorPair.getAdjVector();
                    elements.add(new ValueWrapper(node, ColumnType.COLUMN_TYPE_NODE));
                    pathAdjHeader = new PathAdjHeader(new ValueWrapper(this.decodeValue(adjVector, adjDataType, vecOffset), adjDataType.getType()).asLong());
                }
                return new Path(elements);
            }
            case COLUMN_TYPE_ANY: {
                ByteString valueData = this.getSubBytes(vector.getVectorData(), 8, rowIndex);
                return this.bytesToAny(valueData, vector, rowIndex);
            }
        }
        throw new RuntimeException("do not support type: " + type);
    }

    private Object decodeConstValue(BytesReader reader, ColumnType type) {
        Object obj;
        if (ColumnType.isBasic(type)) {
            obj = this.bytesBasicToObject(reader, type);
        } else if (type == ColumnType.COLUMN_TYPE_STRING) {
            obj = reader.readSizedString(this.byteOrder);
        } else if (type == ColumnType.COLUMN_TYPE_DECIMAL) {
            obj = this.bytesToDecimal(reader);
        } else if (ColumnType.isComposite(type)) {
            obj = this.decodeCompositeValue(reader, type);
        } else if (type == ColumnType.COLUMN_TYPE_ANY) {
            obj = this.bytesToConstAny(reader);
        } else {
            throw new RuntimeException("do not support type:" + (Object)((Object)type));
        }
        return obj;
    }

    private ByteString getSubBytes(ByteString vectorData, int byteSize, int rowIndex) {
        return vectorData.substring(rowIndex * byteSize, rowIndex * byteSize + byteSize);
    }

    private int getNodeTypeIdFromNodeId(long nodeId) {
        return (int)(nodeId >> 48);
    }

    public String bytesToString(ByteString stringHeader, NestedVector vector) {
        int stringValueLength = DecodeUtils.bytesToInt32(stringHeader.substring(0, 4), this.byteOrder);
        if (stringValueLength <= 12) {
            return stringHeader.substring(4, 4 + stringValueLength).toString(DecodeUtils.charset);
        }
        int chunkIndex = DecodeUtils.bytesToInt32(stringHeader.substring(12, 16), this.byteOrder);
        int chunkOffset = DecodeUtils.bytesToInt32(stringHeader.substring(8, 12), this.byteOrder);
        NestedVector stringChunkVector = vector.getNestedVectors(chunkIndex);
        ByteString valueData = stringChunkVector.getVectorData().substring(chunkOffset, chunkOffset + stringValueLength);
        return valueData.toString(DecodeUtils.charset);
    }

    private LocalDate bytesToDate(ByteString data) {
        int year = DecodeUtils.bytesToUInt16(data.substring(0, 2), this.byteOrder);
        int month = DecodeUtils.bytesToUInt8(data.substring(2, 3));
        int day = DecodeUtils.bytesToUInt8(data.substring(3, 4));
        return LocalDate.of(year, month, day);
    }

    private LocalTime bytesToLocalTime(ByteString data) {
        ByteBuffer buffer = ByteBuffer.wrap(data.toByteArray()).order(this.byteOrder);
        byte hour = buffer.get();
        byte minute = buffer.get();
        byte second = buffer.get();
        buffer.get();
        int microsecond = buffer.getInt();
        return LocalTime.of(hour, minute, second, microsecond * 1000);
    }

    private OffsetTime bytesToZonedTime(ByteString data) {
        ByteBuffer buffer = ByteBuffer.wrap(data.toByteArray()).order(this.byteOrder);
        byte hour = buffer.get();
        int currentOffset = this.timeZoneOffset;
        if (hour < 0) {
            hour = -hour;
        }
        byte minute = buffer.get();
        byte second = buffer.get();
        buffer.get();
        int microsecond = buffer.getInt();
        LocalTime localUtcTime = LocalTime.of(hour, minute, second, microsecond * 1000).plusMinutes(currentOffset);
        ZoneOffset offset = ZoneOffset.ofTotalSeconds(this.timeZoneOffset * 60);
        return OffsetTime.of(localUtcTime, offset);
    }

    private LocalDateTime bytesToLocalDateTime(ByteString data) {
        long qword = ByteBuffer.wrap(data.toByteArray()).order(this.byteOrder).getLong();
        int year = (int)(qword & 0xFFFFL);
        int month = (int)((qword >>= 16) & 0xFL);
        int day = (int)((qword >>= 4) & 0x1FL);
        int hour = (int)((qword >>= 5) & 0x1FL);
        int minute = (int)((qword >>= 5) & 0x3FL);
        int second = (int)((qword >>= 6) & 0x3FL);
        int microsecond = (int)((qword >>= 6) & 0x3FFFFFL);
        return LocalDateTime.of(year, month, day, hour, minute, second, microsecond * 1000);
    }

    private ZonedDateTime bytesToZonedDateTime(ByteString data) {
        LocalDateTime localDateTime = this.bytesToLocalDateTime(data).plusSeconds((long)this.timeZoneOffset * 60L);
        ZoneOffset offset = ZoneOffset.ofTotalSeconds(this.timeZoneOffset * 60);
        return ZonedDateTime.of(localDateTime, offset);
    }

    private NDuration bytesToDuration(ByteString data) {
        ByteBuffer buffer = ByteBuffer.wrap(data.toByteArray()).order(this.byteOrder);
        long qword = buffer.getLong();
        boolean isMonthBased = (qword & 1L) == 1L;
        long durationValue = qword >> 1;
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int microSec = 0;
        if (isMonthBased) {
            year = (int)(durationValue / 12L);
            month = (int)(durationValue % 12L);
        } else {
            day = (int)(durationValue / 86400000000L);
            hour = (int)(durationValue % 86400000000L / 3600000000L);
            minute = (int)(durationValue % 3600000000L / 60000000L);
            second = (int)(durationValue % 60000000L / 1000000L);
            microSec = (int)(durationValue % 1000000L);
        }
        return new NDuration(isMonthBased, year, month, day, hour, minute, second, microSec);
    }

    private AnyValue bytesToAny(ByteString value, VectorWrapper vector, int rowIndex) {
        VectorWrapper dataTypeVector = vector.getVectorWrapper(0);
        ColumnType valueType = ColumnType.getColumnType(DecodeUtils.bytesToInt8(this.getSubBytes(dataTypeVector.getVectorData(), 1, rowIndex)));
        AnyHeader anyHeader = new AnyHeader(value, valueType, this.byteOrder);
        Object obj = null;
        if (ColumnType.isBasic(valueType)) {
            BytesReader basicReader = new BytesReader(value);
            obj = this.bytesBasicToObject(basicReader, valueType);
        }
        if (valueType == ColumnType.COLUMN_TYPE_STRING || valueType == ColumnType.COLUMN_TYPE_DECIMAL) {
            VectorWrapper stringVec = vector.getVectorWrapper((int)anyHeader.getChunkIndex());
            obj = DecodeUtils.bytesToSizedString(stringVec.getVectorData(), (int)anyHeader.getOffset(), this.byteOrder);
        }
        if (ColumnType.isComposite(valueType)) {
            VectorWrapper subVector = vector.getVectorWrapper((int)anyHeader.getChunkIndex());
            BytesReader reader = new BytesReader(subVector.getVectorData().substring((int)anyHeader.getOffset()));
            obj = this.decodeCompositeValue(reader, valueType);
        }
        return new AnyValue(obj, valueType);
    }

    private AnyValue bytesToConstAny(BytesReader reader) {
        Object obj;
        ColumnType columnType = ColumnType.getColumnType(DecodeUtils.bytesToUInt8(reader.read(1)));
        if (ColumnType.isBasic(columnType)) {
            obj = this.bytesBasicToObject(reader, columnType);
        } else if (columnType == ColumnType.COLUMN_TYPE_STRING) {
            obj = reader.readSizedString(this.byteOrder);
        } else if (columnType == ColumnType.COLUMN_TYPE_DECIMAL) {
            obj = this.bytesToDecimal(reader);
        } else if (ColumnType.isComposite(columnType)) {
            obj = this.decodeCompositeValue(reader, columnType);
        } else {
            throw new RuntimeException("do not support type:" + (Object)((Object)columnType));
        }
        return new AnyValue(obj, columnType);
    }

    private Object bytesBasicToObject(BytesReader reader, ColumnType type) {
        Object obj = null;
        switch (type) {
            case COLUMN_TYPE_NULL: {
                break;
            }
            case COLUMN_TYPE_BOOL: {
                obj = DecodeUtils.bytesToBool(reader.read(1));
                break;
            }
            case COLUMN_TYPE_INT8: {
                obj = DecodeUtils.bytesToInt8(reader.read(1));
                break;
            }
            case COLUMN_TYPE_UINT8: {
                obj = DecodeUtils.bytesToUInt8(reader.read(1));
                break;
            }
            case COLUMN_TYPE_INT16: {
                obj = DecodeUtils.bytesToInt16(reader.read(2), this.byteOrder);
                break;
            }
            case COLUMN_TYPE_UINT16: {
                obj = DecodeUtils.bytesToUInt16(reader.read(2), this.byteOrder);
                break;
            }
            case COLUMN_TYPE_INT32: 
            case COLUMN_TYPE_UINT32: {
                obj = DecodeUtils.bytesToInt32(reader.read(4), this.byteOrder);
                break;
            }
            case COLUMN_TYPE_INT64: 
            case COLUMN_TYPE_UINT64: {
                obj = DecodeUtils.bytesToInt64(reader.read(8), this.byteOrder);
                break;
            }
            case COLUMN_TYPE_FLOAT32: {
                obj = Float.valueOf(DecodeUtils.bytesToFloat(reader.read(4), this.byteOrder));
                break;
            }
            case COLUMN_TYPE_FLOAT64: {
                obj = DecodeUtils.bytesToDouble(reader.read(8), this.byteOrder);
                break;
            }
            case COLUMN_TYPE_DATE: {
                obj = this.bytesToDate(reader.read(4));
                break;
            }
            case COLUMN_TYPE_LOCALTIME: {
                obj = this.bytesToLocalTime(reader.read(8));
                break;
            }
            case COLUMN_TYPE_ZONEDTIME: {
                obj = this.bytesToZonedTime(reader.read(8));
                break;
            }
            case COLUMN_TYPE_LOCALDATETIME: {
                obj = this.bytesToLocalDateTime(reader.read(8));
                break;
            }
            case COLUMN_TYPE_ZONEDDATETIME: {
                obj = this.bytesToZonedDateTime(reader.read(8));
                break;
            }
            case COLUMN_TYPE_DURATION: {
                obj = this.bytesToDuration(reader.read(8));
                break;
            }
            default: {
                throw new RuntimeException("type is not basic:" + (Object)((Object)type));
            }
        }
        return obj;
    }

    private Object bytesToDecimal(BytesReader reader) {
        String decimalStr = reader.readSizedString(this.byteOrder);
        return this.stringToDecimal(decimalStr);
    }

    private Object stringToDecimal(String decimalStr) {
        if (decimalStr.equals("NaN") || decimalStr.equals("+Inf") || decimalStr.equals("-Inf")) {
            throw new NumberFormatException(decimalStr);
        }
        return new BigDecimal(decimalStr);
    }

    private Object decodeCompositeValue(BytesReader reader, ColumnType type) {
        switch (type) {
            case COLUMN_TYPE_NULL: {
                return null;
            }
            case COLUMN_TYPE_BOOL: {
                return DecodeUtils.bytesToBool(reader.read(1));
            }
            case COLUMN_TYPE_INT8: {
                return DecodeUtils.bytesToInt8(reader.read(1));
            }
            case COLUMN_TYPE_UINT8: {
                return DecodeUtils.bytesToUInt8(reader.read(1));
            }
            case COLUMN_TYPE_INT16: {
                return DecodeUtils.bytesToInt16(reader.read(2), this.byteOrder);
            }
            case COLUMN_TYPE_UINT16: {
                return DecodeUtils.bytesToUInt16(reader.read(2), this.byteOrder);
            }
            case COLUMN_TYPE_INT32: 
            case COLUMN_TYPE_UINT32: {
                return DecodeUtils.bytesToInt32(reader.read(4), this.byteOrder);
            }
            case COLUMN_TYPE_INT64: 
            case COLUMN_TYPE_UINT64: {
                return DecodeUtils.bytesToInt64(reader.read(8), this.byteOrder);
            }
            case COLUMN_TYPE_FLOAT32: {
                return Float.valueOf(DecodeUtils.bytesToFloat(reader.read(4), this.byteOrder));
            }
            case COLUMN_TYPE_FLOAT64: {
                return DecodeUtils.bytesToDouble(reader.read(8), this.byteOrder);
            }
            case COLUMN_TYPE_DATE: {
                return this.bytesToDate(reader.read(4));
            }
            case COLUMN_TYPE_LOCALDATETIME: {
                return this.bytesToLocalDateTime(reader.read(8));
            }
            case COLUMN_TYPE_ZONEDDATETIME: {
                return this.bytesToZonedDateTime(reader.read(8));
            }
            case COLUMN_TYPE_LOCALTIME: {
                return this.bytesToLocalTime(reader.read(8));
            }
            case COLUMN_TYPE_ZONEDTIME: {
                return this.bytesToZonedTime(reader.read(8));
            }
            case COLUMN_TYPE_DURATION: {
                return this.bytesToDuration(reader.read(8));
            }
            case COLUMN_TYPE_DECIMAL: {
                return new BigDecimal(reader.readSizedString(this.byteOrder));
            }
            case COLUMN_TYPE_STRING: {
                return reader.readSizedString(this.byteOrder);
            }
            case COLUMN_TYPE_LIST: {
                ColumnType eleType = ColumnType.getColumnType(DecodeUtils.bytesToInt8(reader.read(1)));
                int listSize = DecodeUtils.bytesToInt16(reader.read(2), this.byteOrder).shortValue();
                int nullBitSize = listSize % 8 == 0 ? listSize / 8 : listSize / 8 + 1;
                ByteString nullBitBytes = reader.read(nullBitSize);
                ArrayList<ValueWrapper> values = new ArrayList<ValueWrapper>();
                for (int i = 0; i < listSize; ++i) {
                    if ((nullBitBytes.byteAt(i / 8) & 1 << i % 8) == 0) {
                        values.add(null);
                        continue;
                    }
                    values.add(new ValueWrapper(this.decodeCompositeValue(reader, eleType), eleType));
                }
                return values;
            }
            case COLUMN_TYPE_RECORD: {
                int recordSize = DecodeUtils.bytesToInt16(reader.read(2), this.byteOrder).shortValue();
                HashMap<String, ValueWrapper> map = new HashMap<String, ValueWrapper>();
                for (int i = 0; i < recordSize; ++i) {
                    String fieldName = reader.readSizedString(this.byteOrder);
                    ColumnType fieldType = ColumnType.getColumnType(DecodeUtils.bytesToUInt8(reader.read(1)));
                    Object fieldValue = this.decodeCompositeValue(reader, fieldType);
                    map.put(fieldName, new ValueWrapper(fieldValue, fieldType));
                }
                return new NRecord(map);
            }
            case COLUMN_TYPE_NODE: {
                long nodeId = DecodeUtils.bytesToInt64(reader.read(8), this.byteOrder);
                int nodeTypeId = this.getNodeTypeIdFromNodeId(nodeId);
                int nodeGraphId = DecodeUtils.bytesToInt32(reader.read(4), this.byteOrder);
                int nodePropNum = DecodeUtils.bytesToInt16(reader.read(2), this.byteOrder).shortValue();
                HashMap<String, ValueWrapper> nodeProperties = new HashMap<String, ValueWrapper>();
                for (int i = 0; i < nodePropNum; ++i) {
                    String propName = reader.readSizedString(this.byteOrder);
                    ColumnType propType = ColumnType.getColumnType(DecodeUtils.bytesToUInt8(reader.read(1)));
                    Object propValue = this.decodeCompositeValue(reader, propType);
                    nodeProperties.put(propName, new ValueWrapper(propValue, propType));
                }
                return new Node(nodeGraphId, nodeTypeId, nodeId, nodeProperties, this.graphSchemas);
            }
            case COLUMN_TYPE_EDGE: {
                long srcNodeId = DecodeUtils.bytesToInt64(reader.read(8), this.byteOrder);
                long dstNodeId = DecodeUtils.bytesToInt64(reader.read(8), this.byteOrder);
                long rank = DecodeUtils.bytesToInt64(reader.read(8), this.byteOrder);
                int edgeGraphId = DecodeUtils.bytesToInt32(reader.read(4), this.byteOrder);
                int edgeTypeId = DecodeUtils.bytesToInt32(reader.read(4), this.byteOrder);
                int edgePropNum = DecodeUtils.bytesToInt16(reader.read(2), this.byteOrder).shortValue();
                HashMap<String, ValueWrapper> edgeProperties = new HashMap<String, ValueWrapper>();
                for (int i = 0; i < edgePropNum; ++i) {
                    String propName = reader.readSizedString(this.byteOrder);
                    ColumnType propType = ColumnType.getColumnType(DecodeUtils.bytesToUInt8(reader.read(1)));
                    Object propValue = this.decodeCompositeValue(reader, propType);
                    edgeProperties.put(propName, new ValueWrapper(propValue, propType));
                }
                return new Edge(edgeGraphId, edgeTypeId, rank, srcNodeId, dstNodeId, edgeProperties, this.graphSchemas);
            }
            case COLUMN_TYPE_PATH: {
                int elementNum = DecodeUtils.bytesToInt16(reader.read(2), this.byteOrder).shortValue();
                ArrayList<ValueWrapper> eleValues = new ArrayList<ValueWrapper>();
                for (int i = 0; i < elementNum; ++i) {
                    ColumnType elementType = ColumnType.getColumnType(DecodeUtils.bytesToUInt8(reader.read(1)));
                    Object element = this.decodeCompositeValue(reader, elementType);
                    eleValues.add(new ValueWrapper(element, elementType));
                }
                return new Path(eleValues);
            }
        }
        throw new RuntimeException("do not support type:" + (Object)((Object)type));
    }
}

