/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode.struct;

import com.google.protobuf.ByteString;
import com.vesoft.nebula.driver.graph.decode.BytesReader;
import com.vesoft.nebula.driver.graph.decode.ColumnType;
import com.vesoft.nebula.driver.graph.decode.DecodeUtils;
import java.nio.ByteOrder;

public class AnyHeader {
    private long chunkIndex;
    private long offset;

    public AnyHeader(ByteString data, ColumnType type, ByteOrder byteOrder) {
        switch (type) {
            case COLUMN_TYPE_NULL: 
            case COLUMN_TYPE_BOOL: 
            case COLUMN_TYPE_INT8: 
            case COLUMN_TYPE_UINT8: 
            case COLUMN_TYPE_INT16: 
            case COLUMN_TYPE_UINT16: 
            case COLUMN_TYPE_INT32: 
            case COLUMN_TYPE_UINT32: 
            case COLUMN_TYPE_INT64: 
            case COLUMN_TYPE_UINT64: 
            case COLUMN_TYPE_FLOAT32: 
            case COLUMN_TYPE_FLOAT64: 
            case COLUMN_TYPE_DATE: 
            case COLUMN_TYPE_LOCALTIME: 
            case COLUMN_TYPE_ZONEDTIME: 
            case COLUMN_TYPE_LOCALDATETIME: 
            case COLUMN_TYPE_ZONEDDATETIME: 
            case COLUMN_TYPE_DURATION: 
            case COLUMN_TYPE_DECIMAL: {
                break;
            }
            default: {
                BytesReader reader = new BytesReader(data);
                this.chunkIndex = DecodeUtils.bytesToUInt32(reader.read(4), byteOrder) + 1L;
                this.offset = DecodeUtils.bytesToUInt32(reader.read(4), byteOrder);
            }
        }
    }

    public long getChunkIndex() {
        return this.chunkIndex;
    }

    public long getOffset() {
        return this.offset;
    }
}

