/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import com.vesoft.nebula.driver.graph.utils.ZoneOffsetUtil;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

public class NZonedDateTime {
    private final LocalDateTime localDateTime;
    private final ZoneOffset zoneOffset;

    public NZonedDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        this.localDateTime = localDateTime;
        this.zoneOffset = zoneOffset;
    }

    public int getYear() {
        return this.localDateTime.getYear();
    }

    public int getMonth() {
        return this.localDateTime.getMonth().getValue();
    }

    public int getDay() {
        return this.localDateTime.getDayOfMonth();
    }

    public int getHour() {
        return this.localDateTime.getHour();
    }

    public int getMinute() {
        return this.localDateTime.getMinute();
    }

    public int getSecond() {
        return this.localDateTime.getSecond();
    }

    public int getMicrosec() {
        return this.localDateTime.getNano() / 1000;
    }

    public int getOffset() {
        return this.zoneOffset.getTotalSeconds();
    }

    public String toString() {
        return String.format("%d-%02d-%02dT%02d:%02d:%02d.%06d%s", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getMicrosec(), ZoneOffsetUtil.buildOffset(this.getOffset()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NZonedDateTime that = (NZonedDateTime)o;
        return this.getYear() == that.getYear() && this.getMonth() == that.getMonth() && this.getDay() == that.getDay() && this.getHour() == that.getHour() && this.getMinute() == that.getMinute() && this.getSecond() == that.getSecond() && this.getMicrosec() == that.getMicrosec() && this.getOffset() == that.getOffset();
    }

    public int hashCode() {
        return Objects.hash(this.localDateTime, this.getOffset());
    }
}

