/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.ExternalSpaceServiceType;
import com.vesoft.nebula.meta.ServiceClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListSpaceServiceClientsResp
implements TBase,
Serializable,
Cloneable,
Comparable<ListSpaceServiceClientsResp> {
    private static final TStruct STRUCT_DESC = new TStruct("ListSpaceServiceClientsResp");
    private static final TField CODE_FIELD_DESC = new TField("code", 8, 1);
    private static final TField LEADER_FIELD_DESC = new TField("leader", 12, 2);
    private static final TField CLIENTS_FIELD_DESC = new TField("clients", 13, 3);
    public ErrorCode code;
    public HostAddr leader;
    public Map<ExternalSpaceServiceType, List<ServiceClient>> clients;
    public static final int CODE = 1;
    public static final int LEADER = 2;
    public static final int CLIENTS = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ListSpaceServiceClientsResp() {
    }

    public ListSpaceServiceClientsResp(ErrorCode code, HostAddr leader, Map<ExternalSpaceServiceType, List<ServiceClient>> clients) {
        this();
        this.code = code;
        this.leader = leader;
        this.clients = clients;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListSpaceServiceClientsResp(ListSpaceServiceClientsResp other) {
        if (other.isSetCode()) {
            this.code = TBaseHelper.deepCopy(other.code);
        }
        if (other.isSetLeader()) {
            this.leader = TBaseHelper.deepCopy(other.leader);
        }
        if (other.isSetClients()) {
            this.clients = TBaseHelper.deepCopy(other.clients);
        }
    }

    @Override
    public ListSpaceServiceClientsResp deepCopy() {
        return new ListSpaceServiceClientsResp(this);
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public ListSpaceServiceClientsResp setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public void unsetCode() {
        this.code = null;
    }

    public boolean isSetCode() {
        return this.code != null;
    }

    public void setCodeIsSet(boolean __value) {
        if (!__value) {
            this.code = null;
        }
    }

    public HostAddr getLeader() {
        return this.leader;
    }

    public ListSpaceServiceClientsResp setLeader(HostAddr leader) {
        this.leader = leader;
        return this;
    }

    public void unsetLeader() {
        this.leader = null;
    }

    public boolean isSetLeader() {
        return this.leader != null;
    }

    public void setLeaderIsSet(boolean __value) {
        if (!__value) {
            this.leader = null;
        }
    }

    public Map<ExternalSpaceServiceType, List<ServiceClient>> getClients() {
        return this.clients;
    }

    public ListSpaceServiceClientsResp setClients(Map<ExternalSpaceServiceType, List<ServiceClient>> clients) {
        this.clients = clients;
        return this;
    }

    public void unsetClients() {
        this.clients = null;
    }

    public boolean isSetClients() {
        return this.clients != null;
    }

    public void setClientsIsSet(boolean __value) {
        if (!__value) {
            this.clients = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetCode();
                    break;
                }
                this.setCode((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetLeader();
                    break;
                }
                this.setLeader((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetClients();
                    break;
                }
                this.setClients((Map)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCode();
            }
            case 2: {
                return this.getLeader();
            }
            case 3: {
                return this.getClients();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof ListSpaceServiceClientsResp)) {
            return false;
        }
        ListSpaceServiceClientsResp that = (ListSpaceServiceClientsResp)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetCode(), that.isSetCode(), this.code, that.code)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader(), that.isSetLeader(), this.leader, that.leader)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetClients(), that.isSetClients(), this.clients, that.clients);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.code, this.leader, this.clients});
    }

    @Override
    public int compareTo(ListSpaceServiceClientsResp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCode()).compareTo(other.isSetCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.code, other.code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader()).compareTo(other.isSetLeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader, other.leader);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetClients()).compareTo(other.isSetClients());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.clients, other.clients);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.leader = new HostAddr();
                        this.leader.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 13) {
                        TMap _map356 = iprot.readMapBegin();
                        this.clients = new HashMap<ExternalSpaceServiceType, List<ServiceClient>>(Math.max(0, 2 * _map356.size));
                        int _i357 = 0;
                        while (_map356.size < 0 ? iprot.peekMap() : _i357 < _map356.size) {
                            ExternalSpaceServiceType _key358 = ExternalSpaceServiceType.findByValue(iprot.readI32());
                            TList _list360 = iprot.readListBegin();
                            ArrayList<ServiceClient> _val359 = new ArrayList<ServiceClient>(Math.max(0, _list360.size));
                            int _i361 = 0;
                            while (_list360.size < 0 ? iprot.peekList() : _i361 < _list360.size) {
                                ServiceClient _elem362 = new ServiceClient();
                                _elem362.read(iprot);
                                _val359.add(_elem362);
                                ++_i361;
                            }
                            iprot.readListEnd();
                            this.clients.put(_key358, _val359);
                            ++_i357;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.code != null) {
            oprot.writeFieldBegin(CODE_FIELD_DESC);
            oprot.writeI32(this.code == null ? 0 : this.code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.leader != null) {
            oprot.writeFieldBegin(LEADER_FIELD_DESC);
            this.leader.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.clients != null) {
            oprot.writeFieldBegin(CLIENTS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 15, this.clients.size()));
            for (Map.Entry<ExternalSpaceServiceType, List<ServiceClient>> _iter363 : this.clients.entrySet()) {
                oprot.writeI32(_iter363.getKey() == null ? 0 : _iter363.getKey().getValue());
                oprot.writeListBegin(new TList(12, _iter363.getValue().size()));
                for (ServiceClient _iter364 : _iter363.getValue()) {
                    _iter364.write(oprot);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ListSpaceServiceClientsResp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCode() == null) {
            sb.append("null");
        } else {
            String code_name;
            String string = code_name = this.getCode() == null ? "null" : this.getCode().name();
            if (code_name != null) {
                sb.append(code_name);
                sb.append(" (");
            }
            sb.append(this.getCode());
            if (code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("clients");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getClients() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getClients(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("code", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("leader", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("clients", 3, new MapMetaData(13, new FieldValueMetaData(8), new ListMetaData(15, new StructMetaData(12, ServiceClient.class)))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ListSpaceServiceClientsResp.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode code;
        private HostAddr leader;
        private Map<ExternalSpaceServiceType, List<ServiceClient>> clients;

        public Builder setCode(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder setLeader(HostAddr leader) {
            this.leader = leader;
            return this;
        }

        public Builder setClients(Map<ExternalSpaceServiceType, List<ServiceClient>> clients) {
            this.clients = clients;
            return this;
        }

        public ListSpaceServiceClientsResp build() {
            ListSpaceServiceClientsResp result = new ListSpaceServiceClientsResp();
            result.setCode(this.code);
            result.setLeader(this.leader);
            result.setClients(this.clients);
            return result;
        }
    }
}

