/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Logger {
    private static Method getLogger;
    private final LoggerFunction errorFn;
    private final LoggerFunction warningFn;
    private final String name;

    private Logger(String name, LoggerFunction errorFn, LoggerFunction warningFn) {
        this.name = name;
        this.errorFn = errorFn;
        this.warningFn = warningFn;
    }

    public static Logger getLogger(final String name) {
        LoggerFunction warningFn;
        LoggerFunction errorFn;
        try {
            final Object logger = getLogger.invoke(null, name);
            final Method err = logger.getClass().getDeclaredMethod("error", String.class);
            final Method warning = logger.getClass().getDeclaredMethod("warn", String.class);
            errorFn = new LoggerFunction(){

                @Override
                public void apply(String msg) {
                    try {
                        err.invoke(logger, msg);
                    }
                    catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        System.err.println(name + " ERROR: " + msg);
                    }
                }
            };
            warningFn = new LoggerFunction(){

                @Override
                public void apply(String msg) {
                    try {
                        warning.invoke(logger, msg);
                    }
                    catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        System.err.println(name + " WRNING: " + msg);
                    }
                }
            };
        }
        catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            errorFn = new LoggerFunction(){

                @Override
                public void apply(String msg) {
                    System.err.println(name + " ERROR: " + msg);
                }
            };
            warningFn = new LoggerFunction(){

                @Override
                public void apply(String msg) {
                    System.err.println(name + " WARNING: " + msg);
                }
            };
        }
        return new Logger(name, errorFn, warningFn);
    }

    public void error(String msg) {
        this.errorFn.apply(msg);
    }

    public void error(String msg, Object other) {
        this.errorFn.apply(msg + other.toString());
    }

    public void warn(String msg) {
        this.warningFn.apply(msg);
    }

    public void warn(String msg, Object other) {
        this.errorFn.apply(msg + other.toString());
    }

    static {
        try {
            getLogger = Class.forName("org.slf4j.LoggerFactory").getDeclaredMethod("getLogger", String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static interface LoggerFunction {
        public void apply(String var1);
    }
}

