/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.SyncInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListSyncStatusResp
implements TBase,
Serializable,
Cloneable,
Comparable<ListSyncStatusResp> {
    private static final TStruct STRUCT_DESC = new TStruct("ListSyncStatusResp");
    private static final TField CODE_FIELD_DESC = new TField("code", 8, 1);
    private static final TField LEADER_FIELD_DESC = new TField("leader", 12, 2);
    private static final TField SYNC_INFOS_FIELD_DESC = new TField("sync_infos", 13, 3);
    public ErrorCode code;
    public HostAddr leader;
    public Map<Integer, SyncInfo> sync_infos;
    public static final int CODE = 1;
    public static final int LEADER = 2;
    public static final int SYNC_INFOS = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ListSyncStatusResp() {
    }

    public ListSyncStatusResp(ErrorCode code, HostAddr leader, Map<Integer, SyncInfo> sync_infos) {
        this();
        this.code = code;
        this.leader = leader;
        this.sync_infos = sync_infos;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListSyncStatusResp(ListSyncStatusResp other) {
        if (other.isSetCode()) {
            this.code = TBaseHelper.deepCopy(other.code);
        }
        if (other.isSetLeader()) {
            this.leader = TBaseHelper.deepCopy(other.leader);
        }
        if (other.isSetSync_infos()) {
            this.sync_infos = TBaseHelper.deepCopy(other.sync_infos);
        }
    }

    @Override
    public ListSyncStatusResp deepCopy() {
        return new ListSyncStatusResp(this);
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public ListSyncStatusResp setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public void unsetCode() {
        this.code = null;
    }

    public boolean isSetCode() {
        return this.code != null;
    }

    public void setCodeIsSet(boolean __value) {
        if (!__value) {
            this.code = null;
        }
    }

    public HostAddr getLeader() {
        return this.leader;
    }

    public ListSyncStatusResp setLeader(HostAddr leader) {
        this.leader = leader;
        return this;
    }

    public void unsetLeader() {
        this.leader = null;
    }

    public boolean isSetLeader() {
        return this.leader != null;
    }

    public void setLeaderIsSet(boolean __value) {
        if (!__value) {
            this.leader = null;
        }
    }

    public Map<Integer, SyncInfo> getSync_infos() {
        return this.sync_infos;
    }

    public ListSyncStatusResp setSync_infos(Map<Integer, SyncInfo> sync_infos) {
        this.sync_infos = sync_infos;
        return this;
    }

    public void unsetSync_infos() {
        this.sync_infos = null;
    }

    public boolean isSetSync_infos() {
        return this.sync_infos != null;
    }

    public void setSync_infosIsSet(boolean __value) {
        if (!__value) {
            this.sync_infos = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetCode();
                    break;
                }
                this.setCode((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetLeader();
                    break;
                }
                this.setLeader((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetSync_infos();
                    break;
                }
                this.setSync_infos((Map)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCode();
            }
            case 2: {
                return this.getLeader();
            }
            case 3: {
                return this.getSync_infos();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof ListSyncStatusResp)) {
            return false;
        }
        ListSyncStatusResp that = (ListSyncStatusResp)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetCode(), that.isSetCode(), this.code, that.code)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader(), that.isSetLeader(), this.leader, that.leader)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetSync_infos(), that.isSetSync_infos(), this.sync_infos, that.sync_infos);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.code, this.leader, this.sync_infos});
    }

    @Override
    public int compareTo(ListSyncStatusResp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCode()).compareTo(other.isSetCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.code, other.code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader()).compareTo(other.isSetLeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader, other.leader);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSync_infos()).compareTo(other.isSetSync_infos());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.sync_infos, other.sync_infos);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.leader = new HostAddr();
                        this.leader.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 13) {
                        TMap _map270 = iprot.readMapBegin();
                        this.sync_infos = new HashMap<Integer, SyncInfo>(Math.max(0, 2 * _map270.size));
                        int _i271 = 0;
                        while (_map270.size < 0 ? iprot.peekMap() : _i271 < _map270.size) {
                            int _key272 = iprot.readI32();
                            SyncInfo _val273 = new SyncInfo();
                            _val273.read(iprot);
                            this.sync_infos.put(_key272, _val273);
                            ++_i271;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.code != null) {
            oprot.writeFieldBegin(CODE_FIELD_DESC);
            oprot.writeI32(this.code == null ? 0 : this.code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.leader != null) {
            oprot.writeFieldBegin(LEADER_FIELD_DESC);
            this.leader.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.sync_infos != null) {
            oprot.writeFieldBegin(SYNC_INFOS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 12, this.sync_infos.size()));
            for (Map.Entry<Integer, SyncInfo> _iter274 : this.sync_infos.entrySet()) {
                oprot.writeI32(_iter274.getKey());
                _iter274.getValue().write(oprot);
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ListSyncStatusResp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCode() == null) {
            sb.append("null");
        } else {
            String code_name;
            String string = code_name = this.getCode() == null ? "null" : this.getCode().name();
            if (code_name != null) {
                sb.append(code_name);
                sb.append(" (");
            }
            sb.append(this.getCode());
            if (code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("sync_infos");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getSync_infos() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getSync_infos(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("code", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("leader", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("sync_infos", 3, new MapMetaData(13, new FieldValueMetaData(8), new StructMetaData(12, SyncInfo.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ListSyncStatusResp.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode code;
        private HostAddr leader;
        private Map<Integer, SyncInfo> sync_infos;

        public Builder setCode(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder setLeader(HostAddr leader) {
            this.leader = leader;
            return this;
        }

        public Builder setSync_infos(Map<Integer, SyncInfo> sync_infos) {
            this.sync_infos = sync_infos;
            return this;
        }

        public ListSyncStatusResp build() {
            ListSyncStatusResp result = new ListSyncStatusResp();
            result.setCode(this.code);
            result.setLeader(this.leader);
            result.setSync_infos(this.sync_infos);
            return result;
        }
    }
}

