/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.SetMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TSet;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ListMetaResp
implements TBase,
Serializable,
Cloneable,
Comparable<ListMetaResp> {
    private static final TStruct STRUCT_DESC = new TStruct("ListMetaResp");
    private static final TField CODE_FIELD_DESC = new TField("code", 8, 1);
    private static final TField LEADER_FIELD_DESC = new TField("leader", 12, 2);
    private static final TField HOSTS_FIELD_DESC = new TField("hosts", 14, 3);
    public ErrorCode code;
    public HostAddr leader;
    public Set<HostAddr> hosts;
    public static final int CODE = 1;
    public static final int LEADER = 2;
    public static final int HOSTS = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ListMetaResp() {
    }

    public ListMetaResp(ErrorCode code, HostAddr leader, Set<HostAddr> hosts) {
        this();
        this.code = code;
        this.leader = leader;
        this.hosts = hosts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListMetaResp(ListMetaResp other) {
        if (other.isSetCode()) {
            this.code = TBaseHelper.deepCopy(other.code);
        }
        if (other.isSetLeader()) {
            this.leader = TBaseHelper.deepCopy(other.leader);
        }
        if (other.isSetHosts()) {
            this.hosts = TBaseHelper.deepCopy(other.hosts);
        }
    }

    @Override
    public ListMetaResp deepCopy() {
        return new ListMetaResp(this);
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public ListMetaResp setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public void unsetCode() {
        this.code = null;
    }

    public boolean isSetCode() {
        return this.code != null;
    }

    public void setCodeIsSet(boolean __value) {
        if (!__value) {
            this.code = null;
        }
    }

    public HostAddr getLeader() {
        return this.leader;
    }

    public ListMetaResp setLeader(HostAddr leader) {
        this.leader = leader;
        return this;
    }

    public void unsetLeader() {
        this.leader = null;
    }

    public boolean isSetLeader() {
        return this.leader != null;
    }

    public void setLeaderIsSet(boolean __value) {
        if (!__value) {
            this.leader = null;
        }
    }

    public Set<HostAddr> getHosts() {
        return this.hosts;
    }

    public ListMetaResp setHosts(Set<HostAddr> hosts) {
        this.hosts = hosts;
        return this;
    }

    public void unsetHosts() {
        this.hosts = null;
    }

    public boolean isSetHosts() {
        return this.hosts != null;
    }

    public void setHostsIsSet(boolean __value) {
        if (!__value) {
            this.hosts = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetCode();
                    break;
                }
                this.setCode((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetLeader();
                    break;
                }
                this.setLeader((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetHosts();
                    break;
                }
                this.setHosts((Set)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCode();
            }
            case 2: {
                return this.getLeader();
            }
            case 3: {
                return this.getHosts();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof ListMetaResp)) {
            return false;
        }
        ListMetaResp that = (ListMetaResp)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetCode(), that.isSetCode(), this.code, that.code)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader(), that.isSetLeader(), this.leader, that.leader)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetHosts(), that.isSetHosts(), this.hosts, that.hosts);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.code, this.leader, this.hosts});
    }

    @Override
    public int compareTo(ListMetaResp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCode()).compareTo(other.isSetCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.code, other.code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader()).compareTo(other.isSetLeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader, other.leader);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHosts()).compareTo(other.isSetHosts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.hosts, other.hosts);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.leader = new HostAddr();
                        this.leader.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 14) {
                        TSet _set463 = iprot.readSetBegin();
                        this.hosts = new HashSet<HostAddr>(Math.max(0, 2 * _set463.size));
                        int _i464 = 0;
                        while (_set463.size < 0 ? iprot.peekSet() : _i464 < _set463.size) {
                            HostAddr _elem465 = new HostAddr();
                            _elem465.read(iprot);
                            this.hosts.add(_elem465);
                            ++_i464;
                        }
                        iprot.readSetEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.code != null) {
            oprot.writeFieldBegin(CODE_FIELD_DESC);
            oprot.writeI32(this.code == null ? 0 : this.code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.leader != null) {
            oprot.writeFieldBegin(LEADER_FIELD_DESC);
            this.leader.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.hosts != null) {
            oprot.writeFieldBegin(HOSTS_FIELD_DESC);
            oprot.writeSetBegin(new TSet(12, this.hosts.size()));
            for (HostAddr _iter466 : this.hosts) {
                _iter466.write(oprot);
            }
            oprot.writeSetEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ListMetaResp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCode() == null) {
            sb.append("null");
        } else {
            String code_name;
            String string = code_name = this.getCode() == null ? "null" : this.getCode().name();
            if (code_name != null) {
                sb.append(code_name);
                sb.append(" (");
            }
            sb.append(this.getCode());
            if (code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("hosts");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getHosts() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getHosts(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("code", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("leader", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("hosts", 3, new SetMetaData(14, new StructMetaData(12, HostAddr.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ListMetaResp.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode code;
        private HostAddr leader;
        private Set<HostAddr> hosts;

        public Builder setCode(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder setLeader(HostAddr leader) {
            this.leader = leader;
            return this;
        }

        public Builder setHosts(Set<HostAddr> hosts) {
            this.hosts = hosts;
            return this;
        }

        public ListMetaResp build() {
            ListMetaResp result = new ListMetaResp();
            result.setCode(this.code);
            result.setLeader(this.leader);
            result.setHosts(this.hosts);
            return result;
        }
    }
}

