/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage;

import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.storage.GraphStorageConnection;
import com.vesoft.nebula.client.storage.StoragePoolConfig;
import java.io.Serializable;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageConnPoolFactory
implements KeyedPooledObjectFactory<HostAddress, GraphStorageConnection>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageConnPoolFactory.class);
    private final StoragePoolConfig config;

    public StorageConnPoolFactory(StoragePoolConfig config) {
        this.config = config;
    }

    public PooledObject<GraphStorageConnection> makeObject(HostAddress address) throws Exception {
        GraphStorageConnection connection = new GraphStorageConnection();
        return new DefaultPooledObject((Object)connection);
    }

    public void destroyObject(HostAddress hostAndPort, PooledObject<GraphStorageConnection> pooledObject) {
        ((GraphStorageConnection)pooledObject.getObject()).close();
    }

    public boolean validateObject(HostAddress hostAndPort, PooledObject<GraphStorageConnection> pooledObject) {
        GraphStorageConnection connection = (GraphStorageConnection)pooledObject.getObject();
        if (connection == null) {
            return false;
        }
        try {
            return connection.transport.isOpen();
        }
        catch (Exception e) {
            LOGGER.warn(String.format("storage connection with %s:%d is not open", hostAndPort.getHost(), hostAndPort.getPort()), (Throwable)e);
            return false;
        }
    }

    public void activateObject(HostAddress address, PooledObject<GraphStorageConnection> pooledObject) throws Exception {
        ((GraphStorageConnection)pooledObject.getObject()).open(address, this.config.getTimeout(), this.config.isEnableSSL(), this.config.getSslParam());
    }

    public void passivateObject(HostAddress hostAndPort, PooledObject<GraphStorageConnection> pooledObject) {
        pooledObject.markReturning();
    }
}

