/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.meta.RoleType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RoleItem
implements TBase,
Serializable,
Cloneable,
Comparable<RoleItem> {
    private static final TStruct STRUCT_DESC = new TStruct("RoleItem");
    private static final TField USER_ID_FIELD_DESC = new TField("user_id", 11, 1);
    private static final TField SPACE_ID_FIELD_DESC = new TField("space_id", 8, 2);
    private static final TField ROLE_TYPE_FIELD_DESC = new TField("role_type", 8, 3);
    public byte[] user_id;
    public int space_id;
    public RoleType role_type;
    public static final int USER_ID = 1;
    public static final int SPACE_ID = 2;
    public static final int ROLE_TYPE = 3;
    private static final int __SPACE_ID_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public RoleItem() {
    }

    public RoleItem(byte[] user_id, int space_id, RoleType role_type) {
        this();
        this.user_id = user_id;
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        this.role_type = role_type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public RoleItem(RoleItem other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetUser_id()) {
            this.user_id = TBaseHelper.deepCopy(other.user_id);
        }
        this.space_id = TBaseHelper.deepCopy(other.space_id);
        if (other.isSetRole_type()) {
            this.role_type = TBaseHelper.deepCopy(other.role_type);
        }
    }

    @Override
    public RoleItem deepCopy() {
        return new RoleItem(this);
    }

    public byte[] getUser_id() {
        return this.user_id;
    }

    public RoleItem setUser_id(byte[] user_id) {
        this.user_id = user_id;
        return this;
    }

    public void unsetUser_id() {
        this.user_id = null;
    }

    public boolean isSetUser_id() {
        return this.user_id != null;
    }

    public void setUser_idIsSet(boolean __value) {
        if (!__value) {
            this.user_id = null;
        }
    }

    public int getSpace_id() {
        return this.space_id;
    }

    public RoleItem setSpace_id(int space_id) {
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        return this;
    }

    public void unsetSpace_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetSpace_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setSpace_idIsSet(boolean __value) {
        this.__isset_bit_vector.set(0, __value);
    }

    public RoleType getRole_type() {
        return this.role_type;
    }

    public RoleItem setRole_type(RoleType role_type) {
        this.role_type = role_type;
        return this;
    }

    public void unsetRole_type() {
        this.role_type = null;
    }

    public boolean isSetRole_type() {
        return this.role_type != null;
    }

    public void setRole_typeIsSet(boolean __value) {
        if (!__value) {
            this.role_type = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetUser_id();
                    break;
                }
                this.setUser_id((byte[])__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetSpace_id();
                    break;
                }
                this.setSpace_id((Integer)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetRole_type();
                    break;
                }
                this.setRole_type((RoleType)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getUser_id();
            }
            case 2: {
                return new Integer(this.getSpace_id());
            }
            case 3: {
                return this.getRole_type();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof RoleItem)) {
            return false;
        }
        RoleItem that = (RoleItem)_that;
        if (!TBaseHelper.equalsSlow(this.isSetUser_id(), that.isSetUser_id(), this.user_id, that.user_id)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.space_id, that.space_id)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetRole_type(), that.isSetRole_type(), this.role_type, that.role_type);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.user_id, this.space_id, this.role_type});
    }

    @Override
    public int compareTo(RoleItem other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetUser_id()).compareTo(other.isSetUser_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.user_id, other.user_id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSpace_id()).compareTo(other.isSetSpace_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.space_id, other.space_id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRole_type()).compareTo(other.isSetRole_type());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.role_type, other.role_type);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 11) {
                        this.user_id = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 8) {
                        this.space_id = iprot.readI32();
                        this.setSpace_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 8) {
                        this.role_type = RoleType.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.user_id != null) {
            oprot.writeFieldBegin(USER_ID_FIELD_DESC);
            oprot.writeBinary(this.user_id);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SPACE_ID_FIELD_DESC);
        oprot.writeI32(this.space_id);
        oprot.writeFieldEnd();
        if (this.role_type != null) {
            oprot.writeFieldBegin(ROLE_TYPE_FIELD_DESC);
            oprot.writeI32(this.role_type == null ? 0 : this.role_type.getValue());
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("RoleItem");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("user_id");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getUser_id() == null) {
            sb.append("null");
        } else {
            int __user_id_size = Math.min(this.getUser_id().length, 128);
            for (int i = 0; i < __user_id_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getUser_id()[i]).length() > 1 ? Integer.toHexString(this.getUser_id()[i]).substring(Integer.toHexString(this.getUser_id()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getUser_id()[i]).toUpperCase());
            }
            if (this.getUser_id().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("space_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getSpace_id(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("role_type");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getRole_type() == null) {
            sb.append("null");
        } else {
            String role_type_name;
            String string = role_type_name = this.getRole_type() == null ? "null" : this.getRole_type().name();
            if (role_type_name != null) {
                sb.append(role_type_name);
                sb.append(" (");
            }
            sb.append(this.getRole_type());
            if (role_type_name != null) {
                sb.append(")");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("user_id", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("space_id", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(3, new FieldMetaData("role_type", 3, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(RoleItem.class, metaDataMap);
    }

    public static class Builder {
        private byte[] user_id;
        private int space_id;
        private RoleType role_type;
        BitSet __optional_isset = new BitSet(1);

        public Builder setUser_id(byte[] user_id) {
            this.user_id = user_id;
            return this;
        }

        public Builder setSpace_id(int space_id) {
            this.space_id = space_id;
            this.__optional_isset.set(0, true);
            return this;
        }

        public Builder setRole_type(RoleType role_type) {
            this.role_type = role_type;
            return this;
        }

        public RoleItem build() {
            RoleItem result = new RoleItem();
            result.setUser_id(this.user_id);
            if (this.__optional_isset.get(0)) {
                result.setSpace_id(this.space_id);
            }
            result.setRole_type(this.role_type);
            return result;
        }
    }
}

