/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.vesoft.nebula.DataSet;
import com.vesoft.nebula.Date;
import com.vesoft.nebula.DateTime;
import com.vesoft.nebula.Duration;
import com.vesoft.nebula.Edge;
import com.vesoft.nebula.Geography;
import com.vesoft.nebula.NList;
import com.vesoft.nebula.NMap;
import com.vesoft.nebula.NSet;
import com.vesoft.nebula.NullType;
import com.vesoft.nebula.Path;
import com.vesoft.nebula.Time;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.Vertex;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.AuthResult;
import com.vesoft.nebula.client.graph.net.NebulaPool;
import com.vesoft.nebula.client.graph.net.SyncConnection;
import com.vesoft.nebula.graph.ExecutionResponse;
import com.vesoft.nebula.util.ReflectUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session
implements Serializable,
AutoCloseable {
    private static final long serialVersionUID = -8855886967097862376L;
    private final long sessionID;
    private final int timezoneOffset;
    private SyncConnection connection;
    private final NebulaPool pool;
    private final Boolean retryConnect;
    private final AtomicBoolean connectionIsBroken = new AtomicBoolean(false);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static Map<Class<?>, Setter> LEAF_TYPE_AND_SETTER = new HashMap<Class<?>, Setter>(){
        {
            this.put(Value.class, param -> param);
            this.put(Boolean.class, Value::bVal);
            this.put(Integer.class, Value::iVal);
            this.put(Short.class, Value::iVal);
            this.put(Byte.class, Value::iVal);
            this.put(Long.class, Value::iVal);
            this.put(Float.class, Value::fVal);
            this.put(Double.class, Value::fVal);
            this.put(byte[].class, Value::sVal);
            this.put(Byte[].class, Value::sVal);
            this.put(String.class, param -> Value.sVal(param.getBytes()));
            this.put(Date.class, Value::dVal);
            this.put(Time.class, Value::tVal);
            this.put(DateTime.class, Value::dtVal);
            this.put(Vertex.class, Value::vVal);
            this.put(Edge.class, Value::eVal);
            this.put(Path.class, Value::pVal);
            this.put(NList.class, Value::lVal);
            this.put(NMap.class, Value::mVal);
            this.put(NSet.class, Value::uVal);
            this.put(DataSet.class, Value::gVal);
            this.put(Geography.class, Value::ggVal);
            this.put(Duration.class, Value::duVal);
        }
    };
    public static Map<Class<?>, Setter> COMPLEX_TYPE_AND_SETTER = new LinkedHashMap<Class<?>, Setter>(){
        {
            this.put(Collection.class, collection -> {
                Value value = new Value();
                ArrayList list = new ArrayList();
                collection.forEach((? super T el) -> list.add(Session.value2Nvalue(el)));
                value.setLVal(Session.list2Nlist(list));
                return value;
            });
            this.put(Map.class, map -> {
                Value value = new Value();
                HashMap valueMap = new HashMap();
                map.forEach((k, v) -> valueMap.put(k, Session.value2Nvalue(v)));
                value.setMVal(Session.map2Nmap(valueMap));
                return value;
            });
            this.put(java.util.Date.class, date -> {
                Calendar calendar = new Calendar.Builder().setInstant((java.util.Date)date).build();
                return Value.dtVal(new DateTime(new Short(String.valueOf(calendar.get(1))), new Byte(String.valueOf(calendar.get(2))), new Byte(String.valueOf(calendar.get(5))), new Byte(String.valueOf(calendar.get(10))), new Byte(String.valueOf(calendar.get(12))), new Byte(String.valueOf(calendar.get(13))), new Short(String.valueOf(calendar.get(14))).shortValue()));
            });
            this.put(Object.class, obj -> {
                Field[] declaredFields;
                Value value = new Value();
                HashMap<String, Value> pojoFields = new HashMap<String, Value>();
                Class<?> paramType = obj.getClass();
                for (Field declaredField : declaredFields = paramType.getDeclaredFields()) {
                    pojoFields.put(declaredField.getName(), Session.value2Nvalue(ReflectUtil.getValue(obj, declaredField)));
                }
                value.setMVal(Session.map2Nmap(pojoFields));
                return value;
            });
        }
    };

    public Session(SyncConnection connection, AuthResult authResult, NebulaPool connPool, Boolean retryConnect) {
        this.connection = connection;
        this.sessionID = authResult.getSessionId();
        this.timezoneOffset = authResult.getTimezoneOffset();
        this.pool = connPool;
        this.retryConnect = retryConnect;
    }

    public synchronized ResultSet execute(String stmt) throws IOErrorException {
        return this.executeWithParameter(stmt, Collections.EMPTY_MAP);
    }

    public synchronized ResultSet executeWithParameter(String stmt, Map<String, Object> parameterMap) throws IOErrorException {
        if (this.connection == null) {
            throw new IOErrorException(2, "The session was released, couldn't use again.");
        }
        HashMap<byte[], Value> map = new HashMap<byte[], Value>();
        parameterMap.forEach((key, value) -> map.put(key.getBytes(), Session.value2Nvalue(value)));
        if (this.connectionIsBroken.get() && this.retryConnect.booleanValue()) {
            if (this.retryConnect()) {
                ExecutionResponse resp = this.connection.executeWithParameter(this.sessionID, stmt, map);
                return new ResultSet(resp, this.timezoneOffset);
            }
            throw new IOErrorException(1, "All servers are broken.");
        }
        try {
            ExecutionResponse resp = this.connection.executeWithParameter(this.sessionID, stmt, map);
            return new ResultSet(resp, this.timezoneOffset);
        }
        catch (IOErrorException ie) {
            if (ie.getType() == 2) {
                this.connectionIsBroken.set(true);
                this.pool.updateServerStatus();
                if (this.retryConnect.booleanValue()) {
                    if (this.retryConnect()) {
                        this.connectionIsBroken.set(false);
                        ExecutionResponse resp = this.connection.executeWithParameter(this.sessionID, stmt, map);
                        return new ResultSet(resp, this.timezoneOffset);
                    }
                    this.connectionIsBroken.set(true);
                    throw new IOErrorException(1, "All servers are broken.");
                }
            }
            throw ie;
        }
    }

    public synchronized String executeJson(String stmt) throws IOErrorException {
        return this.executeJsonWithParameter(stmt, Collections.EMPTY_MAP);
    }

    public synchronized String executeJsonWithParameter(String stmt, Map<String, Object> parameterMap) throws IOErrorException {
        if (this.connection == null) {
            throw new IOErrorException(2, "The session was released, couldn't use again.");
        }
        HashMap<byte[], Value> map = new HashMap<byte[], Value>();
        parameterMap.entrySet().stream().forEach(x -> map.put(((String)x.getKey()).getBytes(), Session.value2Nvalue(x.getValue())));
        if (this.connectionIsBroken.get() && this.retryConnect.booleanValue()) {
            if (this.retryConnect()) {
                return this.connection.executeJsonWithParameter(this.sessionID, stmt, map);
            }
            throw new IOErrorException(1, "All servers are broken.");
        }
        try {
            return this.connection.executeJsonWithParameter(this.sessionID, stmt, map);
        }
        catch (IOErrorException ie) {
            if (ie.getType() == 2) {
                this.connectionIsBroken.set(true);
                this.pool.updateServerStatus();
                if (this.retryConnect.booleanValue()) {
                    if (this.retryConnect()) {
                        this.connectionIsBroken.set(false);
                        return this.connection.executeJsonWithParameter(this.sessionID, stmt, map);
                    }
                    this.connectionIsBroken.set(true);
                    throw new IOErrorException(1, "All servers are broken.");
                }
            }
            throw ie;
        }
    }

    public synchronized boolean ping() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.ping();
    }

    public synchronized boolean pingSession() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.ping(this.sessionID);
    }

    public synchronized void release() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.signout(this.sessionID);
            this.pool.returnConnection(this.connection);
        }
        catch (Exception e) {
            this.log.warn("Release session or return object to pool failed:" + e.getMessage());
        }
        this.connection = null;
    }

    public synchronized HostAddress getGraphHost() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getServerAddress();
    }

    public long getSessionID() {
        return this.sessionID;
    }

    private boolean retryConnect() {
        try {
            this.pool.setInvalidateConnection(this.connection);
            SyncConnection newConn = this.pool.getConnection();
            if (newConn == null) {
                this.log.error("Get connection object failed.");
                return false;
            }
            this.connection = newConn;
            return true;
        }
        catch (Exception e) {
            this.log.error("Reconnected failed: " + e);
            return false;
        }
    }

    private static NList list2Nlist(List<Object> list) throws UnsupportedOperationException {
        NList nlist = new NList(new ArrayList<Value>());
        for (Object item : list) {
            nlist.values.add(Session.value2Nvalue(item));
        }
        return nlist;
    }

    private static NMap map2Nmap(Map<String, Object> map) throws UnsupportedOperationException {
        NMap nmap = new NMap(new HashMap<byte[], Value>());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            nmap.kvs.put(entry.getKey().getBytes(), Session.value2Nvalue(entry.getValue()));
        }
        return nmap;
    }

    public static Value value2Nvalue(Object value) throws UnsupportedOperationException {
        try {
            if (value == null) {
                Value nullValue = new Value();
                nullValue.setNVal(NullType.__NULL__);
                return nullValue;
            }
            Class<?> type = value.getClass();
            Setter setter = LEAF_TYPE_AND_SETTER.get(type);
            if (setter != null) {
                return setter.set(value);
            }
            for (Class<?> parentType : COMPLEX_TYPE_AND_SETTER.keySet()) {
                if (!ReflectUtil.isCurrentTypeOrParentType(type, parentType)) continue;
                return COMPLEX_TYPE_AND_SETTER.get(parentType).set(value);
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
        throw new UnsupportedOperationException("Only support convert boolean/float/int/string/map/list/date/pojo to nebula.Value but was" + value.getClass().getTypeName());
    }

    @Override
    public synchronized void close() {
        this.release();
    }

    static interface Setter<T> {
        public Value set(T var1);
    }
}

