/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.FTIndex;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListFTIndexesResp
implements TBase,
Serializable,
Cloneable,
Comparable<ListFTIndexesResp> {
    private static final TStruct STRUCT_DESC = new TStruct("ListFTIndexesResp");
    private static final TField CODE_FIELD_DESC = new TField("code", 8, 1);
    private static final TField LEADER_FIELD_DESC = new TField("leader", 12, 2);
    private static final TField INDEXES_FIELD_DESC = new TField("indexes", 13, 3);
    public ErrorCode code;
    public HostAddr leader;
    public Map<byte[], FTIndex> indexes;
    public static final int CODE = 1;
    public static final int LEADER = 2;
    public static final int INDEXES = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ListFTIndexesResp() {
    }

    public ListFTIndexesResp(ErrorCode code, HostAddr leader, Map<byte[], FTIndex> indexes) {
        this();
        this.code = code;
        this.leader = leader;
        this.indexes = indexes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListFTIndexesResp(ListFTIndexesResp other) {
        if (other.isSetCode()) {
            this.code = TBaseHelper.deepCopy(other.code);
        }
        if (other.isSetLeader()) {
            this.leader = TBaseHelper.deepCopy(other.leader);
        }
        if (other.isSetIndexes()) {
            this.indexes = TBaseHelper.deepCopy(other.indexes);
        }
    }

    @Override
    public ListFTIndexesResp deepCopy() {
        return new ListFTIndexesResp(this);
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public ListFTIndexesResp setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public void unsetCode() {
        this.code = null;
    }

    public boolean isSetCode() {
        return this.code != null;
    }

    public void setCodeIsSet(boolean __value) {
        if (!__value) {
            this.code = null;
        }
    }

    public HostAddr getLeader() {
        return this.leader;
    }

    public ListFTIndexesResp setLeader(HostAddr leader) {
        this.leader = leader;
        return this;
    }

    public void unsetLeader() {
        this.leader = null;
    }

    public boolean isSetLeader() {
        return this.leader != null;
    }

    public void setLeaderIsSet(boolean __value) {
        if (!__value) {
            this.leader = null;
        }
    }

    public Map<byte[], FTIndex> getIndexes() {
        return this.indexes;
    }

    public ListFTIndexesResp setIndexes(Map<byte[], FTIndex> indexes) {
        this.indexes = indexes;
        return this;
    }

    public void unsetIndexes() {
        this.indexes = null;
    }

    public boolean isSetIndexes() {
        return this.indexes != null;
    }

    public void setIndexesIsSet(boolean __value) {
        if (!__value) {
            this.indexes = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetCode();
                    break;
                }
                this.setCode((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetLeader();
                    break;
                }
                this.setLeader((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetIndexes();
                    break;
                }
                this.setIndexes((Map)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCode();
            }
            case 2: {
                return this.getLeader();
            }
            case 3: {
                return this.getIndexes();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof ListFTIndexesResp)) {
            return false;
        }
        ListFTIndexesResp that = (ListFTIndexesResp)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetCode(), that.isSetCode(), this.code, that.code)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader(), that.isSetLeader(), this.leader, that.leader)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetIndexes(), that.isSetIndexes(), this.indexes, that.indexes);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.code, this.leader, this.indexes});
    }

    @Override
    public int compareTo(ListFTIndexesResp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCode()).compareTo(other.isSetCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.code, other.code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader()).compareTo(other.isSetLeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader, other.leader);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIndexes()).compareTo(other.isSetIndexes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.indexes, other.indexes);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.leader = new HostAddr();
                        this.leader.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 13) {
                        TMap _map283 = iprot.readMapBegin();
                        this.indexes = new HashMap<byte[], FTIndex>(Math.max(0, 2 * _map283.size));
                        int _i284 = 0;
                        while (_map283.size < 0 ? iprot.peekMap() : _i284 < _map283.size) {
                            byte[] _key285 = iprot.readBinary();
                            FTIndex _val286 = new FTIndex();
                            _val286.read(iprot);
                            this.indexes.put(_key285, _val286);
                            ++_i284;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.code != null) {
            oprot.writeFieldBegin(CODE_FIELD_DESC);
            oprot.writeI32(this.code == null ? 0 : this.code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.leader != null) {
            oprot.writeFieldBegin(LEADER_FIELD_DESC);
            this.leader.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.indexes != null) {
            oprot.writeFieldBegin(INDEXES_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 12, this.indexes.size()));
            for (Map.Entry<byte[], FTIndex> _iter287 : this.indexes.entrySet()) {
                oprot.writeBinary(_iter287.getKey());
                _iter287.getValue().write(oprot);
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ListFTIndexesResp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCode() == null) {
            sb.append("null");
        } else {
            String code_name;
            String string = code_name = this.getCode() == null ? "null" : this.getCode().name();
            if (code_name != null) {
                sb.append(code_name);
                sb.append(" (");
            }
            sb.append(this.getCode());
            if (code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("indexes");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getIndexes() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getIndexes(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("code", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("leader", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("indexes", 3, new MapMetaData(13, new FieldValueMetaData(11), new StructMetaData(12, FTIndex.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ListFTIndexesResp.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode code;
        private HostAddr leader;
        private Map<byte[], FTIndex> indexes;

        public Builder setCode(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder setLeader(HostAddr leader) {
            this.leader = leader;
            return this;
        }

        public Builder setIndexes(Map<byte[], FTIndex> indexes) {
            this.indexes = indexes;
            return this;
        }

        public ListFTIndexesResp build() {
            ListFTIndexesResp result = new ListFTIndexesResp();
            result.setCode(this.code);
            result.setLeader(this.leader);
            result.setIndexes(this.indexes);
            return result;
        }
    }
}

