/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.NodeInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListClusterInfoResp
implements TBase,
Serializable,
Cloneable,
Comparable<ListClusterInfoResp> {
    private static final TStruct STRUCT_DESC = new TStruct("ListClusterInfoResp");
    private static final TField CODE_FIELD_DESC = new TField("code", 8, 1);
    private static final TField LEADER_FIELD_DESC = new TField("leader", 12, 2);
    private static final TField META_SERVERS_FIELD_DESC = new TField("meta_servers", 15, 3);
    private static final TField STORAGE_SERVERS_FIELD_DESC = new TField("storage_servers", 15, 4);
    public ErrorCode code;
    public HostAddr leader;
    public List<HostAddr> meta_servers;
    public List<NodeInfo> storage_servers;
    public static final int CODE = 1;
    public static final int LEADER = 2;
    public static final int META_SERVERS = 3;
    public static final int STORAGE_SERVERS = 4;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ListClusterInfoResp() {
    }

    public ListClusterInfoResp(ErrorCode code, HostAddr leader, List<HostAddr> meta_servers, List<NodeInfo> storage_servers) {
        this();
        this.code = code;
        this.leader = leader;
        this.meta_servers = meta_servers;
        this.storage_servers = storage_servers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListClusterInfoResp(ListClusterInfoResp other) {
        if (other.isSetCode()) {
            this.code = TBaseHelper.deepCopy(other.code);
        }
        if (other.isSetLeader()) {
            this.leader = TBaseHelper.deepCopy(other.leader);
        }
        if (other.isSetMeta_servers()) {
            this.meta_servers = TBaseHelper.deepCopy(other.meta_servers);
        }
        if (other.isSetStorage_servers()) {
            this.storage_servers = TBaseHelper.deepCopy(other.storage_servers);
        }
    }

    @Override
    public ListClusterInfoResp deepCopy() {
        return new ListClusterInfoResp(this);
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public ListClusterInfoResp setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public void unsetCode() {
        this.code = null;
    }

    public boolean isSetCode() {
        return this.code != null;
    }

    public void setCodeIsSet(boolean __value) {
        if (!__value) {
            this.code = null;
        }
    }

    public HostAddr getLeader() {
        return this.leader;
    }

    public ListClusterInfoResp setLeader(HostAddr leader) {
        this.leader = leader;
        return this;
    }

    public void unsetLeader() {
        this.leader = null;
    }

    public boolean isSetLeader() {
        return this.leader != null;
    }

    public void setLeaderIsSet(boolean __value) {
        if (!__value) {
            this.leader = null;
        }
    }

    public List<HostAddr> getMeta_servers() {
        return this.meta_servers;
    }

    public ListClusterInfoResp setMeta_servers(List<HostAddr> meta_servers) {
        this.meta_servers = meta_servers;
        return this;
    }

    public void unsetMeta_servers() {
        this.meta_servers = null;
    }

    public boolean isSetMeta_servers() {
        return this.meta_servers != null;
    }

    public void setMeta_serversIsSet(boolean __value) {
        if (!__value) {
            this.meta_servers = null;
        }
    }

    public List<NodeInfo> getStorage_servers() {
        return this.storage_servers;
    }

    public ListClusterInfoResp setStorage_servers(List<NodeInfo> storage_servers) {
        this.storage_servers = storage_servers;
        return this;
    }

    public void unsetStorage_servers() {
        this.storage_servers = null;
    }

    public boolean isSetStorage_servers() {
        return this.storage_servers != null;
    }

    public void setStorage_serversIsSet(boolean __value) {
        if (!__value) {
            this.storage_servers = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetCode();
                    break;
                }
                this.setCode((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetLeader();
                    break;
                }
                this.setLeader((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetMeta_servers();
                    break;
                }
                this.setMeta_servers((List)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetStorage_servers();
                    break;
                }
                this.setStorage_servers((List)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCode();
            }
            case 2: {
                return this.getLeader();
            }
            case 3: {
                return this.getMeta_servers();
            }
            case 4: {
                return this.getStorage_servers();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof ListClusterInfoResp)) {
            return false;
        }
        ListClusterInfoResp that = (ListClusterInfoResp)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetCode(), that.isSetCode(), this.code, that.code)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader(), that.isSetLeader(), this.leader, that.leader)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetMeta_servers(), that.isSetMeta_servers(), this.meta_servers, that.meta_servers)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetStorage_servers(), that.isSetStorage_servers(), this.storage_servers, that.storage_servers);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.code, this.leader, this.meta_servers, this.storage_servers});
    }

    @Override
    public int compareTo(ListClusterInfoResp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCode()).compareTo(other.isSetCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.code, other.code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader()).compareTo(other.isSetLeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader, other.leader);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMeta_servers()).compareTo(other.isSetMeta_servers());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.meta_servers, other.meta_servers);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStorage_servers()).compareTo(other.isSetStorage_servers());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.storage_servers, other.storage_servers);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.leader = new HostAddr();
                        this.leader.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 15) {
                        TList _list325 = iprot.readListBegin();
                        this.meta_servers = new ArrayList<HostAddr>(Math.max(0, _list325.size));
                        int _i326 = 0;
                        while (_list325.size < 0 ? iprot.peekList() : _i326 < _list325.size) {
                            HostAddr _elem327 = new HostAddr();
                            _elem327.read(iprot);
                            this.meta_servers.add(_elem327);
                            ++_i326;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 15) {
                        TList _list328 = iprot.readListBegin();
                        this.storage_servers = new ArrayList<NodeInfo>(Math.max(0, _list328.size));
                        int _i329 = 0;
                        while (_list328.size < 0 ? iprot.peekList() : _i329 < _list328.size) {
                            NodeInfo _elem330 = new NodeInfo();
                            _elem330.read(iprot);
                            this.storage_servers.add(_elem330);
                            ++_i329;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.code != null) {
            oprot.writeFieldBegin(CODE_FIELD_DESC);
            oprot.writeI32(this.code == null ? 0 : this.code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.leader != null) {
            oprot.writeFieldBegin(LEADER_FIELD_DESC);
            this.leader.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.meta_servers != null) {
            oprot.writeFieldBegin(META_SERVERS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.meta_servers.size()));
            for (HostAddr _iter331 : this.meta_servers) {
                _iter331.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.storage_servers != null) {
            oprot.writeFieldBegin(STORAGE_SERVERS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.storage_servers.size()));
            for (NodeInfo _iter332 : this.storage_servers) {
                _iter332.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ListClusterInfoResp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCode() == null) {
            sb.append("null");
        } else {
            String code_name;
            String string = code_name = this.getCode() == null ? "null" : this.getCode().name();
            if (code_name != null) {
                sb.append(code_name);
                sb.append(" (");
            }
            sb.append(this.getCode());
            if (code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("meta_servers");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getMeta_servers() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getMeta_servers(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("storage_servers");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getStorage_servers() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getStorage_servers(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("code", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("leader", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("meta_servers", 3, new ListMetaData(15, new StructMetaData(12, HostAddr.class))));
        tmpMetaDataMap.put(4, new FieldMetaData("storage_servers", 3, new ListMetaData(15, new StructMetaData(12, NodeInfo.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ListClusterInfoResp.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode code;
        private HostAddr leader;
        private List<HostAddr> meta_servers;
        private List<NodeInfo> storage_servers;

        public Builder setCode(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder setLeader(HostAddr leader) {
            this.leader = leader;
            return this;
        }

        public Builder setMeta_servers(List<HostAddr> meta_servers) {
            this.meta_servers = meta_servers;
            return this;
        }

        public Builder setStorage_servers(List<NodeInfo> storage_servers) {
            this.storage_servers = storage_servers;
            return this;
        }

        public ListClusterInfoResp build() {
            ListClusterInfoResp result = new ListClusterInfoResp();
            result.setCode(this.code);
            result.setLeader(this.leader);
            result.setMeta_servers(this.meta_servers);
            result.setStorage_servers(this.storage_servers);
            return result;
        }
    }
}

