/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage.scan;

import com.vesoft.nebula.DataSet;
import com.vesoft.nebula.client.storage.data.EdgeRow;
import com.vesoft.nebula.client.storage.data.EdgeTableRow;
import com.vesoft.nebula.client.storage.data.ScanStatus;
import com.vesoft.nebula.client.storage.processor.EdgeProcessor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanEdgeResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanEdgeResult.class);
    private final List<DataSet> dataSets;
    private final ScanStatus scanStatus;
    private List<EdgeTableRow> edgeTableRows = new ArrayList<EdgeTableRow>();
    private List<String> propNames = new ArrayList<String>();
    private List<EdgeRow> edgeRows = new ArrayList<EdgeRow>();
    private String decodeType = "utf-8";
    private boolean isEmpty;

    public ScanEdgeResult(List<DataSet> dataSets, ScanStatus status) {
        this.dataSets = dataSets;
        this.scanStatus = status;
        this.isEmpty = this.isDatasetEmpty();
    }

    public List<EdgeTableRow> getEdgeTableRows() {
        if (!this.isEmpty && this.edgeTableRows.isEmpty()) {
            this.constructEdgeTableRow();
        }
        return this.edgeTableRows;
    }

    public List<String> getPropNames() {
        if (!this.isEmpty && this.propNames.isEmpty()) {
            this.constructPropNames();
        }
        return this.propNames;
    }

    public List<EdgeRow> getEdges() {
        if (!this.isEmpty && this.edgeRows.isEmpty()) {
            this.constructEdgeRow();
        }
        return this.edgeRows;
    }

    public boolean isAllSuccess() {
        return this.scanStatus == ScanStatus.ALL_SUCCESS;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private boolean isDatasetEmpty() {
        if (this.dataSets == null || this.dataSets.isEmpty()) {
            return true;
        }
        for (DataSet dataSet : this.dataSets) {
            if (dataSet.getRows().size() <= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructEdgeTableRow() {
        if (this.isEmpty) {
            return;
        }
        ScanEdgeResult scanEdgeResult = this;
        synchronized (scanEdgeResult) {
            if (this.edgeTableRows.isEmpty()) {
                this.edgeTableRows = EdgeProcessor.constructEdgeTableRow(this.dataSets, this.decodeType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructEdgeRow() {
        if (this.isEmpty) {
            return;
        }
        ScanEdgeResult scanEdgeResult = this;
        synchronized (scanEdgeResult) {
            if (this.edgeRows.isEmpty()) {
                this.edgeRows = EdgeProcessor.constructEdgeRow(this.dataSets, this.decodeType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructPropNames() {
        if (this.isEmpty) {
            return;
        }
        ScanEdgeResult scanEdgeResult = this;
        synchronized (scanEdgeResult) {
            if (this.propNames.isEmpty()) {
                List<byte[]> colNames = this.dataSets.get(0).getColumn_names();
                for (byte[] colName : colNames) {
                    String name = new String(colName).split("\\.")[1];
                    this.propNames.add(name);
                }
            }
        }
    }
}

