/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage.processor;

import com.google.common.collect.Maps;
import com.vesoft.nebula.DataSet;
import com.vesoft.nebula.Row;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import com.vesoft.nebula.client.storage.data.VertexRow;
import com.vesoft.nebula.client.storage.data.VertexTableRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertexProcessor.class);

    public static Map<ValueWrapper, VertexRow> constructVertexRow(List<DataSet> dataSets, String decodeType) {
        HashMap vidVertices = Maps.newHashMap();
        for (DataSet dataSet : dataSets) {
            List<Row> rows = dataSet.getRows();
            List<byte[]> colNames = dataSet.getColumn_names();
            for (Row row : rows) {
                List<Value> values = row.getValues();
                if (values.size() < 1) {
                    LOGGER.error("values size error for row: " + row.toString());
                    continue;
                }
                Value vid = values.get(0);
                HashMap props = Maps.newHashMap();
                for (int i = 1; i < values.size(); ++i) {
                    String colName = new String(colNames.get(i)).split("\\.")[1];
                    props.put(colName, new ValueWrapper(values.get(i), decodeType));
                }
                VertexRow vertexRow = new VertexRow(new ValueWrapper(vid, decodeType), props);
                vidVertices.put(new ValueWrapper(vid, decodeType), vertexRow);
            }
        }
        return vidVertices;
    }

    public static List<VertexTableRow> constructVertexTableRow(List<DataSet> dataSets, String decodeType) {
        ArrayList<VertexTableRow> vertexRows = new ArrayList<VertexTableRow>();
        for (DataSet dataSet : dataSets) {
            List<Row> rows = dataSet.getRows();
            for (Row row : rows) {
                List<Value> values = row.getValues();
                ArrayList<ValueWrapper> props = new ArrayList<ValueWrapper>();
                for (int i = 0; i < values.size(); ++i) {
                    props.add(new ValueWrapper(values.get(i), decodeType));
                }
                vertexRows.add(new VertexTableRow(props));
            }
        }
        return vertexRows;
    }
}

