/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.vesoft.nebula.client.graph.SessionsManagerConfig;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.exception.AuthFailedException;
import com.vesoft.nebula.client.graph.exception.ClientServerIncompatibleException;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.exception.NotValidConnectionException;
import com.vesoft.nebula.client.graph.net.NebulaPool;
import com.vesoft.nebula.client.graph.net.Session;
import com.vesoft.nebula.client.graph.net.SessionWrapper;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.concurrent.CopyOnWriteArrayList;

public class SessionsManager {
    private final SessionsManagerConfig config;
    private NebulaPool pool = null;
    private final CopyOnWriteArrayList<SessionWrapper> sessionList;
    private BitSet canUseBitSet;
    private Boolean isClose = false;

    public SessionsManager(SessionsManagerConfig config) {
        this.config = config;
        this.sessionList = new CopyOnWriteArrayList();
        this.checkConfig();
    }

    private void checkConfig() {
        if (this.config.getAddresses().isEmpty()) {
            throw new RuntimeException("Empty graph addresses");
        }
        if (this.config.getSpaceName().isEmpty()) {
            throw new RuntimeException("Empty space name");
        }
    }

    public synchronized SessionWrapper getSessionWrapper() throws RuntimeException, ClientServerIncompatibleException {
        int index;
        this.checkClose();
        if (this.pool == null) {
            this.init();
        }
        if (this.canUseBitSet.isEmpty() && this.sessionList.size() >= this.config.getPoolConfig().getMaxConnSize()) {
            throw new RuntimeException("The SessionsManager does not have available sessions.");
        }
        if (!this.canUseBitSet.isEmpty() && (index = this.canUseBitSet.nextSetBit(0)) >= 0 && this.canUseBitSet.get(index)) {
            this.canUseBitSet.set(index, false);
            return this.sessionList.get(index);
        }
        try {
            Session session = this.pool.getSession(this.config.getUserName(), this.config.getPassword(), this.config.getReconnect());
            ResultSet resultSet = session.execute("USE " + this.config.getSpaceName());
            if (!resultSet.isSucceeded()) {
                throw new RuntimeException("Switch space `" + this.config.getSpaceName() + "' failed: " + resultSet.getErrorMessage());
            }
            SessionWrapper sessionWrapper = new SessionWrapper(session);
            this.sessionList.add(sessionWrapper);
            return sessionWrapper;
        }
        catch (AuthFailedException | IOErrorException | NotValidConnectionException e) {
            throw new RuntimeException("Get session failed: " + e.getMessage());
        }
    }

    public synchronized void returnSessionWrapper(SessionWrapper session) {
        this.checkClose();
        if (session == null) {
            return;
        }
        int index = this.sessionList.indexOf(session);
        if (index >= 0) {
            Session ses = session.getSession();
            this.sessionList.set(index, new SessionWrapper(ses));
            session.setNoAvailable();
            this.canUseBitSet.set(index, true);
        }
    }

    public synchronized void close() {
        for (SessionWrapper session : this.sessionList) {
            session.release();
        }
        this.pool.close();
        this.sessionList.clear();
        this.isClose = true;
    }

    private void init() throws RuntimeException {
        try {
            this.pool = new NebulaPool();
            if (!this.pool.init(this.config.getAddresses(), this.config.getPoolConfig())) {
                throw new RuntimeException("Init pool failed: services are broken.");
            }
            this.canUseBitSet = new BitSet(this.config.getPoolConfig().getMaxConnSize());
            this.canUseBitSet.set(0, this.config.getPoolConfig().getMaxConnSize(), false);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Init the pool failed: " + e.getMessage());
        }
    }

    private void checkClose() {
        if (this.isClose.booleanValue()) {
            throw new RuntimeException("The SessionsManager was closed.");
        }
    }
}

