/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.protocol;

import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TMessage;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TSet;
import com.facebook.thrift.protocol.TStruct;
import com.facebook.thrift.scheme.IScheme;
import com.facebook.thrift.scheme.StandardScheme;
import com.facebook.thrift.transport.TTransport;
import java.util.Collections;
import java.util.Map;

public abstract class TProtocol {
    protected TTransport trans_;

    private TProtocol() {
    }

    protected TProtocol(TTransport trans) {
        this.trans_ = trans;
    }

    public TTransport getTransport() {
        return this.trans_;
    }

    public abstract void writeMessageBegin(TMessage var1) throws TException;

    public abstract void writeMessageEnd() throws TException;

    public abstract void writeStructBegin(TStruct var1) throws TException;

    public abstract void writeStructEnd() throws TException;

    public abstract void writeFieldBegin(TField var1) throws TException;

    public abstract void writeFieldEnd() throws TException;

    public abstract void writeFieldStop() throws TException;

    public abstract void writeMapBegin(TMap var1) throws TException;

    public abstract void writeMapEnd() throws TException;

    public abstract void writeListBegin(TList var1) throws TException;

    public abstract void writeListEnd() throws TException;

    public abstract void writeSetBegin(TSet var1) throws TException;

    public abstract void writeSetEnd() throws TException;

    public abstract void writeBool(boolean var1) throws TException;

    public abstract void writeByte(byte var1) throws TException;

    public abstract void writeI16(short var1) throws TException;

    public abstract void writeI32(int var1) throws TException;

    public abstract void writeI64(long var1) throws TException;

    public abstract void writeDouble(double var1) throws TException;

    public abstract void writeFloat(float var1) throws TException;

    public abstract void writeString(String var1) throws TException;

    public abstract void writeBinary(byte[] var1) throws TException;

    public abstract TMessage readMessageBegin() throws TException;

    public abstract void readMessageEnd() throws TException;

    public abstract TStruct readStructBegin(Map<Integer, FieldMetaData> var1) throws TException;

    public TStruct readStructBegin() throws TException {
        return this.readStructBegin(Collections.emptyMap());
    }

    public abstract void readStructEnd() throws TException;

    public abstract TField readFieldBegin() throws TException;

    public abstract void readFieldEnd() throws TException;

    public abstract TMap readMapBegin() throws TException;

    public boolean peekMap() throws TException {
        throw new TException("Peeking into a map not supported, likely because it's sized");
    }

    public abstract void readMapEnd() throws TException;

    public abstract TList readListBegin() throws TException;

    public boolean peekList() throws TException {
        throw new TException("Peeking into a list not supported, likely because it's sized");
    }

    public abstract void readListEnd() throws TException;

    public abstract TSet readSetBegin() throws TException;

    public boolean peekSet() throws TException {
        throw new TException("Peeking into a set not supported, likely because it's sized");
    }

    public abstract void readSetEnd() throws TException;

    public abstract boolean readBool() throws TException;

    public abstract byte readByte() throws TException;

    public abstract short readI16() throws TException;

    public abstract int readI32() throws TException;

    public abstract long readI64() throws TException;

    public abstract double readDouble() throws TException;

    public abstract float readFloat() throws TException;

    public abstract String readString() throws TException;

    public abstract byte[] readBinary() throws TException;

    public void reset() {
    }

    public Class<? extends IScheme> getScheme() {
        return StandardScheme.class;
    }

    protected int typeMinimumSize(byte type) {
        return 1;
    }

    protected void ensureContainerHasEnough(int size, byte type) {
        int minimumExpected = size * this.typeMinimumSize(type);
        this.ensureHasEnoughBytes(minimumExpected);
    }

    protected void ensureMapHasEnough(int size, byte keyType, byte valueType) {
        int minimumExpected = size * (this.typeMinimumSize(keyType) + this.typeMinimumSize(valueType));
        this.ensureHasEnoughBytes(minimumExpected);
    }

    private void ensureHasEnoughBytes(int minimumExpected) {
        int remaining = this.trans_.getBytesRemainingInBuffer();
        if (remaining < 0) {
            return;
        }
        if (remaining < minimumExpected) {
            throw new TProtocolException(1, "Not enough bytes to read the entire message, the data appears to be truncated");
        }
    }
}

