/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.KeyValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiPutReq
implements TBase,
Serializable,
Cloneable,
Comparable<MultiPutReq> {
    private static final TStruct STRUCT_DESC = new TStruct("MultiPutReq");
    private static final TField SEGMENT_FIELD_DESC = new TField("segment", 11, 1);
    private static final TField PAIRS_FIELD_DESC = new TField("pairs", 15, 2);
    public byte[] segment;
    public List<KeyValue> pairs;
    public static final int SEGMENT = 1;
    public static final int PAIRS = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public MultiPutReq() {
    }

    public MultiPutReq(byte[] segment, List<KeyValue> pairs) {
        this();
        this.segment = segment;
        this.pairs = pairs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MultiPutReq(MultiPutReq other) {
        if (other.isSetSegment()) {
            this.segment = TBaseHelper.deepCopy(other.segment);
        }
        if (other.isSetPairs()) {
            this.pairs = TBaseHelper.deepCopy(other.pairs);
        }
    }

    @Override
    public MultiPutReq deepCopy() {
        return new MultiPutReq(this);
    }

    public byte[] getSegment() {
        return this.segment;
    }

    public MultiPutReq setSegment(byte[] segment) {
        this.segment = segment;
        return this;
    }

    public void unsetSegment() {
        this.segment = null;
    }

    public boolean isSetSegment() {
        return this.segment != null;
    }

    public void setSegmentIsSet(boolean __value) {
        if (!__value) {
            this.segment = null;
        }
    }

    public List<KeyValue> getPairs() {
        return this.pairs;
    }

    public MultiPutReq setPairs(List<KeyValue> pairs) {
        this.pairs = pairs;
        return this;
    }

    public void unsetPairs() {
        this.pairs = null;
    }

    public boolean isSetPairs() {
        return this.pairs != null;
    }

    public void setPairsIsSet(boolean __value) {
        if (!__value) {
            this.pairs = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetSegment();
                    break;
                }
                this.setSegment((byte[])__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetPairs();
                    break;
                }
                this.setPairs((List)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getSegment();
            }
            case 2: {
                return this.getPairs();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof MultiPutReq)) {
            return false;
        }
        MultiPutReq that = (MultiPutReq)_that;
        if (!TBaseHelper.equalsSlow(this.isSetSegment(), that.isSetSegment(), this.segment, that.segment)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetPairs(), that.isSetPairs(), this.pairs, that.pairs);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.segment, this.pairs});
    }

    @Override
    public int compareTo(MultiPutReq other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetSegment()).compareTo(other.isSetSegment());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.segment, other.segment);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPairs()).compareTo(other.isSetPairs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.pairs, other.pairs);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 11) {
                        this.segment = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 15) {
                        TList _list124 = iprot.readListBegin();
                        this.pairs = new ArrayList<KeyValue>(Math.max(0, _list124.size));
                        int _i125 = 0;
                        while (_list124.size < 0 ? iprot.peekList() : _i125 < _list124.size) {
                            KeyValue _elem126 = new KeyValue();
                            _elem126.read(iprot);
                            this.pairs.add(_elem126);
                            ++_i125;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.segment != null) {
            oprot.writeFieldBegin(SEGMENT_FIELD_DESC);
            oprot.writeBinary(this.segment);
            oprot.writeFieldEnd();
        }
        if (this.pairs != null) {
            oprot.writeFieldBegin(PAIRS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.pairs.size()));
            for (KeyValue _iter127 : this.pairs) {
                _iter127.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("MultiPutReq");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("segment");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getSegment() == null) {
            sb.append("null");
        } else {
            int __segment_size = Math.min(this.getSegment().length, 128);
            for (int i = 0; i < __segment_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getSegment()[i]).length() > 1 ? Integer.toHexString(this.getSegment()[i]).substring(Integer.toHexString(this.getSegment()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getSegment()[i]).toUpperCase());
            }
            if (this.getSegment().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("pairs");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getPairs() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getPairs(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("segment", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("pairs", 3, new ListMetaData(15, new StructMetaData(12, KeyValue.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(MultiPutReq.class, metaDataMap);
    }

    public static class Builder {
        private byte[] segment;
        private List<KeyValue> pairs;

        public Builder setSegment(byte[] segment) {
            this.segment = segment;
            return this;
        }

        public Builder setPairs(List<KeyValue> pairs) {
            this.pairs = pairs;
            return this;
        }

        public MultiPutReq build() {
            MultiPutReq result = new MultiPutReq();
            result.setSegment(this.segment);
            result.setPairs(this.pairs);
            return result;
        }
    }
}

