/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.NewVertex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddVerticesRequest
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("AddVerticesRequest");
    private static final TField SPACE_ID_FIELD_DESC = new TField("space_id", 8, 1);
    private static final TField PARTS_FIELD_DESC = new TField("parts", 13, 2);
    private static final TField PROP_NAMES_FIELD_DESC = new TField("prop_names", 13, 3);
    private static final TField IF_NOT_EXISTS_FIELD_DESC = new TField("if_not_exists", 2, 4);
    public int space_id;
    public Map<Integer, List<NewVertex>> parts;
    public Map<Integer, List<byte[]>> prop_names;
    public boolean if_not_exists;
    public static final int SPACE_ID = 1;
    public static final int PARTS = 2;
    public static final int PROP_NAMES = 3;
    public static final int IF_NOT_EXISTS = 4;
    private static final int __SPACE_ID_ISSET_ID = 0;
    private static final int __IF_NOT_EXISTS_ISSET_ID = 1;
    private BitSet __isset_bit_vector = new BitSet(2);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public AddVerticesRequest() {
    }

    public AddVerticesRequest(int space_id, Map<Integer, List<NewVertex>> parts, Map<Integer, List<byte[]>> prop_names, boolean if_not_exists) {
        this();
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        this.parts = parts;
        this.prop_names = prop_names;
        this.if_not_exists = if_not_exists;
        this.setIf_not_existsIsSet(true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public AddVerticesRequest(AddVerticesRequest other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.space_id = TBaseHelper.deepCopy(other.space_id);
        if (other.isSetParts()) {
            this.parts = TBaseHelper.deepCopy(other.parts);
        }
        if (other.isSetProp_names()) {
            this.prop_names = TBaseHelper.deepCopy(other.prop_names);
        }
        this.if_not_exists = TBaseHelper.deepCopy(other.if_not_exists);
    }

    @Override
    public AddVerticesRequest deepCopy() {
        return new AddVerticesRequest(this);
    }

    public int getSpace_id() {
        return this.space_id;
    }

    public AddVerticesRequest setSpace_id(int space_id) {
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        return this;
    }

    public void unsetSpace_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetSpace_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setSpace_idIsSet(boolean __value) {
        this.__isset_bit_vector.set(0, __value);
    }

    public Map<Integer, List<NewVertex>> getParts() {
        return this.parts;
    }

    public AddVerticesRequest setParts(Map<Integer, List<NewVertex>> parts) {
        this.parts = parts;
        return this;
    }

    public void unsetParts() {
        this.parts = null;
    }

    public boolean isSetParts() {
        return this.parts != null;
    }

    public void setPartsIsSet(boolean __value) {
        if (!__value) {
            this.parts = null;
        }
    }

    public Map<Integer, List<byte[]>> getProp_names() {
        return this.prop_names;
    }

    public AddVerticesRequest setProp_names(Map<Integer, List<byte[]>> prop_names) {
        this.prop_names = prop_names;
        return this;
    }

    public void unsetProp_names() {
        this.prop_names = null;
    }

    public boolean isSetProp_names() {
        return this.prop_names != null;
    }

    public void setProp_namesIsSet(boolean __value) {
        if (!__value) {
            this.prop_names = null;
        }
    }

    public boolean isIf_not_exists() {
        return this.if_not_exists;
    }

    public AddVerticesRequest setIf_not_exists(boolean if_not_exists) {
        this.if_not_exists = if_not_exists;
        this.setIf_not_existsIsSet(true);
        return this;
    }

    public void unsetIf_not_exists() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetIf_not_exists() {
        return this.__isset_bit_vector.get(1);
    }

    public void setIf_not_existsIsSet(boolean __value) {
        this.__isset_bit_vector.set(1, __value);
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetSpace_id();
                    break;
                }
                this.setSpace_id((Integer)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetParts();
                    break;
                }
                this.setParts((Map)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetProp_names();
                    break;
                }
                this.setProp_names((Map)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetIf_not_exists();
                    break;
                }
                this.setIf_not_exists((Boolean)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Integer(this.getSpace_id());
            }
            case 2: {
                return this.getParts();
            }
            case 3: {
                return this.getProp_names();
            }
            case 4: {
                return new Boolean(this.isIf_not_exists());
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof AddVerticesRequest)) {
            return false;
        }
        AddVerticesRequest that = (AddVerticesRequest)_that;
        if (!TBaseHelper.equalsNobinary(this.space_id, that.space_id)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetParts(), that.isSetParts(), this.parts, that.parts)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetProp_names(), that.isSetProp_names(), this.prop_names, that.prop_names)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.if_not_exists, that.if_not_exists);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.space_id, this.parts, this.prop_names, this.if_not_exists});
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.space_id = iprot.readI32();
                        this.setSpace_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 13) {
                        TMap _map86 = iprot.readMapBegin();
                        this.parts = new HashMap<Integer, List<NewVertex>>(Math.max(0, 2 * _map86.size));
                        int _i87 = 0;
                        while (_map86.size < 0 ? iprot.peekMap() : _i87 < _map86.size) {
                            int _key88 = iprot.readI32();
                            TList _list90 = iprot.readListBegin();
                            ArrayList<NewVertex> _val89 = new ArrayList<NewVertex>(Math.max(0, _list90.size));
                            int _i91 = 0;
                            while (_list90.size < 0 ? iprot.peekList() : _i91 < _list90.size) {
                                NewVertex _elem92 = new NewVertex();
                                _elem92.read(iprot);
                                _val89.add(_elem92);
                                ++_i91;
                            }
                            iprot.readListEnd();
                            this.parts.put(_key88, _val89);
                            ++_i87;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 13) {
                        TMap _map93 = iprot.readMapBegin();
                        this.prop_names = new HashMap<Integer, List<byte[]>>(Math.max(0, 2 * _map93.size));
                        int _i94 = 0;
                        while (_map93.size < 0 ? iprot.peekMap() : _i94 < _map93.size) {
                            int _key95 = iprot.readI32();
                            TList _list97 = iprot.readListBegin();
                            ArrayList<byte[]> _val96 = new ArrayList<byte[]>(Math.max(0, _list97.size));
                            int _i98 = 0;
                            while (_list97.size < 0 ? iprot.peekList() : _i98 < _list97.size) {
                                byte[] _elem99 = iprot.readBinary();
                                _val96.add(_elem99);
                                ++_i98;
                            }
                            iprot.readListEnd();
                            this.prop_names.put(_key95, _val96);
                            ++_i94;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 2) {
                        this.if_not_exists = iprot.readBool();
                        this.setIf_not_existsIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SPACE_ID_FIELD_DESC);
        oprot.writeI32(this.space_id);
        oprot.writeFieldEnd();
        if (this.parts != null) {
            oprot.writeFieldBegin(PARTS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 15, this.parts.size()));
            for (Map.Entry<Integer, List<NewVertex>> entry : this.parts.entrySet()) {
                oprot.writeI32(entry.getKey());
                oprot.writeListBegin(new TList(12, entry.getValue().size()));
                for (NewVertex newVertex : entry.getValue()) {
                    newVertex.write(oprot);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.prop_names != null) {
            oprot.writeFieldBegin(PROP_NAMES_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 15, this.prop_names.size()));
            for (Map.Entry<Integer, List<NewVertex>> entry : this.prop_names.entrySet()) {
                oprot.writeI32(entry.getKey());
                oprot.writeListBegin(new TList(11, entry.getValue().size()));
                for (byte[] byArray : entry.getValue()) {
                    oprot.writeBinary(byArray);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(IF_NOT_EXISTS_FIELD_DESC);
        oprot.writeBool(this.if_not_exists);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("AddVerticesRequest");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("space_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getSpace_id(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("parts");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getParts() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getParts(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("prop_names");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getProp_names() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getProp_names(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("if_not_exists");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.isIf_not_exists(), indent + 1, prettyPrint));
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("space_id", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("parts", 3, new MapMetaData(13, new FieldValueMetaData(8), new ListMetaData(15, new StructMetaData(12, NewVertex.class)))));
        tmpMetaDataMap.put(3, new FieldMetaData("prop_names", 3, new MapMetaData(13, new FieldValueMetaData(8), new ListMetaData(15, new FieldValueMetaData(11)))));
        tmpMetaDataMap.put(4, new FieldMetaData("if_not_exists", 3, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(AddVerticesRequest.class, metaDataMap);
    }

    public static class Builder {
        private int space_id;
        private Map<Integer, List<NewVertex>> parts;
        private Map<Integer, List<byte[]>> prop_names;
        private boolean if_not_exists;
        BitSet __optional_isset = new BitSet(2);

        public Builder setSpace_id(int space_id) {
            this.space_id = space_id;
            this.__optional_isset.set(0, true);
            return this;
        }

        public Builder setParts(Map<Integer, List<NewVertex>> parts) {
            this.parts = parts;
            return this;
        }

        public Builder setProp_names(Map<Integer, List<byte[]>> prop_names) {
            this.prop_names = prop_names;
            return this;
        }

        public Builder setIf_not_exists(boolean if_not_exists) {
            this.if_not_exists = if_not_exists;
            this.__optional_isset.set(1, true);
            return this;
        }

        public AddVerticesRequest build() {
            AddVerticesRequest result = new AddVerticesRequest();
            if (this.__optional_isset.get(0)) {
                result.setSpace_id(this.space_id);
            }
            result.setParts(this.parts);
            result.setProp_names(this.prop_names);
            if (this.__optional_isset.get(1)) {
                result.setIf_not_exists(this.if_not_exists);
            }
            return result;
        }
    }
}

