/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.Tag;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.Vertex;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class Node {
    private Vertex vertex;
    private ValueWrapper vid;
    private String decodeType = "utf-8";
    List<String> tagNames = new ArrayList<String>();

    public Node(Vertex vertex) throws UnsupportedEncodingException {
        if (vertex == null) {
            throw new RuntimeException("Input an null vertex object");
        }
        this.vid = new ValueWrapper(vertex.vid, this.decodeType);
        this.vertex = vertex;
        for (Tag tag : vertex.tags) {
            this.tagNames.add(new String(tag.name, this.decodeType));
        }
    }

    public ValueWrapper getId() {
        return this.vid;
    }

    public List<String> tagNames() {
        return this.tagNames;
    }

    public List<String> labels() {
        return this.tagNames;
    }

    public boolean hasTagName(String tagName) {
        return this.tagNames.contains(tagName);
    }

    public boolean hasLabel(String tagName) {
        return this.tagNames.contains(tagName);
    }

    public List<ValueWrapper> values(String tagName) {
        int index = this.tagNames.indexOf(tagName);
        if (index < 0) {
            throw new IllegalArgumentException(tagName + " is not found");
        }
        ArrayList<ValueWrapper> values = new ArrayList<ValueWrapper>();
        for (Value val : this.vertex.tags.get((int)index).props.values()) {
            values.add(new ValueWrapper(val, this.decodeType));
        }
        return values;
    }

    public List<String> keys(String tagName) throws UnsupportedEncodingException {
        int index = this.tagNames.indexOf(tagName);
        if (index < 0) {
            throw new IllegalArgumentException(tagName + " is not found");
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (byte[] name : this.vertex.tags.get((int)index).props.keySet()) {
            keys.add(new String(name, this.decodeType));
        }
        return keys;
    }

    public HashMap<String, ValueWrapper> properties(String tagName) throws UnsupportedEncodingException {
        int index = this.tagNames.indexOf(tagName);
        if (index < 0) {
            throw new IllegalArgumentException(tagName + " is not found");
        }
        HashMap<String, ValueWrapper> properties = new HashMap<String, ValueWrapper>();
        for (byte[] name : this.vertex.tags.get((int)index).props.keySet()) {
            properties.put(new String(name, this.decodeType), new ValueWrapper(this.vertex.tags.get((int)index).props.get(name), this.decodeType));
        }
        return properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.vid, node.vid);
    }

    public int hashCode() {
        return Objects.hash(this.vertex, this.vid, this.decodeType, this.tagNames);
    }

    public String toString() {
        try {
            ArrayList<String> tagsStr = new ArrayList<String>();
            ArrayList<String> propStrs = new ArrayList<String>();
            for (String name : this.tagNames()) {
                HashMap<String, ValueWrapper> props = this.properties(name);
                for (String key : props.keySet()) {
                    propStrs.add(key + ": " + ((ValueWrapper)props.get(key)).toString());
                }
                tagsStr.add(String.format(":%s {%s}", name, String.join((CharSequence)", ", propStrs)));
            }
            return String.format("(%s %s)", this.getId(), String.join((CharSequence)" ", tagsStr));
        }
        catch (UnsupportedEncodingException e) {
            return e.getMessage();
        }
    }
}

