/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.storage.NewTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class NewVertex
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("NewVertex");
    private static final TField ID_FIELD_DESC = new TField("id", 12, 1);
    private static final TField TAGS_FIELD_DESC = new TField("tags", 15, 2);
    public Value id;
    public List<NewTag> tags;
    public static final int ID = 1;
    public static final int TAGS = 2;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public NewVertex() {
    }

    public NewVertex(Value id, List<NewTag> tags) {
        this();
        this.id = id;
        this.tags = tags;
    }

    public NewVertex(NewVertex other) {
        if (other.isSetId()) {
            this.id = TBaseHelper.deepCopy(other.id);
        }
        if (other.isSetTags()) {
            this.tags = TBaseHelper.deepCopy(other.tags);
        }
    }

    @Override
    public NewVertex deepCopy() {
        return new NewVertex(this);
    }

    @Deprecated
    public NewVertex clone() {
        return new NewVertex(this);
    }

    public Value getId() {
        return this.id;
    }

    public NewVertex setId(Value id) {
        this.id = id;
        return this;
    }

    public void unsetId() {
        this.id = null;
    }

    public boolean isSetId() {
        return this.id != null;
    }

    public void setIdIsSet(boolean value) {
        if (!value) {
            this.id = null;
        }
    }

    public List<NewTag> getTags() {
        return this.tags;
    }

    public NewVertex setTags(List<NewTag> tags) {
        this.tags = tags;
        return this;
    }

    public void unsetTags() {
        this.tags = null;
    }

    public boolean isSetTags() {
        return this.tags != null;
    }

    public void setTagsIsSet(boolean value) {
        if (!value) {
            this.tags = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetId();
                    break;
                }
                this.setId((Value)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetTags();
                    break;
                }
                this.setTags((List)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getId();
            }
            case 2: {
                return this.getTags();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetId();
            }
            case 2: {
                return this.isSetTags();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof NewVertex) {
            return this.equals((NewVertex)that);
        }
        return false;
    }

    public boolean equals(NewVertex that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_id = this.isSetId();
        boolean that_present_id = that.isSetId();
        if (this_present_id || that_present_id) {
            if (!this_present_id || !that_present_id) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.id, that.id)) {
                return false;
            }
        }
        boolean this_present_tags = this.isSetTags();
        boolean that_present_tags = that.isSetTags();
        if (this_present_tags || that_present_tags) {
            if (!this_present_tags || !that_present_tags) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.tags, that.tags)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_id = this.isSetId();
        builder.append(present_id);
        if (present_id) {
            builder.append((Object)this.id);
        }
        boolean present_tags = this.isSetTags();
        builder.append(present_tags);
        if (present_tags) {
            builder.append(this.tags);
        }
        return builder.toHashCode();
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 12) {
                        this.id = new Value();
                        this.id.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list78 = iprot.readListBegin();
                        this.tags = new ArrayList<NewTag>(Math.max(0, _list78.size));
                        int _i79 = 0;
                        while (_list78.size < 0 ? iprot.peekList() : _i79 < _list78.size) {
                            NewTag _elem80 = new NewTag();
                            _elem80.read(iprot);
                            this.tags.add(_elem80);
                            ++_i79;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.id != null) {
            oprot.writeFieldBegin(ID_FIELD_DESC);
            this.id.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.tags != null) {
            oprot.writeFieldBegin(TAGS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.tags.size()));
            for (NewTag _iter81 : this.tags) {
                _iter81.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("NewVertex");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("id");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getId() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getId(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("tags");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getTags() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getTags(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("id", 3, new StructMetaData(12, Value.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("tags", 3, new ListMetaData(15, new StructMetaData(12, NewTag.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(NewVertex.class, metaDataMap);
    }
}

