/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage.data;

import com.vesoft.nebula.Date;
import com.vesoft.nebula.DateTime;
import com.vesoft.nebula.Time;
import java.util.List;

public class BaseTableRow {
    protected final List<Object> values;
    protected String decodeType = "utf-8";

    public BaseTableRow(List<Object> values) {
        this.values = values;
    }

    public BaseTableRow(List<Object> values, String decodeType) {
        this.values = values;
        this.decodeType = decodeType;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isNullAt(int i) {
        return this.values.get(i) == null;
    }

    public String getString(int i) {
        if (this.values.get(i) instanceof String) {
            return (String)this.values.get(i);
        }
        throw new ClassCastException("value is not String type");
    }

    public long getLong(int i) {
        if (this.values.get(i) instanceof Long) {
            return (Long)this.values.get(i);
        }
        throw new ClassCastException("value is not long type");
    }

    public boolean getBoolean(int i) {
        if (this.values.get(i) instanceof Boolean) {
            return (Boolean)this.values.get(i);
        }
        throw new ClassCastException("value is not boolean type");
    }

    public double getDouble(int i) {
        if (this.values.get(i) instanceof Double) {
            return (Double)this.values.get(i);
        }
        throw new ClassCastException("value is not boolean type");
    }

    public Date getDate(int i) {
        if (this.values.get(i) instanceof Date) {
            return (Date)this.values.get(i);
        }
        throw new ClassCastException("value is not nebula Date type");
    }

    public Time getTime(int i) {
        if (this.values.get(i) instanceof Time) {
            return (Time)this.values.get(i);
        }
        throw new ClassCastException("value is not nebula Time type");
    }

    public DateTime getDateTime(int i) {
        if (this.values.get(i) instanceof DateTime) {
            return (DateTime)this.values.get(i);
        }
        throw new ClassCastException("value is not nebula DateTime type");
    }

    public List<Object> getValues() {
        return this.values;
    }

    public String mkString(String sep) {
        return this.mkString("", sep, "");
    }

    public String mkString(String start, String sep, String end) {
        int n = this.size();
        StringBuilder builder = new StringBuilder();
        builder.append(start);
        if (n > 0) {
            builder.append(this.values.get(0));
            for (int i = 1; i < n; ++i) {
                builder.append(sep);
                builder.append(this.values.get(i));
            }
        }
        builder.append(end);
        return builder.toString();
    }
}

