/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class KeyValue
implements TBase,
Serializable,
Cloneable,
Comparable<KeyValue> {
    private static final TStruct STRUCT_DESC = new TStruct("KeyValue");
    private static final TField KEY_FIELD_DESC = new TField("key", 11, 1);
    private static final TField VALUE_FIELD_DESC = new TField("value", 11, 2);
    public byte[] key;
    public byte[] value;
    public static final int KEY = 1;
    public static final int VALUE = 2;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public KeyValue() {
    }

    public KeyValue(byte[] key, byte[] value) {
        this();
        this.key = key;
        this.value = value;
    }

    public KeyValue(KeyValue other) {
        if (other.isSetKey()) {
            this.key = TBaseHelper.deepCopy(other.key);
        }
        if (other.isSetValue()) {
            this.value = TBaseHelper.deepCopy(other.value);
        }
    }

    @Override
    public KeyValue deepCopy() {
        return new KeyValue(this);
    }

    @Deprecated
    public KeyValue clone() {
        return new KeyValue(this);
    }

    public byte[] getKey() {
        return this.key;
    }

    public KeyValue setKey(byte[] key) {
        this.key = key;
        return this;
    }

    public void unsetKey() {
        this.key = null;
    }

    public boolean isSetKey() {
        return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
        if (!value) {
            this.key = null;
        }
    }

    public byte[] getValue() {
        return this.value;
    }

    public KeyValue setValue(byte[] value) {
        this.value = value;
        return this;
    }

    public void unsetValue() {
        this.value = null;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValueIsSet(boolean value) {
        if (!value) {
            this.value = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetKey();
                    break;
                }
                this.setKey((byte[])value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetValue();
                    break;
                }
                this.setValue((byte[])value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getKey();
            }
            case 2: {
                return this.getValue();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetKey();
            }
            case 2: {
                return this.isSetValue();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof KeyValue) {
            return this.equals((KeyValue)that);
        }
        return false;
    }

    public boolean equals(KeyValue that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_key = this.isSetKey();
        boolean that_present_key = that.isSetKey();
        if (this_present_key || that_present_key) {
            if (!this_present_key || !that_present_key) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.key, that.key)) {
                return false;
            }
        }
        boolean this_present_value = this.isSetValue();
        boolean that_present_value = that.isSetValue();
        if (this_present_value || that_present_value) {
            if (!this_present_value || !that_present_value) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.value, that.value)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_key = this.isSetKey();
        builder.append(present_key);
        if (present_key) {
            builder.append(this.key);
        }
        boolean present_value = this.isSetValue();
        builder.append(present_value);
        if (present_value) {
            builder.append(this.value);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(KeyValue other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(other.isSetKey());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(other.isSetValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.value, other.value);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.key = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.value = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.key != null) {
            oprot.writeFieldBegin(KEY_FIELD_DESC);
            oprot.writeBinary(this.key);
            oprot.writeFieldEnd();
        }
        if (this.value != null) {
            oprot.writeFieldBegin(VALUE_FIELD_DESC);
            oprot.writeBinary(this.value);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("KeyValue");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("key");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getKey() == null) {
            sb.append("null");
        } else {
            int __key_size = Math.min(this.getKey().length, 128);
            for (i = 0; i < __key_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getKey()[i]).length() > 1 ? Integer.toHexString(this.getKey()[i]).substring(Integer.toHexString(this.getKey()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getKey()[i]).toUpperCase());
            }
            if (this.getKey().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("value");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getValue() == null) {
            sb.append("null");
        } else {
            int __value_size = Math.min(this.getValue().length, 128);
            for (i = 0; i < __value_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getValue()[i]).length() > 1 ? Integer.toHexString(this.getValue()[i]).substring(Integer.toHexString(this.getValue()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getValue()[i]).toUpperCase());
            }
            if (this.getValue().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("key", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("value", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(KeyValue.class, metaDataMap);
    }
}

