/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.Date;
import com.vesoft.nebula.DateTime;
import com.vesoft.nebula.Time;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.client.graph.data.Node;
import com.vesoft.nebula.client.graph.data.PathWrapper;
import com.vesoft.nebula.client.graph.data.Relationship;
import com.vesoft.nebula.client.graph.exception.InvalidValueException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class ValueWrapper {
    private final Value value;
    private final String decodeType = "utf-8";

    private String descType() {
        switch (this.value.getSetField()) {
            case 1: {
                return "NULL";
            }
            case 2: {
                return "BOOLEAN";
            }
            case 3: {
                return "INT";
            }
            case 4: {
                return "FLOAT";
            }
            case 5: {
                return "STRING";
            }
            case 6: {
                return "DATE";
            }
            case 7: {
                return "TIME";
            }
            case 8: {
                return "DATETIME";
            }
            case 9: {
                return "VERTEX";
            }
            case 10: {
                return "EDGE";
            }
            case 11: {
                return "PATH";
            }
            case 12: {
                return "LIST";
            }
            case 13: {
                return "MAP";
            }
            case 14: {
                return "SET";
            }
            case 15: {
                return "DATASET";
            }
        }
        throw new IllegalArgumentException("Unknown field id " + this.value.getSetField());
    }

    public ValueWrapper(Value value) {
        this.value = value;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value.getSetField() == 0;
    }

    public boolean isNull() {
        return this.value.getSetField() == 1;
    }

    public boolean isBoolean() {
        return this.value.getSetField() == 2;
    }

    public boolean isLong() {
        return this.value.getSetField() == 3;
    }

    public boolean isDouble() {
        return this.value.getSetField() == 4;
    }

    public boolean isString() {
        return this.value.getSetField() == 5;
    }

    public boolean isList() {
        return this.value.getSetField() == 12;
    }

    public boolean isSet() {
        return this.value.getSetField() == 14;
    }

    public boolean isMap() {
        return this.value.getSetField() == 13;
    }

    public boolean isTime() {
        return this.value.getSetField() == 7;
    }

    public boolean isDate() {
        return this.value.getSetField() == 6;
    }

    public boolean isDateTime() {
        return this.value.getSetField() == 8;
    }

    public boolean isVertex() {
        return this.value.getSetField() == 9;
    }

    public boolean isEdge() {
        return this.value.getSetField() == 10;
    }

    public boolean isPath() {
        return this.value.getSetField() == 11;
    }

    public NullType asNull() throws InvalidValueException {
        if (this.value.getSetField() == 1) {
            return new NullType((Integer)this.value.getFieldValue());
        }
        throw new InvalidValueException("Cannot get field nullType because value's type is " + this.descType());
    }

    public boolean asBoolean() throws InvalidValueException {
        if (this.value.getSetField() == 2) {
            return (Boolean)this.value.getFieldValue();
        }
        throw new InvalidValueException("Cannot get field boolean because value's type is " + this.descType());
    }

    public long asLong() throws InvalidValueException {
        if (this.value.getSetField() == 3) {
            return (Long)this.value.getFieldValue();
        }
        throw new InvalidValueException("Cannot get field long because value's type is " + this.descType());
    }

    public String asString() throws InvalidValueException, UnsupportedEncodingException {
        if (this.value.getSetField() == 5) {
            return new String((byte[])this.value.getFieldValue(), "utf-8");
        }
        throw new InvalidValueException("Cannot get field string because value's type is " + this.descType());
    }

    public double asDouble() throws InvalidValueException {
        if (this.value.getSetField() == 4) {
            return (Double)this.value.getFieldValue();
        }
        throw new InvalidValueException("Cannot get field double because value's type is " + this.descType());
    }

    public ArrayList<ValueWrapper> asList() throws InvalidValueException {
        if (this.value.getSetField() != 12) {
            throw new InvalidValueException("Cannot get field type `list' because value's type is " + this.descType());
        }
        ArrayList<ValueWrapper> values = new ArrayList<ValueWrapper>();
        for (Value value : (ArrayList)this.value.getFieldValue()) {
            values.add(new ValueWrapper(value));
        }
        return values;
    }

    public HashSet<ValueWrapper> asSet() throws InvalidValueException {
        if (this.value.getSetField() != 14) {
            throw new InvalidValueException("Cannot get field type `set' because value's type is " + this.descType());
        }
        HashSet<ValueWrapper> values = new HashSet<ValueWrapper>();
        for (Value value : (HashSet)this.value.getFieldValue()) {
            values.add(new ValueWrapper(value));
        }
        return values;
    }

    public HashMap<String, ValueWrapper> asMap() throws InvalidValueException, UnsupportedEncodingException {
        if (this.value.getSetField() != 13) {
            throw new InvalidValueException("Cannot get field type `set' because value's type is " + this.descType());
        }
        HashMap<String, ValueWrapper> kvs = new HashMap<String, ValueWrapper>();
        Map inValues = this.value.getMVal();
        for (Object key : inValues.keySet()) {
            kvs.put((String)key, new ValueWrapper((Value)inValues.get(key)));
        }
        return kvs;
    }

    public Time asTime() throws InvalidValueException {
        if (this.value.getSetField() == 7) {
            return (Time)this.value.getFieldValue();
        }
        throw new InvalidValueException("Cannot get field time because value's type is " + this.descType());
    }

    public Date asDate() throws InvalidValueException {
        if (this.value.getSetField() == 6) {
            return (Date)this.value.getFieldValue();
        }
        throw new InvalidValueException("Cannot get field date because value's type is " + this.descType());
    }

    public DateTime asDateTime() throws InvalidValueException {
        if (this.value.getSetField() == 8) {
            return (DateTime)this.value.getFieldValue();
        }
        throw new InvalidValueException("Cannot get field datetime because value's type is " + this.descType());
    }

    public Node asNode() throws InvalidValueException, UnsupportedEncodingException {
        if (this.value.getSetField() == 9) {
            return new Node(this.value.getVVal());
        }
        throw new InvalidValueException("Cannot get field Node because value's type is " + this.descType());
    }

    public Relationship asRelationship() {
        if (this.value.getSetField() == 10) {
            return new Relationship(this.value.getEVal());
        }
        throw new InvalidValueException("Cannot get field Relationship because value's type is " + this.descType());
    }

    public PathWrapper asPath() throws InvalidValueException, UnsupportedEncodingException {
        if (this.value.getSetField() == 11) {
            return new PathWrapper(this.value.getPVal());
        }
        throw new InvalidValueException("Cannot get field PathWrapper because value's type is " + this.descType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueWrapper that = (ValueWrapper)o;
        return Objects.equals(this.value, that.value) && Objects.equals("utf-8", that.decodeType);
    }

    public int hashCode() {
        return Objects.hash(this.value, "utf-8");
    }

    public static class NullType {
        public static final int __NULL__ = 0;
        public static final int NaN = 1;
        public static final int BAD_DATA = 2;
        public static final int BAD_TYPE = 3;
        public static final int ERR_OVERFLOW = 4;
        public static final int UNKNOWN_PROP = 5;
        public static final int DIV_BY_ZERO = 6;
        public static final int OUT_OF_RANGE = 7;
        int nullType;

        public NullType(int nullType) {
            this.nullType = nullType;
        }

        public int getNullType() {
            return this.nullType;
        }
    }
}

