/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage.async;

import com.facebook.thrift.TException;
import com.facebook.thrift.async.TAsyncClientManager;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.transport.TNonblockingSocket;
import com.facebook.thrift.transport.TNonblockingTransport;
import com.facebook.thrift.transport.TTransportException;
import com.google.common.base.Optional;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.client.meta.MetaClientImpl;
import com.vesoft.nebula.client.storage.async.AsyncStorageClient;
import com.vesoft.nebula.storage.StorageService;
import com.vesoft.nebula.utils.AddressUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncStorageClientImpl
extends AsyncStorageClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncStorageClientImpl.class);
    private Map<HostAddr, StorageService.AsyncClient> clientMap = new HashMap<HostAddr, StorageService.AsyncClient>();
    private MetaClientImpl metaClient;
    private TNonblockingTransport transport = null;
    private TAsyncClientManager manager;
    private Map<Integer, Map<Integer, HostAddr>> leaders = new HashMap<Integer, Map<Integer, HostAddr>>();
    private Map<String, Map<Integer, List<HostAddr>>> partsAlloc = new HashMap<String, Map<Integer, List<HostAddr>>>();

    public AsyncStorageClientImpl(List<HostAndPort> addresses, int timeout, int connectionRetry, int executionRetry) {
        super(addresses, timeout, connectionRetry, executionRetry);
    }

    private StorageService.AsyncClient connect(HostAddr addr) {
        if (this.clientMap.containsKey(addr)) {
            return this.clientMap.get(addr);
        }
        int retry = this.connectionRetry;
        while (retry-- != 0) {
            String ip = AddressUtil.intToIPv4(addr.getIp());
            int port = addr.getPort();
            try {
                this.manager = new TAsyncClientManager();
                this.transport = new TNonblockingSocket(ip, port, this.timeout);
                TBinaryProtocol.Factory protocol = new TBinaryProtocol.Factory();
                StorageService.AsyncClient client = new StorageService.AsyncClient(protocol, this.manager, this.transport);
                this.clientMap.put(addr, client);
                return client;
            }
            catch (TTransportException tte) {
                LOGGER.error("Connect failed: " + tte.getMessage());
            }
            catch (TException te) {
                LOGGER.error("Connect failed: " + te.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public ListenableFuture<Boolean> put(String space, String key, String value) {
        return null;
    }

    @Override
    public ListenableFuture<Optional<String>> get(String space, String key) {
        return null;
    }

    @Override
    public ListenableFuture<Boolean> remove(String space, String key) {
        return null;
    }

    @Override
    public int doConnect(List<HostAndPort> address) throws TException {
        return 0;
    }

    @Override
    public void close() {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
        try {
            this.manager.stop();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

