/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.vesoft.nebula.graph.ColumnValue;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class NebulaRow {
    private List<ColumnValue> columns;
    private Map<String, Integer> fieldIndex = Maps.newHashMap();

    public Integer getFieldIndex(String field) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(field));
        Preconditions.checkArgument(this.fieldIndex.containsKey(field));
        return this.fieldIndex.get(field);
    }

    public boolean exist(String field) {
        return this.fieldIndex.containsKey(field);
    }

    public String getString(int index) {
        byte[] value = this.columns.get(index).getStr();
        return new String(value, Charset.defaultCharset());
    }

    public String getString(String field) {
        Integer index = this.getFieldIndex(field);
        return this.getString(index);
    }

    public Long getLong(int index) {
        return this.columns.get(index).getInteger();
    }

    public Long getLong(String field) {
        Integer index = this.getFieldIndex(field);
        return this.getLong(index);
    }

    public Double getDouble(int index) {
        double value = this.columns.get(index).getDouble_precision();
        return value;
    }

    public Double getDouble(String field) {
        Integer index = this.getFieldIndex(field);
        return this.getDouble(index);
    }

    public Float getFloat(int index) {
        float value = this.columns.get(index).getSingle_precision();
        return Float.valueOf(value);
    }

    public Float getFloat(String field) {
        Integer index = this.getFieldIndex(field);
        return this.getFloat(index);
    }
}

