/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.meta;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.transport.TSocket;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.vesoft.nebula.AbstractClient;
import com.vesoft.nebula.ColumnDef;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.Schema;
import com.vesoft.nebula.client.meta.MetaClient;
import com.vesoft.nebula.client.meta.entry.SpaceNameID;
import com.vesoft.nebula.meta.EdgeItem;
import com.vesoft.nebula.meta.GetEdgeReq;
import com.vesoft.nebula.meta.GetEdgeResp;
import com.vesoft.nebula.meta.GetPartsAllocReq;
import com.vesoft.nebula.meta.GetPartsAllocResp;
import com.vesoft.nebula.meta.GetTagReq;
import com.vesoft.nebula.meta.GetTagResp;
import com.vesoft.nebula.meta.ListEdgesReq;
import com.vesoft.nebula.meta.ListEdgesResp;
import com.vesoft.nebula.meta.ListSpacesReq;
import com.vesoft.nebula.meta.ListSpacesResp;
import com.vesoft.nebula.meta.ListTagsReq;
import com.vesoft.nebula.meta.ListTagsResp;
import com.vesoft.nebula.meta.MetaService;
import com.vesoft.nebula.meta.TagItem;
import com.vesoft.nebula.utils.AddressUtil;
import com.vesoft.nebula.utils.NebulaTypeUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaClientImpl
extends AbstractClient
implements MetaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaClientImpl.class);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, Integer> spaceNameMap = Maps.newHashMap();
    private Map<String, Map<Integer, List<HostAndPort>>> spacePartLocation = Maps.newHashMap();
    private Map<String, Map<String, TagItem>> spaceTagItems = Maps.newHashMap();
    private Map<String, Map<String, EdgeItem>> spaceEdgeItems = Maps.newHashMap();
    private Map<String, Map<Integer, String>> tagNameMap = Maps.newHashMap();
    private Map<String, Map<Integer, String>> edgeNameMap = Maps.newHashMap();
    private MetaService.Client client;

    public MetaClientImpl(List<HostAndPort> addresses, int timeout, int connectionRetry, int executionRetry) {
        this(addresses, timeout, 3000, connectionRetry, executionRetry);
    }

    public MetaClientImpl(List<HostAndPort> addresses, int timeout, int connTimeout, int connectionRetry, int executionRetry) {
        super(addresses, timeout, connTimeout, connectionRetry, executionRetry);
    }

    public MetaClientImpl(List<HostAndPort> addresses) {
        super(addresses);
    }

    public MetaClientImpl(String host, int port) {
        super(host, port);
    }

    @Override
    public int doConnect(List<HostAndPort> addresses) throws TException {
        Random random = new Random(System.currentTimeMillis());
        int position = random.nextInt(addresses.size());
        HostAndPort address = addresses.get(position);
        this.transport = new TSocket(address.getHostText(), address.getPort(), this.timeout, this.connectionTimeout);
        this.transport.open();
        this.protocol = new TCompactProtocol(this.transport);
        this.client = new MetaService.Client(this.protocol);
        for (SpaceNameID space : this.listSpaces()) {
            String spaceName = space.getName();
            this.spaceNameMap.put(spaceName, space.getId());
            this.spacePartLocation.put(spaceName, this.getPartsAlloc(spaceName));
            HashMap tags = Maps.newHashMap();
            HashMap tagsName = Maps.newHashMap();
            for (TagItem item : this.getTags(spaceName)) {
                tags.put(item.getTag_name(), item);
                tagsName.put(item.getTag_id(), item.getTag_name());
            }
            this.spaceTagItems.put(spaceName, tags);
            this.tagNameMap.put(spaceName, tagsName);
            HashMap edges = Maps.newHashMap();
            HashMap edgesName = Maps.newHashMap();
            for (EdgeItem item : this.getEdges(spaceName)) {
                edges.put(item.getEdge_name(), item);
                edgesName.put(item.getEdge_type(), item.getEdge_name());
            }
            this.spaceEdgeItems.put(spaceName, edges);
            this.edgeNameMap.put(spaceName, edgesName);
        }
        return 0;
    }

    public Map<String, Integer> getSpaces() {
        return this.spaceNameMap;
    }

    @Override
    public int getSpaceIdFromCache(String name) {
        if (!this.spaceNameMap.containsKey(name)) {
            return -1;
        }
        return this.spaceNameMap.get(name);
    }

    @Override
    public List<SpaceNameID> listSpaces() {
        ListSpacesResp response;
        ListSpacesReq request = new ListSpacesReq();
        try {
            response = this.client.listSpaces(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("List Spaces Error: %s", e.getMessage()));
            return Lists.newLinkedList();
        }
        if (response.getCode() == 0) {
            return response.getSpaces().stream().map(SpaceNameID::new).collect(Collectors.toList());
        }
        LOGGER.error(String.format("List Spaces Error Code: %d", response.getCode()));
        return Lists.newLinkedList();
    }

    public List<HostAndPort> getPartFromCache(String spaceName, int part) {
        Map<Integer, List<HostAndPort>> map;
        if (!this.spacePartLocation.containsKey(spaceName)) {
            if (this.lock.writeLock().tryLock()) {
                this.spacePartLocation.put(spaceName, this.getPartsAlloc(spaceName));
            }
            this.lock.writeLock().unlock();
        }
        if (Objects.isNull(map = this.spacePartLocation.get(spaceName)) || !map.containsKey(part)) {
            return null;
        }
        return map.get(part);
    }

    @Override
    public Map<Integer, List<HostAndPort>> getPartsAlloc(String spaceName) {
        GetPartsAllocResp response;
        GetPartsAllocReq request = new GetPartsAllocReq();
        int spaceID = this.getSpaceIdFromCache(spaceName);
        request.setSpace_id(spaceID);
        try {
            response = this.client.getPartsAlloc(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Parts failed: %s", e.getMessage()));
            return Maps.newHashMap();
        }
        if (response.getCode() == 0) {
            HashMap addressMap = Maps.newHashMap();
            for (Map.Entry<Integer, List<HostAddr>> entry : response.getParts().entrySet()) {
                LinkedList addresses = Lists.newLinkedList();
                for (HostAddr address : entry.getValue()) {
                    String host = AddressUtil.intToIPv4(address.ip);
                    HostAndPort pair = HostAndPort.fromParts((String)host, (int)address.port);
                    addresses.add(pair);
                }
                addressMap.put(entry.getKey(), addresses);
            }
            return addressMap;
        }
        LOGGER.error(String.format("Get Parts Error: %s", response.getCode()));
        return Maps.newHashMap();
    }

    @Override
    public Map<String, Map<Integer, List<HostAndPort>>> getPartsAllocFromCache() {
        return this.spacePartLocation;
    }

    @Override
    public List<HostAndPort> getPartAllocFromCache(String spaceName, int part) {
        Map<Integer, List<HostAndPort>> partsAlloc;
        if (this.spacePartLocation.containsKey(spaceName) && (partsAlloc = this.spacePartLocation.get(spaceName)).containsKey(part)) {
            return partsAlloc.get(part);
        }
        return null;
    }

    @Override
    public TagItem getTagItemFromCache(String spaceName, String tagName) {
        Map<String, TagItem> map;
        if (!this.spaceTagItems.containsKey(spaceName)) {
            if (this.lock.writeLock().tryLock()) {
                HashMap tags = Maps.newHashMap();
                for (TagItem item : this.getTags(spaceName)) {
                    tags.put(item.getTag_name(), item);
                }
                this.spaceTagItems.put(spaceName, tags);
            }
            this.lock.writeLock().unlock();
        }
        if (Objects.isNull(map = this.spaceTagItems.get(spaceName)) || !map.containsKey(tagName)) {
            return null;
        }
        return map.get(tagName);
    }

    public String getTagNameFromCache(String spaceName, Integer tagId) {
        Map<Integer, String> map;
        if (this.tagNameMap.containsKey(spaceName) && (map = this.tagNameMap.get(spaceName)).containsKey(tagId)) {
            return map.get(tagId);
        }
        return null;
    }

    @Override
    public List<TagItem> getTags(String spaceName) {
        ListTagsResp response;
        ListTagsReq request = new ListTagsReq();
        int spaceID = this.getSpaceIdFromCache(spaceName);
        request.setSpace_id(spaceID);
        try {
            response = this.client.listTags(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Tag Error: %s", e.getMessage()));
            return Lists.newLinkedList();
        }
        if (response.getCode() == 0) {
            return response.getTags();
        }
        LOGGER.error(String.format("Get tags Error: %s", response.getCode()));
        return Lists.newLinkedList();
    }

    @Override
    public Schema getTag(String spaceName, String tagName) {
        GetTagResp response;
        GetTagReq request = new GetTagReq();
        int spaceID = this.getSpaceIdFromCache(spaceName);
        request.setSpace_id(spaceID);
        request.setTag_name(tagName);
        request.setVersion(-1L);
        try {
            response = this.client.getTag(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Tag Error: %s", e.getMessage()));
            return null;
        }
        if (response.getCode() == 0) {
            return response.getSchema();
        }
        return null;
    }

    @Override
    public Map<String, Class> getTagSchema(String spaceName, String tagName, long version) {
        GetTagResp response;
        HashMap result = Maps.newHashMap();
        if (!this.spaceNameMap.containsKey(spaceName)) {
            return result;
        }
        GetTagReq request = new GetTagReq();
        request.setSpace_id(this.spaceNameMap.get(spaceName));
        request.setTag_name(tagName);
        request.setVersion(version);
        try {
            response = this.client.getTag(request);
        }
        catch (TException e) {
            e.printStackTrace();
            return result;
        }
        for (ColumnDef column : response.getSchema().columns) {
            result.put(column.name, NebulaTypeUtil.supportedTypeToClass(column.type.type));
        }
        return result;
    }

    public Map<String, Class> getTagSchema(String spaceName, String tagName) {
        return this.getTagSchema(spaceName, tagName, -1L);
    }

    @Override
    public EdgeItem getEdgeItemFromCache(String spaceName, String edgeName) {
        Map<String, EdgeItem> map;
        if (!this.spaceEdgeItems.containsKey(spaceName)) {
            if (this.lock.writeLock().tryLock()) {
                HashMap edges = Maps.newHashMap();
                for (EdgeItem item : this.getEdges(spaceName)) {
                    edges.put(item.getEdge_name(), item);
                }
                this.spaceEdgeItems.put(spaceName, edges);
            }
            this.lock.writeLock().unlock();
        }
        if (Objects.isNull(map = this.spaceEdgeItems.get(spaceName)) || !map.containsKey(edgeName)) {
            return new EdgeItem();
        }
        return map.get(edgeName);
    }

    public String getEdgeNameFromCache(String spaceName, Integer edgeType) {
        Map<Integer, String> map;
        if (this.edgeNameMap.containsKey(spaceName) && (map = this.edgeNameMap.get(spaceName)).containsKey(edgeType)) {
            return map.get(edgeType);
        }
        return null;
    }

    @Override
    public List<EdgeItem> getEdges(String spaceName) {
        ListEdgesResp response;
        ListEdgesReq request = new ListEdgesReq();
        int spaceID = this.getSpaceIdFromCache(spaceName);
        request.setSpace_id(spaceID);
        try {
            response = this.client.listEdges(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Edge Error: %s", e.getMessage()));
            return Lists.newLinkedList();
        }
        if (response.getCode() == 0) {
            return response.getEdges();
        }
        LOGGER.error(String.format("Get tags Error: %s", response.getCode()));
        return Lists.newLinkedList();
    }

    @Override
    public Schema getEdge(String spaceName, String edgeName) {
        GetEdgeResp response;
        GetEdgeReq request = new GetEdgeReq();
        int spaceID = this.getSpaceIdFromCache(spaceName);
        request.setSpace_id(spaceID);
        request.setEdge_name(edgeName);
        request.setVersion(-1L);
        try {
            response = this.client.getEdge(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Tag Error: %s", e.getMessage()));
            return null;
        }
        if (response.getCode() == 0) {
            return response.getSchema();
        }
        return null;
    }

    @Override
    public Map<String, Class> getEdgeSchema(String spaceName, String edgeName, long version) {
        GetEdgeResp response;
        HashMap result = Maps.newHashMap();
        if (!this.spaceNameMap.containsKey(spaceName)) {
            return result;
        }
        GetEdgeReq request = new GetEdgeReq();
        request.setSpace_id(this.spaceNameMap.get(spaceName));
        request.setEdge_name(edgeName);
        request.setVersion(version);
        try {
            response = this.client.getEdge(request);
        }
        catch (TException e) {
            e.printStackTrace();
            return result;
        }
        for (ColumnDef column : response.getSchema().columns) {
            result.put(column.name, NebulaTypeUtil.supportedTypeToClass(column.type.type));
        }
        return result;
    }

    public Map<String, Class> getEdgeSchema(String spaceName, String edgeName) {
        return this.getEdgeSchema(spaceName, edgeName, -1L);
    }
}

