/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.ResponseCommon;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class GeneralResponse
implements TBase,
Serializable,
Cloneable,
Comparable<GeneralResponse> {
    private static final TStruct STRUCT_DESC = new TStruct("GeneralResponse");
    private static final TField RESULT_FIELD_DESC = new TField("result", 12, 1);
    private static final TField VALUES_FIELD_DESC = new TField("values", 13, 2);
    public ResponseCommon result;
    public Map<String, String> values;
    public static final int RESULT = 1;
    public static final int VALUES = 2;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public GeneralResponse() {
    }

    public GeneralResponse(ResponseCommon result) {
        this();
        this.result = result;
    }

    public GeneralResponse(ResponseCommon result, Map<String, String> values) {
        this();
        this.result = result;
        this.values = values;
    }

    public GeneralResponse(GeneralResponse other) {
        if (other.isSetResult()) {
            this.result = TBaseHelper.deepCopy(other.result);
        }
        if (other.isSetValues()) {
            this.values = TBaseHelper.deepCopy(other.values);
        }
    }

    @Override
    public GeneralResponse deepCopy() {
        return new GeneralResponse(this);
    }

    @Deprecated
    public GeneralResponse clone() {
        return new GeneralResponse(this);
    }

    public ResponseCommon getResult() {
        return this.result;
    }

    public GeneralResponse setResult(ResponseCommon result) {
        this.result = result;
        return this;
    }

    public void unsetResult() {
        this.result = null;
    }

    public boolean isSetResult() {
        return this.result != null;
    }

    public void setResultIsSet(boolean value) {
        if (!value) {
            this.result = null;
        }
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public GeneralResponse setValues(Map<String, String> values) {
        this.values = values;
        return this;
    }

    public void unsetValues() {
        this.values = null;
    }

    public boolean isSetValues() {
        return this.values != null;
    }

    public void setValuesIsSet(boolean value) {
        if (!value) {
            this.values = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetResult();
                    break;
                }
                this.setResult((ResponseCommon)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetValues();
                    break;
                }
                this.setValues((Map)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getResult();
            }
            case 2: {
                return this.getValues();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetResult();
            }
            case 2: {
                return this.isSetValues();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof GeneralResponse) {
            return this.equals((GeneralResponse)that);
        }
        return false;
    }

    public boolean equals(GeneralResponse that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_result = this.isSetResult();
        boolean that_present_result = that.isSetResult();
        if (this_present_result || that_present_result) {
            if (!this_present_result || !that_present_result) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.result, that.result)) {
                return false;
            }
        }
        boolean this_present_values = this.isSetValues();
        boolean that_present_values = that.isSetValues();
        if (this_present_values || that_present_values) {
            if (!this_present_values || !that_present_values) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.values, that.values)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_result = this.isSetResult();
        builder.append(present_result);
        if (present_result) {
            builder.append((Object)this.result);
        }
        boolean present_values = this.isSetValues();
        builder.append(present_values);
        if (present_values) {
            builder.append(this.values);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(GeneralResponse other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetResult()).compareTo(other.isSetResult());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.result, other.result);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetValues()).compareTo(other.isSetValues());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.values, other.values);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 12) {
                        this.result = new ResponseCommon();
                        this.result.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 13) {
                        TMap _map242 = iprot.readMapBegin();
                        this.values = new HashMap<String, String>(Math.max(0, 2 * _map242.size));
                        int _i243 = 0;
                        while (_map242.size < 0 ? iprot.peekMap() : _i243 < _map242.size) {
                            String _key244 = iprot.readString();
                            String _val245 = iprot.readString();
                            this.values.put(_key244, _val245);
                            ++_i243;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.result != null) {
            oprot.writeFieldBegin(RESULT_FIELD_DESC);
            this.result.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.values != null) {
            oprot.writeFieldBegin(VALUES_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 11, this.values.size()));
            for (Map.Entry<String, String> _iter246 : this.values.entrySet()) {
                oprot.writeString(_iter246.getKey());
                oprot.writeString(_iter246.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("GeneralResponse");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("result");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getResult() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getResult(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("values");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getValues() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getValues(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.result == null) {
            throw new TProtocolException(6, "Required field 'result' was not present! Struct: " + this.toString());
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("result", 1, new StructMetaData(12, ResponseCommon.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("values", 3, new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(GeneralResponse.class, metaDataMap);
    }
}

