/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage.processor;

import com.vesoft.nebula.Schema;
import com.vesoft.nebula.client.meta.MetaClientImpl;
import com.vesoft.nebula.client.storage.processor.Processor;
import com.vesoft.nebula.data.Property;
import com.vesoft.nebula.data.Result;
import com.vesoft.nebula.data.Row;
import com.vesoft.nebula.data.RowReader;
import com.vesoft.nebula.meta.EdgeItem;
import com.vesoft.nebula.storage.ScanEdge;
import com.vesoft.nebula.storage.ScanEdgeResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanEdgeProcessor
implements Processor<ScanEdgeResponse> {
    private MetaClientImpl metaClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanEdgeProcessor.class);

    public ScanEdgeProcessor(MetaClientImpl metaClient) {
        this.metaClient = metaClient;
    }

    @Override
    public Result process(String spaceName, ScanEdgeResponse response) {
        int edgeType;
        HashMap<Integer, RowReader> readers = new HashMap<Integer, RowReader>();
        HashMap<Result.RowDesc, List<Row>> rows = new HashMap<Result.RowDesc, List<Row>>();
        HashMap<Integer, Result.RowDesc> edgeTypeIndex = new HashMap<Integer, Result.RowDesc>();
        if (response.edge_schema != null) {
            for (Map.Entry entry : response.edge_schema.entrySet()) {
                edgeType = (Integer)entry.getKey();
                Schema schema = (Schema)entry.getValue();
                String edgeName = this.metaClient.getEdgeNameFromCache(spaceName, edgeType);
                EdgeItem edgeItem = this.metaClient.getEdgeItemFromCache(spaceName, edgeName);
                long schemaVersion = edgeItem.version;
                readers.put(edgeType, new RowReader(schema, schemaVersion));
                Result.RowDesc desc = new Result.RowDesc(Result.RowType.EDGE, edgeName);
                rows.put(desc, new ArrayList());
                edgeTypeIndex.put(edgeType, desc);
            }
        }
        if (response.edge_data != null) {
            for (ScanEdge scanEdge2 : response.edge_data) {
                edgeType = scanEdge2.type;
                if (!readers.containsKey(edgeType)) continue;
                RowReader reader = (RowReader)readers.get(edgeType);
                Property[] defaultProperties = reader.edgeKey(scanEdge2.src, scanEdge2.type, scanEdge2.dst);
                Property[] properties = reader.decodeValue(scanEdge2.value);
                Result.RowDesc desc = (Result.RowDesc)edgeTypeIndex.get(edgeType);
                ((List)rows.get(desc)).add(new Row(defaultProperties, properties));
            }
        }
        return new Result(rows);
    }
}

