/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.graph.client;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.transport.TSocket;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.vesoft.nebula.graph.AuthResponse;
import com.vesoft.nebula.graph.ExecutionResponse;
import com.vesoft.nebula.graph.GraphService;
import com.vesoft.nebula.graph.client.ConnectionException;
import com.vesoft.nebula.graph.client.GraphClient;
import com.vesoft.nebula.graph.client.NGQLException;
import com.vesoft.nebula.graph.client.ResultSet;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphClientImpl
implements GraphClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphClientImpl.class);
    private final List<HostAndPort> addresses;
    private final int connectionRetry;
    private final int executionRetry;
    private final int timeout;
    private long sessionID;
    private TTransport transport = null;
    private GraphService.Client client;

    public GraphClientImpl(List<HostAndPort> addresses, int timeout, int connectionRetry, int executionRetry) {
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((connectionRetry > 0 ? 1 : 0) != 0);
        for (HostAndPort address : addresses) {
            String host = address.getHost();
            int port = address.getPort();
            if (InetAddresses.isInetAddress((String)host) && port > 0 && port < 65535) continue;
            throw new IllegalArgumentException(String.format("%s:%d is not a valid address", host, port));
        }
        this.addresses = addresses;
        this.timeout = timeout;
        this.connectionRetry = connectionRetry;
        this.executionRetry = executionRetry;
    }

    public GraphClientImpl(List<HostAndPort> addresses) {
        this(addresses, 1000, 3, 3);
    }

    public GraphClientImpl(String host, int port) {
        this(Lists.newArrayList((Object[])new HostAndPort[]{HostAndPort.fromParts((String)host, (int)port)}), 1000, 3, 3);
    }

    @Override
    public int connect(String username, String password) {
        int retry = this.connectionRetry;
        while (retry-- != 0) {
            Random random = new Random(System.currentTimeMillis());
            int position = random.nextInt(this.addresses.size());
            HostAndPort address = this.addresses.get(position);
            this.transport = new TSocket(address.getHost(), address.getPort(), this.timeout);
            TCompactProtocol protocol = new TCompactProtocol(this.transport);
            try {
                this.transport.open();
                this.client = new GraphService.Client(protocol);
                AuthResponse result = this.client.authenticate(username, password);
                if (result.getError_code() == -4) {
                    LOGGER.error("User name or password error");
                    return -4;
                }
                if (result.getError_code() != 0) {
                    LOGGER.error(String.format("Connect address %s failed : %s", address.toString(), result.getError_msg()));
                    continue;
                }
                this.sessionID = result.getSession_id();
                return 0;
            }
            catch (TTransportException tte) {
                LOGGER.error("Connect failed: " + tte.getMessage());
            }
            catch (TException te) {
                LOGGER.error("Connect failed: " + te.getMessage());
            }
        }
        return -2;
    }

    @Override
    public int switchSpace(String space) {
        return this.execute(String.format("USE %s", space));
    }

    @Override
    public int execute(String statement) {
        if (!this.checkTransportOpened(this.transport)) {
            return -1;
        }
        int retry = this.executionRetry;
        if (retry-- > 0) {
            try {
                ExecutionResponse executionResponse = this.client.execute(this.sessionID, statement);
                if (executionResponse.getError_code() != 0) {
                    LOGGER.error("execute error: " + executionResponse.getError_msg());
                }
                return executionResponse.getError_code();
            }
            catch (TException e) {
                LOGGER.error("Thrift rpc call failed: " + e.getMessage());
                return -3;
            }
        }
        return -3;
    }

    @Override
    public ResultSet executeQuery(String statement) throws ConnectionException, NGQLException, TException {
        if (!this.checkTransportOpened(this.transport)) {
            LOGGER.error("Thrift rpc call failed");
            throw new ConnectionException();
        }
        ExecutionResponse executionResponse = this.client.execute(this.sessionID, statement);
        int code = executionResponse.getError_code();
        if (code == 0) {
            return new ResultSet(executionResponse.getColumn_names(), executionResponse.getRows());
        }
        LOGGER.error("Execute error: " + executionResponse.getError_msg());
        throw new NGQLException(code);
    }

    private boolean checkTransportOpened(TTransport transport) {
        return transport != null && transport.isOpen();
    }

    @Override
    public void close() {
        if (!this.checkTransportOpened(this.transport)) {
            return;
        }
        try {
            this.client.signout(this.sessionID);
        }
        catch (TException e) {
            LOGGER.error("Disconnect error: " + e.getMessage());
        }
        finally {
            this.transport.close();
        }
    }
}

