/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta.client;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.transport.TSocket;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.EdgeItem;
import com.vesoft.nebula.meta.GetPartsAllocReq;
import com.vesoft.nebula.meta.GetPartsAllocResp;
import com.vesoft.nebula.meta.IdName;
import com.vesoft.nebula.meta.ListEdgesReq;
import com.vesoft.nebula.meta.ListEdgesResp;
import com.vesoft.nebula.meta.ListSpacesReq;
import com.vesoft.nebula.meta.ListSpacesResp;
import com.vesoft.nebula.meta.ListTagsReq;
import com.vesoft.nebula.meta.ListTagsResp;
import com.vesoft.nebula.meta.MetaService;
import com.vesoft.nebula.meta.TagItem;
import com.vesoft.nebula.meta.client.MetaClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaClientImpl
implements MetaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaClientImpl.class);
    private MetaService.Client client;
    private TTransport transport = null;
    private final List<HostAndPort> addresses;
    private final int connectionRetry;
    private final int timeout;
    private HostAndPort leader;
    private List<IdName> spaces;
    private Map<String, Integer> spaceNames;
    private Map<Integer, Map<Integer, List<HostAddr>>> parts;
    private Map<Integer, Map<String, TagItem>> tagItems;
    private Map<Integer, Map<String, EdgeItem>> edgeItems;

    public MetaClientImpl(List<HostAndPort> addresses, int timeout, int connectionRetry) {
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((connectionRetry > 0 ? 1 : 0) != 0);
        if (addresses.isEmpty()) {
            throw new IllegalArgumentException("No meta server address is specified.");
        }
        addresses.forEach(address -> {
            String host = address.getHost();
            int port = address.getPort();
            if (!InetAddresses.isInetAddress((String)host) || port <= 0 || port >= 65535) {
                throw new IllegalArgumentException(String.format("%s:%d is not a valid address", host, port));
            }
        });
        this.spaces = Lists.newArrayList();
        this.spaceNames = Maps.newHashMap();
        this.parts = Maps.newHashMap();
        this.tagItems = Maps.newHashMap();
        this.edgeItems = Maps.newHashMap();
        this.addresses = addresses;
        this.timeout = timeout;
        this.connectionRetry = connectionRetry;
        this.init();
    }

    public MetaClientImpl(String host, int port) {
        this(Lists.newArrayList((Object[])new HostAndPort[]{HostAndPort.fromParts((String)host, (int)port)}), 1000, 3);
    }

    public MetaClientImpl(List<HostAndPort> addresses) {
        this(addresses, 1000, 3);
    }

    @Override
    public List<HostAddr> getPart(int spaceId, int partId) {
        Map<Integer, List<HostAddr>> map;
        if (!this.parts.containsKey(spaceId)) {
            this.getParts(spaceId);
        }
        if ((map = this.parts.get(spaceId)) == null || map.isEmpty()) {
            return null;
        }
        return map.get(partId);
    }

    @Override
    public List<HostAddr> getPart(String spaceName, int partId) {
        if (!this.spaceNames.containsKey(spaceName)) {
            LOGGER.error(String.format("There is no space named: %s", spaceName));
            return null;
        }
        return this.getPart(this.spaceNames.get(spaceName), partId);
    }

    @Override
    public Integer getTagId(int spaceId, String tagName) {
        Map<String, TagItem> map;
        if (!this.tagItems.containsKey(spaceId)) {
            this.getTagItems(spaceId);
        }
        if ((map = this.tagItems.get(spaceId)) == null || map.isEmpty()) {
            return null;
        }
        TagItem tag = map.get(tagName);
        return tag == null ? null : Integer.valueOf(tag.getTag_id());
    }

    @Override
    public Integer getTagId(String spaceName, String tagName) {
        if (!this.spaceNames.containsKey(spaceName)) {
            LOGGER.error(String.format("There is no space named: %s", spaceName));
            return null;
        }
        return this.getTagId(this.spaceNames.get(spaceName), tagName);
    }

    @Override
    public Integer getEdgeType(int space, String edgeName) {
        Map<String, EdgeItem> map;
        if (!this.edgeItems.containsKey(space)) {
            this.getEdgeTypes(space);
        }
        if ((map = this.edgeItems.get(space)) == null || map.isEmpty()) {
            return null;
        }
        EdgeItem edge = map.get(edgeName);
        return edge == null ? null : Integer.valueOf(edge.getEdge_type());
    }

    @Override
    public Integer getEdgeType(String spaceName, String edgeName) {
        if (!this.spaceNames.containsKey(spaceName)) {
            LOGGER.error(String.format("There is no space named: %s", spaceName));
            return null;
        }
        return this.getEdgeType(this.spaceNames.get(spaceName), edgeName);
    }

    public void init() {
        boolean isConnected = this.connect();
        if (!isConnected) {
            LOGGER.error("Connection has not been established. Connect Failed");
        }
        this.listSpaces();
        for (IdName space : this.spaces) {
            int spaceId = space.getId().getSpace_id();
            this.spaceNames.put(space.getName(), spaceId);
            this.getParts(spaceId);
            this.getTagItems(spaceId);
            this.getEdgeTypes(spaceId);
        }
    }

    private boolean connect() {
        int retry = this.connectionRetry;
        while (retry-- != 0) {
            Random random = new Random(System.currentTimeMillis());
            int position = random.nextInt(this.addresses.size());
            HostAndPort address = this.addresses.get(position);
            this.transport = new TSocket(address.getHost(), address.getPort(), this.timeout);
            TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
            try {
                this.transport.open();
                this.client = new MetaService.Client(protocol);
                return true;
            }
            catch (TTransportException tte) {
                LOGGER.error("Connect failed: " + tte.getMessage());
            }
            catch (TException te) {
                LOGGER.error("Connect failed: " + te.getMessage());
            }
        }
        return false;
    }

    private boolean listSpaces() {
        ListSpacesResp response;
        ListSpacesReq request = new ListSpacesReq();
        try {
            response = this.client.listSpaces(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("List Spaces Error: %s", e.getMessage()));
            return false;
        }
        if (response.getCode() != 0) {
            LOGGER.error(String.format("Init Error: %s", response.getCode()));
            return false;
        }
        this.spaces = response.getSpaces();
        return true;
    }

    @Override
    public Map<Integer, Map<Integer, List<HostAddr>>> getParts() {
        return this.parts;
    }

    private boolean getParts(int spaceId) {
        GetPartsAllocResp response;
        GetPartsAllocReq request = new GetPartsAllocReq();
        request.setSpace_id(spaceId);
        try {
            response = this.client.getPartsAlloc(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Parts failed: %s", e.getMessage()));
            return false;
        }
        if (response.getCode() != 0) {
            LOGGER.error(String.format("Get Parts Error: %s", response.getCode()));
            return false;
        }
        Map<Integer, List<HostAddr>> part = response.getParts();
        this.parts.put(spaceId, part);
        return true;
    }

    private boolean getTagItems(int spaceId) {
        ListTagsResp response;
        ListTagsReq request = new ListTagsReq();
        request.setSpace_id(spaceId);
        try {
            response = this.client.listTags(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Tag Error: %s", e.getMessage()));
            return false;
        }
        if (response.getCode() == 0) {
            List<TagItem> tagItem = response.getTags();
            HashMap<String, TagItem> tmp = new HashMap<String, TagItem>();
            if (tagItem != null) {
                for (TagItem ti : tagItem) {
                    tmp.put(ti.getTag_name(), ti);
                }
                this.tagItems.put(spaceId, tmp);
            }
        } else {
            LOGGER.error(String.format("Get tags Error: %s", response.getCode()));
            return false;
        }
        return true;
    }

    private boolean getEdgeTypes(int spaceId) {
        ListEdgesResp response;
        ListEdgesReq request = new ListEdgesReq();
        request.setSpace_id(spaceId);
        try {
            response = this.client.listEdges(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Edge Error: %s", e.getMessage()));
            return false;
        }
        if (response.getCode() == 0) {
            List<EdgeItem> edgeItem = response.getEdges();
            HashMap<String, EdgeItem> tmp = new HashMap<String, EdgeItem>();
            if (!Objects.isNull(edgeItem)) {
                for (EdgeItem ei : edgeItem) {
                    tmp.put(ei.getEdge_name(), ei);
                }
                this.edgeItems.put(spaceId, tmp);
            }
        } else {
            LOGGER.error(String.format("Get tags Error: %s", response.getCode()));
            return false;
        }
        return true;
    }

    public HostAndPort getLeader() {
        return this.leader;
    }

    public List<IdName> getSpaces() {
        return this.spaces;
    }

    @Override
    public void close() throws Exception {
    }
}

