/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import io.debezium.annotation.Immutable;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.ColumnMapper;
import io.debezium.relational.mapping.TruncateStrings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaskStrings
implements ColumnMapper {
    private final Function<Column, ValueConverter> converterFromColumn;

    public MaskStrings(String maskValue) {
        Objects.requireNonNull(maskValue);
        this.converterFromColumn = ignored -> new MaskingValueConverter(maskValue);
    }

    public MaskStrings(byte[] salt, String hashAlgorithm, HashingByteArrayStrategy hashingByteArrayStrategy) {
        Objects.requireNonNull(salt);
        Objects.requireNonNull(hashAlgorithm);
        this.converterFromColumn = column -> {
            HashValueConverter hashValueConverter = new HashValueConverter(salt, hashAlgorithm, hashingByteArrayStrategy);
            if (column.length() > 0) {
                return hashValueConverter.and(new TruncateStrings.TruncatingValueConverter(column.length()));
            }
            return hashValueConverter;
        };
    }

    @Override
    public ValueConverter create(Column column) {
        switch (column.jdbcType()) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2011: {
                return this.converterFromColumn.apply(column);
            }
        }
        return ValueConverter.passthrough();
    }

    @Override
    public void alterFieldSchema(Column column, SchemaBuilder schemaBuilder) {
        schemaBuilder.parameter("masked", "true");
    }

    public static enum HashingByteArrayStrategy {
        V1{

            @Override
            byte[] toByteArray(Serializable value) throws IOException {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(value);
                return bos.toByteArray();
            }
        }
        ,
        V2{

            @Override
            byte[] toByteArray(Serializable value) {
                return value.toString().getBytes();
            }
        };


        abstract byte[] toByteArray(Serializable var1) throws IOException;
    }

    @Immutable
    protected static final class HashValueConverter
    implements ValueConverter {
        private static final Logger LOGGER = LoggerFactory.getLogger(HashValueConverter.class);
        private final byte[] salt;
        private final MessageDigest hashAlgorithm;
        private final HashingByteArrayStrategy hashingByteArrayStrategy;

        public HashValueConverter(byte[] salt, String hashAlgorithm, HashingByteArrayStrategy hashingByteArrayStrategy) {
            this.salt = salt;
            this.hashingByteArrayStrategy = hashingByteArrayStrategy;
            try {
                this.hashAlgorithm = MessageDigest.getInstance(hashAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public Object convert(Object value) {
            block3: {
                if (value instanceof Serializable) {
                    try {
                        return this.toHash((Serializable)value);
                    }
                    catch (IOException e) {
                        if (!LOGGER.isErrorEnabled()) break block3;
                        LOGGER.error("can't calculate hash", (Throwable)e);
                    }
                }
            }
            return null;
        }

        private String toHash(Serializable value) throws IOException {
            this.hashAlgorithm.reset();
            this.hashAlgorithm.update(this.salt);
            byte[] valueToByteArray = this.hashingByteArrayStrategy.toByteArray(value);
            return this.convertToHexadecimalFormat(this.hashAlgorithm.digest(valueToByteArray));
        }

        private String convertToHexadecimalFormat(byte[] bytes) {
            StringBuilder hashString = new StringBuilder();
            for (byte b : bytes) {
                hashString.append(String.format("%02x", b));
            }
            return hashString.toString();
        }
    }

    @Immutable
    protected static final class MaskingValueConverter
    implements ValueConverter {
        protected final String maskValue;

        public MaskingValueConverter(String maskValue) {
            this.maskValue = maskValue;
            assert (this.maskValue != null);
        }

        @Override
        public Object convert(Object value) {
            return this.maskValue;
        }
    }
}

