/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest;

import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectRestConfigurable
implements Configurable<ResourceConfig> {
    private static final Logger log = LoggerFactory.getLogger(ConnectRestConfigurable.class);
    private static final boolean ALLOWED_TO_REGISTER = true;
    private static final boolean NOT_ALLOWED_TO_REGISTER = false;
    private final ResourceConfig resourceConfig;

    public ConnectRestConfigurable(ResourceConfig resourceConfig) {
        Objects.requireNonNull(resourceConfig, "ResourceConfig can't be null");
        this.resourceConfig = resourceConfig;
    }

    public Configuration getConfiguration() {
        return this.resourceConfig.getConfiguration();
    }

    public ResourceConfig property(String name, Object value) {
        return this.resourceConfig.property(name, value);
    }

    public ResourceConfig register(Object component) {
        if (this.allowedToRegister(component)) {
            this.resourceConfig.register(component);
        }
        return this.resourceConfig;
    }

    public ResourceConfig register(Object component, int priority) {
        if (this.allowedToRegister(component)) {
            this.resourceConfig.register(component, priority);
        }
        return this.resourceConfig;
    }

    public ResourceConfig register(Object component, Map<Class<?>, Integer> contracts) {
        if (this.allowedToRegister(component)) {
            this.resourceConfig.register(component, contracts);
        }
        return this.resourceConfig;
    }

    public ResourceConfig register(Object component, Class<?> ... contracts) {
        if (this.allowedToRegister(component)) {
            this.resourceConfig.register(component, (Class[])contracts);
        }
        return this.resourceConfig;
    }

    public ResourceConfig register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        if (this.allowedToRegister(componentClass)) {
            this.resourceConfig.register(componentClass, contracts);
        }
        return this.resourceConfig;
    }

    public ResourceConfig register(Class<?> componentClass, Class<?> ... contracts) {
        if (this.allowedToRegister(componentClass)) {
            this.resourceConfig.register(componentClass, (Class[])contracts);
        }
        return this.resourceConfig;
    }

    public ResourceConfig register(Class<?> componentClass, int priority) {
        if (this.allowedToRegister(componentClass)) {
            this.resourceConfig.register(componentClass, priority);
        }
        return this.resourceConfig;
    }

    public ResourceConfig register(Class<?> componentClass) {
        if (this.allowedToRegister(componentClass)) {
            this.resourceConfig.register(componentClass);
        }
        return this.resourceConfig;
    }

    private boolean allowedToRegister(Object component) {
        if (this.resourceConfig.isRegistered(component)) {
            log.warn("The resource {} is already registered", component);
            return false;
        }
        return true;
    }

    private boolean allowedToRegister(Class<?> componentClass) {
        if (this.resourceConfig.isRegistered(componentClass)) {
            log.warn("The resource {} is already registered", componentClass);
            return false;
        }
        return true;
    }
}

