/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.json;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.json.DecimalFormat;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.ConverterConfig;
import java.util.Locale;
import java.util.Map;

public class JsonConverterConfig
extends ConverterConfig {
    public static final String SCHEMAS_ENABLE_CONFIG = "schemas.enable";
    public static final boolean SCHEMAS_ENABLE_DEFAULT = true;
    private static final String SCHEMAS_ENABLE_DOC = "Include schemas within each of the serialized values and keys.";
    private static final String SCHEMAS_ENABLE_DISPLAY = "Enable Schemas";
    public static final String SCHEMAS_CACHE_SIZE_CONFIG = "schemas.cache.size";
    public static final int SCHEMAS_CACHE_SIZE_DEFAULT = 1000;
    private static final String SCHEMAS_CACHE_SIZE_DOC = "The maximum number of schemas that can be cached in this converter instance.";
    private static final String SCHEMAS_CACHE_SIZE_DISPLAY = "Schema Cache Size";
    public static final String DECIMAL_FORMAT_CONFIG = "decimal.format";
    public static final String DECIMAL_FORMAT_DEFAULT = DecimalFormat.BASE64.name();
    private static final String DECIMAL_FORMAT_DOC = "Controls which format this converter will serialize decimals in. This value is case insensitive and can be either 'BASE64' (default) or 'NUMERIC'";
    private static final String DECIMAL_FORMAT_DISPLAY = "Decimal Format";
    private static final ConfigDef CONFIG;
    private final boolean schemasEnabled = this.getBoolean("schemas.enable");
    private final int schemaCacheSize = this.getInt("schemas.cache.size");
    private final DecimalFormat decimalFormat = DecimalFormat.valueOf(this.getString("decimal.format").toUpperCase(Locale.ROOT));

    public static ConfigDef configDef() {
        return CONFIG;
    }

    public JsonConverterConfig(Map<String, ?> props) {
        super(CONFIG, props);
    }

    public boolean schemasEnabled() {
        return this.schemasEnabled;
    }

    public int schemaCacheSize() {
        return this.schemaCacheSize;
    }

    public DecimalFormat decimalFormat() {
        return this.decimalFormat;
    }

    static {
        String group = "Schemas";
        int orderInGroup = 0;
        CONFIG = ConverterConfig.newConfigDef();
        CONFIG.define(SCHEMAS_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.HIGH, SCHEMAS_ENABLE_DOC, group, orderInGroup++, ConfigDef.Width.MEDIUM, SCHEMAS_ENABLE_DISPLAY);
        CONFIG.define(SCHEMAS_CACHE_SIZE_CONFIG, ConfigDef.Type.INT, 1000, ConfigDef.Importance.HIGH, SCHEMAS_CACHE_SIZE_DOC, group, orderInGroup++, ConfigDef.Width.MEDIUM, SCHEMAS_CACHE_SIZE_DISPLAY);
        group = "Serialization";
        orderInGroup = 0;
        CONFIG.define(DECIMAL_FORMAT_CONFIG, ConfigDef.Type.STRING, (Object)DECIMAL_FORMAT_DEFAULT, ConfigDef.CaseInsensitiveValidString.in(DecimalFormat.BASE64.name(), DecimalFormat.NUMERIC.name()), ConfigDef.Importance.LOW, DECIMAL_FORMAT_DOC, group, orderInGroup++, ConfigDef.Width.MEDIUM, DECIMAL_FORMAT_DISPLAY);
    }
}

