/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.json;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.cache.Cache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.cache.LRUCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.cache.SynchronizedCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.SerializationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.ConnectSchema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Date;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Decimal;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaAndValue;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Time;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Timestamp;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.json.JsonConverterConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.json.JsonDeserializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.json.JsonSchema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.json.JsonSerializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.Converter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.ConverterType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.HeaderConverter;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JsonConverter
implements Converter,
HeaderConverter {
    private static final Map<Schema.Type, JsonToConnectTypeConverter> TO_CONNECT_CONVERTERS = new EnumMap<Schema.Type, JsonToConnectTypeConverter>(Schema.Type.class);
    private static final HashMap<String, LogicalTypeConverter> LOGICAL_CONVERTERS;
    private static final JsonNodeFactory JSON_NODE_FACTORY;
    private JsonConverterConfig config;
    private Cache<Schema, ObjectNode> fromConnectSchemaCache;
    private Cache<JsonNode, Schema> toConnectSchemaCache;
    private final JsonSerializer serializer = new JsonSerializer(Utils.mkSet(new SerializationFeature[0]), JSON_NODE_FACTORY);
    private final JsonDeserializer deserializer = new JsonDeserializer(Utils.mkSet(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS), JSON_NODE_FACTORY);

    long sizeOfFromConnectSchemaCache() {
        return this.fromConnectSchemaCache.size();
    }

    long sizeOfToConnectSchemaCache() {
        return this.toConnectSchemaCache.size();
    }

    @Override
    public ConfigDef config() {
        return JsonConverterConfig.configDef();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.config = new JsonConverterConfig(configs);
        this.serializer.configure(configs, this.config.type() == ConverterType.KEY);
        this.deserializer.configure(configs, this.config.type() == ConverterType.KEY);
        this.fromConnectSchemaCache = new SynchronizedCache<Schema, ObjectNode>(new LRUCache(this.config.schemaCacheSize()));
        this.toConnectSchemaCache = new SynchronizedCache<JsonNode, Schema>(new LRUCache(this.config.schemaCacheSize()));
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        HashMap conf = new HashMap(configs);
        conf.put("converter.type", isKey ? ConverterType.KEY.getName() : ConverterType.VALUE.getName());
        this.configure(conf);
    }

    @Override
    public void close() {
    }

    @Override
    public byte[] fromConnectHeader(String topic, String headerKey, Schema schema, Object value) {
        return this.fromConnectData(topic, schema, value);
    }

    @Override
    public SchemaAndValue toConnectHeader(String topic, String headerKey, byte[] value) {
        return this.toConnectData(topic, value);
    }

    @Override
    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        if (schema == null && value == null) {
            return null;
        }
        JsonNode jsonValue = this.config.schemasEnabled() ? this.convertToJsonWithEnvelope(schema, value) : this.convertToJsonWithoutEnvelope(schema, value);
        try {
            return this.serializer.serialize(topic, jsonValue);
        }
        catch (SerializationException e) {
            throw new DataException("Converting Kafka Connect data to byte[] failed due to serialization error: ", e);
        }
    }

    @Override
    public SchemaAndValue toConnectData(String topic, byte[] value) {
        JsonNode jsonValue;
        if (value == null) {
            return SchemaAndValue.NULL;
        }
        try {
            jsonValue = this.deserializer.deserialize(topic, value);
        }
        catch (SerializationException e) {
            throw new DataException("Converting byte[] to Kafka Connect data failed due to serialization error: ", e);
        }
        if (!(!this.config.schemasEnabled() || jsonValue.isObject() && jsonValue.size() == 2 && jsonValue.has("schema") && jsonValue.has("payload"))) {
            throw new DataException("JsonConverter with schemas.enable requires \"schema\" and \"payload\" fields and may not contain additional fields. If you are trying to deserialize plain JSON data, set schemas.enable=false in your converter configuration.");
        }
        if (!this.config.schemasEnabled()) {
            ObjectNode envelope = JSON_NODE_FACTORY.objectNode();
            envelope.set("schema", null);
            envelope.set("payload", jsonValue);
            jsonValue = envelope;
        }
        Schema schema = this.asConnectSchema(jsonValue.get("schema"));
        return new SchemaAndValue(schema, JsonConverter.convertToConnect(schema, jsonValue.get("payload")));
    }

    public ObjectNode asJsonSchema(Schema schema) {
        ObjectNode jsonSchema;
        if (schema == null) {
            return null;
        }
        ObjectNode cached = this.fromConnectSchemaCache.get(schema);
        if (cached != null) {
            return cached;
        }
        switch (schema.type()) {
            case BOOLEAN: {
                jsonSchema = JsonSchema.BOOLEAN_SCHEMA.deepCopy();
                break;
            }
            case BYTES: {
                jsonSchema = JsonSchema.BYTES_SCHEMA.deepCopy();
                break;
            }
            case FLOAT64: {
                jsonSchema = JsonSchema.DOUBLE_SCHEMA.deepCopy();
                break;
            }
            case FLOAT32: {
                jsonSchema = JsonSchema.FLOAT_SCHEMA.deepCopy();
                break;
            }
            case INT8: {
                jsonSchema = JsonSchema.INT8_SCHEMA.deepCopy();
                break;
            }
            case INT16: {
                jsonSchema = JsonSchema.INT16_SCHEMA.deepCopy();
                break;
            }
            case INT32: {
                jsonSchema = JsonSchema.INT32_SCHEMA.deepCopy();
                break;
            }
            case INT64: {
                jsonSchema = JsonSchema.INT64_SCHEMA.deepCopy();
                break;
            }
            case STRING: {
                jsonSchema = JsonSchema.STRING_SCHEMA.deepCopy();
                break;
            }
            case ARRAY: {
                jsonSchema = JSON_NODE_FACTORY.objectNode().put("type", "array");
                jsonSchema.set("items", this.asJsonSchema(schema.valueSchema()));
                break;
            }
            case MAP: {
                jsonSchema = JSON_NODE_FACTORY.objectNode().put("type", "map");
                jsonSchema.set("keys", this.asJsonSchema(schema.keySchema()));
                jsonSchema.set("values", this.asJsonSchema(schema.valueSchema()));
                break;
            }
            case STRUCT: {
                jsonSchema = JSON_NODE_FACTORY.objectNode().put("type", "struct");
                ArrayNode fields = JSON_NODE_FACTORY.arrayNode();
                for (Field field : schema.fields()) {
                    ObjectNode fieldJsonSchema = this.asJsonSchema(field.schema()).deepCopy();
                    fieldJsonSchema.put("field", field.name());
                    fields.add(fieldJsonSchema);
                }
                jsonSchema.set("fields", fields);
                break;
            }
            default: {
                throw new DataException("Couldn't translate unsupported schema type " + schema + ".");
            }
        }
        jsonSchema.put("optional", schema.isOptional());
        if (schema.name() != null) {
            jsonSchema.put("name", schema.name());
        }
        if (schema.version() != null) {
            jsonSchema.put("version", schema.version());
        }
        if (schema.doc() != null) {
            jsonSchema.put("doc", schema.doc());
        }
        if (schema.parameters() != null) {
            ObjectNode jsonSchemaParams = JSON_NODE_FACTORY.objectNode();
            for (Map.Entry entry : schema.parameters().entrySet()) {
                jsonSchemaParams.put((String)entry.getKey(), (String)entry.getValue());
            }
            jsonSchema.set("parameters", jsonSchemaParams);
        }
        if (schema.defaultValue() != null) {
            jsonSchema.set("default", this.convertToJson(schema, schema.defaultValue()));
        }
        this.fromConnectSchemaCache.put(schema, jsonSchema);
        return jsonSchema;
    }

    public Schema asConnectSchema(JsonNode jsonSchema) {
        JsonNode schemaDefaultNode;
        JsonNode schemaParamsNode;
        JsonNode schemaDocNode;
        JsonNode schemaVersionNode;
        SchemaBuilder builder;
        if (jsonSchema.isNull()) {
            return null;
        }
        Schema cached = this.toConnectSchemaCache.get(jsonSchema);
        if (cached != null) {
            return cached;
        }
        JsonNode schemaTypeNode = jsonSchema.get("type");
        if (schemaTypeNode == null || !schemaTypeNode.isTextual()) {
            throw new DataException("Schema must contain 'type' field");
        }
        switch (schemaTypeNode.textValue()) {
            case "boolean": {
                builder = SchemaBuilder.bool();
                break;
            }
            case "int8": {
                builder = SchemaBuilder.int8();
                break;
            }
            case "int16": {
                builder = SchemaBuilder.int16();
                break;
            }
            case "int32": {
                builder = SchemaBuilder.int32();
                break;
            }
            case "int64": {
                builder = SchemaBuilder.int64();
                break;
            }
            case "float": {
                builder = SchemaBuilder.float32();
                break;
            }
            case "double": {
                builder = SchemaBuilder.float64();
                break;
            }
            case "bytes": {
                builder = SchemaBuilder.bytes();
                break;
            }
            case "string": {
                builder = SchemaBuilder.string();
                break;
            }
            case "array": {
                JsonNode elemSchema = jsonSchema.get("items");
                if (elemSchema == null || elemSchema.isNull()) {
                    throw new DataException("Array schema did not specify the element type");
                }
                builder = SchemaBuilder.array(this.asConnectSchema(elemSchema));
                break;
            }
            case "map": {
                JsonNode keySchema = jsonSchema.get("keys");
                if (keySchema == null) {
                    throw new DataException("Map schema did not specify the key type");
                }
                JsonNode valueSchema = jsonSchema.get("values");
                if (valueSchema == null) {
                    throw new DataException("Map schema did not specify the value type");
                }
                builder = SchemaBuilder.map(this.asConnectSchema(keySchema), this.asConnectSchema(valueSchema));
                break;
            }
            case "struct": {
                builder = SchemaBuilder.struct();
                JsonNode fields = jsonSchema.get("fields");
                if (fields == null || !fields.isArray()) {
                    throw new DataException("Struct schema's \"fields\" argument is not an array.");
                }
                for (JsonNode field : fields) {
                    JsonNode jsonFieldName = field.get("field");
                    if (jsonFieldName == null || !jsonFieldName.isTextual()) {
                        throw new DataException("Struct schema's field name not specified properly");
                    }
                    builder.field(jsonFieldName.asText(), this.asConnectSchema(field));
                }
                break;
            }
            default: {
                throw new DataException("Unknown schema type: " + schemaTypeNode.textValue());
            }
        }
        JsonNode schemaOptionalNode = jsonSchema.get("optional");
        if (schemaOptionalNode != null && schemaOptionalNode.isBoolean() && schemaOptionalNode.booleanValue()) {
            builder.optional();
        } else {
            builder.required();
        }
        JsonNode schemaNameNode = jsonSchema.get("name");
        if (schemaNameNode != null && schemaNameNode.isTextual()) {
            builder.name(schemaNameNode.textValue());
        }
        if ((schemaVersionNode = jsonSchema.get("version")) != null && schemaVersionNode.isIntegralNumber()) {
            builder.version(schemaVersionNode.intValue());
        }
        if ((schemaDocNode = jsonSchema.get("doc")) != null && schemaDocNode.isTextual()) {
            builder.doc(schemaDocNode.textValue());
        }
        if ((schemaParamsNode = jsonSchema.get("parameters")) != null && schemaParamsNode.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> paramsIt = schemaParamsNode.fields();
            while (paramsIt.hasNext()) {
                Map.Entry<String, JsonNode> entry = paramsIt.next();
                JsonNode paramValue = entry.getValue();
                if (!paramValue.isTextual()) {
                    throw new DataException("Schema parameters must have string values.");
                }
                builder.parameter(entry.getKey(), paramValue.textValue());
            }
        }
        if ((schemaDefaultNode = jsonSchema.get("default")) != null) {
            builder.defaultValue(JsonConverter.convertToConnect(builder, schemaDefaultNode));
        }
        Schema result = builder.build();
        this.toConnectSchemaCache.put(jsonSchema, result);
        return result;
    }

    private JsonNode convertToJsonWithEnvelope(Schema schema, Object value) {
        return new JsonSchema.Envelope(this.asJsonSchema(schema), this.convertToJson(schema, value)).toJsonNode();
    }

    private JsonNode convertToJsonWithoutEnvelope(Schema schema, Object value) {
        return this.convertToJson(schema, value);
    }

    /*
     * Unable to fully structure code
     */
    private JsonNode convertToJson(Schema schema, Object value) {
        if (value == null) {
            if (schema == null) {
                return null;
            }
            if (schema.defaultValue() != null) {
                return this.convertToJson(schema, schema.defaultValue());
            }
            if (schema.isOptional()) {
                return JsonConverter.JSON_NODE_FACTORY.nullNode();
            }
            throw new DataException("Conversion error: null value for field that is required and has no default value");
        }
        if (schema != null && schema.name() != null && (logicalConverter = JsonConverter.LOGICAL_CONVERTERS.get(schema.name())) != null) {
            return logicalConverter.toJson(schema, value, this.config);
        }
        try {
            if (schema == null) {
                schemaType = ConnectSchema.schemaType(value.getClass());
                if (schemaType == null) {
                    throw new DataException("Java class " + value.getClass() + " does not have corresponding schema type.");
                }
            } else {
                schemaType = schema.type();
            }
            switch (5.$SwitchMap$org$apache$kafka$connect$data$Schema$Type[schemaType.ordinal()]) {
                case 5: {
                    return JsonConverter.JSON_NODE_FACTORY.numberNode((Byte)value);
                }
                case 6: {
                    return JsonConverter.JSON_NODE_FACTORY.numberNode((Short)value);
                }
                case 7: {
                    return JsonConverter.JSON_NODE_FACTORY.numberNode((Integer)value);
                }
                case 8: {
                    return JsonConverter.JSON_NODE_FACTORY.numberNode((Long)value);
                }
                case 4: {
                    return JsonConverter.JSON_NODE_FACTORY.numberNode((Float)value);
                }
                case 3: {
                    return JsonConverter.JSON_NODE_FACTORY.numberNode((Double)value);
                }
                case 1: {
                    return JsonConverter.JSON_NODE_FACTORY.booleanNode((Boolean)value);
                }
                case 9: {
                    charSeq = (CharSequence)value;
                    return JsonConverter.JSON_NODE_FACTORY.textNode(charSeq.toString());
                }
                case 2: {
                    if (value instanceof byte[]) {
                        return JsonConverter.JSON_NODE_FACTORY.binaryNode((byte[])value);
                    }
                    if (value instanceof ByteBuffer) {
                        return JsonConverter.JSON_NODE_FACTORY.binaryNode(((ByteBuffer)value).array());
                    }
                    throw new DataException("Invalid type for bytes type: " + value.getClass());
                }
                case 10: {
                    collection = (Collection)value;
                    list = JsonConverter.JSON_NODE_FACTORY.arrayNode();
                    for (E elem : collection) {
                        valueSchema = schema == null ? null : schema.valueSchema();
                        fieldValue = this.convertToJson(valueSchema, elem);
                        list.add(fieldValue);
                    }
                    return list;
                }
                case 11: {
                    map = (Map)value;
                    if (schema != null) ** GOTO lbl61
                    objectMode = true;
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        if (entry.getKey() instanceof String) continue;
                        objectMode = false;
                        ** GOTO lbl62
                    }
                    ** GOTO lbl62
lbl61:
                    // 1 sources

                    objectMode = schema.keySchema().type() == Schema.Type.STRING;
lbl62:
                    // 3 sources

                    obj = null;
                    list = null;
                    if (objectMode) {
                        obj = JsonConverter.JSON_NODE_FACTORY.objectNode();
                    } else {
                        list = JsonConverter.JSON_NODE_FACTORY.arrayNode();
                    }
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        keySchema = schema == null ? null : schema.keySchema();
                        valueSchema = schema == null ? null : schema.valueSchema();
                        mapKey = this.convertToJson(keySchema, entry.getKey());
                        mapValue = this.convertToJson(valueSchema, entry.getValue());
                        if (objectMode) {
                            obj.set(mapKey.asText(), mapValue);
                            continue;
                        }
                        list.add(JsonConverter.JSON_NODE_FACTORY.arrayNode().add(mapKey).add(mapValue));
                    }
                    return objectMode != false ? obj : list;
                }
                case 12: {
                    struct = (Struct)value;
                    if (!struct.schema().equals(schema)) {
                        throw new DataException("Mismatching schema.");
                    }
                    obj = JsonConverter.JSON_NODE_FACTORY.objectNode();
                    for (Field field : schema.fields()) {
                        obj.set(field.name(), this.convertToJson(field.schema(), struct.get(field)));
                    }
                    return obj;
                }
            }
            throw new DataException("Couldn't convert " + value + " to JSON.");
        }
        catch (ClassCastException e) {
            schemaTypeStr = schema != null ? schema.type().toString() : "unknown schema";
            throw new DataException("Invalid type for " + schemaTypeStr + ": " + value.getClass());
        }
    }

    private static Object convertToConnect(Schema schema, JsonNode jsonValue) {
        LogicalTypeConverter logicalConverter;
        JsonToConnectTypeConverter typeConverter;
        Schema.Type schemaType;
        if (schema != null) {
            schemaType = schema.type();
            if (jsonValue == null || jsonValue.isNull()) {
                if (schema.defaultValue() != null) {
                    return schema.defaultValue();
                }
                if (schema.isOptional()) {
                    return null;
                }
                throw new DataException("Invalid null value for required " + (Object)((Object)schemaType) + " field");
            }
        } else {
            switch (jsonValue.getNodeType()) {
                case NULL: 
                case MISSING: {
                    return null;
                }
                case BOOLEAN: {
                    schemaType = Schema.Type.BOOLEAN;
                    break;
                }
                case NUMBER: {
                    if (jsonValue.isIntegralNumber()) {
                        schemaType = Schema.Type.INT64;
                        break;
                    }
                    schemaType = Schema.Type.FLOAT64;
                    break;
                }
                case ARRAY: {
                    schemaType = Schema.Type.ARRAY;
                    break;
                }
                case OBJECT: {
                    schemaType = Schema.Type.MAP;
                    break;
                }
                case STRING: {
                    schemaType = Schema.Type.STRING;
                    break;
                }
                default: {
                    schemaType = null;
                }
            }
        }
        if ((typeConverter = TO_CONNECT_CONVERTERS.get((Object)schemaType)) == null) {
            throw new DataException("Unknown schema type: " + (Object)((Object)schemaType));
        }
        if (schema != null && schema.name() != null && (logicalConverter = LOGICAL_CONVERTERS.get(schema.name())) != null) {
            return logicalConverter.toConnect(schema, jsonValue);
        }
        return typeConverter.convert(schema, jsonValue);
    }

    static {
        TO_CONNECT_CONVERTERS.put(Schema.Type.BOOLEAN, (schema, value) -> value.booleanValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT8, (schema, value) -> (byte)value.intValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT16, (schema, value) -> (short)value.intValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT32, (schema, value) -> value.intValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT64, (schema, value) -> value.longValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.FLOAT32, (schema, value) -> Float.valueOf(value.floatValue()));
        TO_CONNECT_CONVERTERS.put(Schema.Type.FLOAT64, (schema, value) -> value.doubleValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.BYTES, (schema, value) -> {
            try {
                return value.binaryValue();
            }
            catch (IOException e) {
                throw new DataException("Invalid bytes field", e);
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.STRING, (schema, value) -> value.textValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.ARRAY, (schema, value) -> {
            Schema elemSchema = schema == null ? null : schema.valueSchema();
            ArrayList<Object> result = new ArrayList<Object>();
            for (JsonNode elem : value) {
                result.add(JsonConverter.convertToConnect(elemSchema, elem));
            }
            return result;
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.MAP, (schema, value) -> {
            Schema keySchema = schema == null ? null : schema.keySchema();
            Schema valueSchema = schema == null ? null : schema.valueSchema();
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            if (schema == null || keySchema.type() == Schema.Type.STRING) {
                if (!value.isObject()) {
                    throw new DataException("Maps with string fields should be encoded as JSON objects, but found " + (Object)((Object)value.getNodeType()));
                }
                Iterator<Map.Entry<String, JsonNode>> fieldIt = value.fields();
                while (fieldIt.hasNext()) {
                    Map.Entry<String, JsonNode> entry = fieldIt.next();
                    result.put(entry.getKey(), JsonConverter.convertToConnect(valueSchema, entry.getValue()));
                }
            } else {
                if (!value.isArray()) {
                    throw new DataException("Maps with non-string fields should be encoded as JSON array of tuples, but found " + (Object)((Object)value.getNodeType()));
                }
                for (JsonNode entry : value) {
                    if (!entry.isArray()) {
                        throw new DataException("Found invalid map entry instead of array tuple: " + (Object)((Object)entry.getNodeType()));
                    }
                    if (entry.size() != 2) {
                        throw new DataException("Found invalid map entry, expected length 2 but found :" + entry.size());
                    }
                    result.put(JsonConverter.convertToConnect(keySchema, entry.get(0)), JsonConverter.convertToConnect(valueSchema, entry.get(1)));
                }
            }
            return result;
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.STRUCT, (schema, value) -> {
            if (!value.isObject()) {
                throw new DataException("Structs should be encoded as JSON objects, but found " + (Object)((Object)value.getNodeType()));
            }
            Struct result = new Struct(schema.schema());
            for (Field field : schema.fields()) {
                result.put(field, JsonConverter.convertToConnect(field.schema(), value.get(field.name())));
            }
            return result;
        });
        LOGICAL_CONVERTERS = new HashMap();
        JSON_NODE_FACTORY = JsonNodeFactory.withExactBigDecimals(true);
        LOGICAL_CONVERTERS.put("com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Decimal", new LogicalTypeConverter(){

            @Override
            public JsonNode toJson(Schema schema, Object value, JsonConverterConfig config) {
                if (!(value instanceof BigDecimal)) {
                    throw new DataException("Invalid type for Decimal, expected BigDecimal but was " + value.getClass());
                }
                BigDecimal decimal = (BigDecimal)value;
                switch (config.decimalFormat()) {
                    case NUMERIC: {
                        return JSON_NODE_FACTORY.numberNode(decimal);
                    }
                    case BASE64: {
                        return JSON_NODE_FACTORY.binaryNode(Decimal.fromLogical(schema, decimal));
                    }
                }
                throw new DataException("Unexpected decimal.format: " + (Object)((Object)config.decimalFormat()));
            }

            @Override
            public Object toConnect(Schema schema, JsonNode value) {
                if (value.isNumber()) {
                    return value.decimalValue();
                }
                if (value.isBinary() || value.isTextual()) {
                    try {
                        return Decimal.toLogical(schema, value.binaryValue());
                    }
                    catch (Exception e) {
                        throw new DataException("Invalid bytes for Decimal field", e);
                    }
                }
                throw new DataException("Invalid type for Decimal, underlying representation should be numeric or bytes but was " + (Object)((Object)value.getNodeType()));
            }
        });
        LOGICAL_CONVERTERS.put("com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Date", new LogicalTypeConverter(){

            @Override
            public JsonNode toJson(Schema schema, Object value, JsonConverterConfig config) {
                if (!(value instanceof java.util.Date)) {
                    throw new DataException("Invalid type for Date, expected Date but was " + value.getClass());
                }
                return JSON_NODE_FACTORY.numberNode(Date.fromLogical(schema, (java.util.Date)value));
            }

            @Override
            public Object toConnect(Schema schema, JsonNode value) {
                if (!value.isInt()) {
                    throw new DataException("Invalid type for Date, underlying representation should be integer but was " + (Object)((Object)value.getNodeType()));
                }
                return Date.toLogical(schema, value.intValue());
            }
        });
        LOGICAL_CONVERTERS.put("com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Time", new LogicalTypeConverter(){

            @Override
            public JsonNode toJson(Schema schema, Object value, JsonConverterConfig config) {
                if (!(value instanceof java.util.Date)) {
                    throw new DataException("Invalid type for Time, expected Date but was " + value.getClass());
                }
                return JSON_NODE_FACTORY.numberNode(Time.fromLogical(schema, (java.util.Date)value));
            }

            @Override
            public Object toConnect(Schema schema, JsonNode value) {
                if (!value.isInt()) {
                    throw new DataException("Invalid type for Time, underlying representation should be integer but was " + (Object)((Object)value.getNodeType()));
                }
                return Time.toLogical(schema, value.intValue());
            }
        });
        LOGICAL_CONVERTERS.put("com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Timestamp", new LogicalTypeConverter(){

            @Override
            public JsonNode toJson(Schema schema, Object value, JsonConverterConfig config) {
                if (!(value instanceof java.util.Date)) {
                    throw new DataException("Invalid type for Timestamp, expected Date but was " + value.getClass());
                }
                return JSON_NODE_FACTORY.numberNode(Timestamp.fromLogical(schema, (java.util.Date)value));
            }

            @Override
            public Object toConnect(Schema schema, JsonNode value) {
                if (!value.isIntegralNumber()) {
                    throw new DataException("Invalid type for Timestamp, underlying representation should be integral but was " + (Object)((Object)value.getNodeType()));
                }
                return Timestamp.toLogical(schema, value.longValue());
            }
        });
    }

    private static interface LogicalTypeConverter {
        public JsonNode toJson(Schema var1, Object var2, JsonConverterConfig var3);

        public Object toConnect(Schema var1, JsonNode var2);
    }

    private static interface JsonToConnectTypeConverter {
        public Object convert(Schema var1, JsonNode var2);
    }
}

