/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl.AccessControlEntry;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl.AclBinding;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl.AclOperation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl.AclPermissionType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.DeleteAclsResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.ApiError;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.resource.PatternType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.resource.ResourcePattern;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.resource.ResourceType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.server.authorizer.AclDeleteResult;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAclsResponse
extends AbstractResponse {
    public static final Logger log = LoggerFactory.getLogger(DeleteAclsResponse.class);
    private final DeleteAclsResponseData data;

    public DeleteAclsResponse(DeleteAclsResponseData data, short version) {
        super(ApiKeys.DELETE_ACLS);
        this.data = data;
        this.validate(version);
    }

    @Override
    public DeleteAclsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public List<DeleteAclsResponseData.DeleteAclsFilterResult> filterResults() {
        return this.data.filterResults();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.filterResults().stream().map(r -> Errors.forCode(r.errorCode())));
    }

    public static DeleteAclsResponse parse(ByteBuffer buffer, short version) {
        return new DeleteAclsResponse(new DeleteAclsResponseData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    private void validate(short version) {
        boolean unsupported;
        if (version == 0 && (unsupported = this.filterResults().stream().flatMap(r -> r.matchingAcls().stream()).anyMatch(matchingAcl -> matchingAcl.patternType() != PatternType.LITERAL.code()))) {
            throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
        }
        boolean unknown = this.filterResults().stream().flatMap(r -> r.matchingAcls().stream()).anyMatch(matchingAcl -> matchingAcl.patternType() == PatternType.UNKNOWN.code() || matchingAcl.resourceType() == ResourceType.UNKNOWN.code() || matchingAcl.permissionType() == AclPermissionType.UNKNOWN.code() || matchingAcl.operation() == AclOperation.UNKNOWN.code());
        if (unknown) {
            throw new IllegalArgumentException("DeleteAclsMatchingAcls contain UNKNOWN elements");
        }
    }

    public static DeleteAclsResponseData.DeleteAclsFilterResult filterResult(AclDeleteResult result) {
        ApiError error = result.exception().map(e -> ApiError.fromThrowable(e)).orElse(ApiError.NONE);
        List<DeleteAclsResponseData.DeleteAclsMatchingAcl> matchingAcls = result.aclBindingDeleteResults().stream().map(DeleteAclsResponse::matchingAcl).collect(Collectors.toList());
        return new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(error.error().code()).setErrorMessage(error.message()).setMatchingAcls(matchingAcls);
    }

    private static DeleteAclsResponseData.DeleteAclsMatchingAcl matchingAcl(AclDeleteResult.AclBindingDeleteResult result) {
        ApiError error = result.exception().map(e -> ApiError.fromThrowable(e)).orElse(ApiError.NONE);
        AclBinding acl = result.aclBinding();
        return DeleteAclsResponse.matchingAcl(acl, error);
    }

    public static DeleteAclsResponseData.DeleteAclsMatchingAcl matchingAcl(AclBinding acl, ApiError error) {
        return new DeleteAclsResponseData.DeleteAclsMatchingAcl().setErrorCode(error.error().code()).setErrorMessage(error.message()).setResourceName(acl.pattern().name()).setResourceType(acl.pattern().resourceType().code()).setPatternType(acl.pattern().patternType().code()).setHost(acl.entry().host()).setOperation(acl.entry().operation().code()).setPermissionType(acl.entry().permissionType().code()).setPrincipal(acl.entry().principal());
    }

    public static AclBinding aclBinding(DeleteAclsResponseData.DeleteAclsMatchingAcl matchingAcl) {
        ResourcePattern resourcePattern = new ResourcePattern(ResourceType.fromCode(matchingAcl.resourceType()), matchingAcl.resourceName(), PatternType.fromCode(matchingAcl.patternType()));
        AccessControlEntry accessControlEntry = new AccessControlEntry(matchingAcl.principal(), matchingAcl.host(), AclOperation.fromCode(matchingAcl.operation()), AclPermissionType.fromCode(matchingAcl.permissionType()));
        return new AclBinding(resourcePattern, accessControlEntry);
    }
}

