/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.InvalidRecordException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Type;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ControlRecordType {
    ABORT(0),
    COMMIT(1),
    LEADER_CHANGE(2),
    SNAPSHOT_HEADER(3),
    SNAPSHOT_FOOTER(4),
    UNKNOWN(-1);

    private static final Logger log;
    static final short CURRENT_CONTROL_RECORD_KEY_VERSION = 0;
    static final int CURRENT_CONTROL_RECORD_KEY_SIZE = 4;
    private static final Schema CONTROL_RECORD_KEY_SCHEMA_VERSION_V0;
    final short type;

    private ControlRecordType(short type) {
        this.type = type;
    }

    public Struct recordKey() {
        if (this == UNKNOWN) {
            throw new IllegalArgumentException("Cannot serialize UNKNOWN control record type");
        }
        Struct struct = new Struct(CONTROL_RECORD_KEY_SCHEMA_VERSION_V0);
        struct.set("version", (Object)0);
        struct.set("type", (Object)this.type);
        return struct;
    }

    public static short parseTypeId(ByteBuffer key) {
        if (key.remaining() < 4) {
            throw new InvalidRecordException("Invalid value size found for end control record key. Must have at least 4 bytes, but found only " + key.remaining());
        }
        short version = key.getShort(0);
        if (version < 0) {
            throw new InvalidRecordException("Invalid version found for control record: " + version + ". May indicate data corruption");
        }
        if (version != 0) {
            log.debug("Received unknown control record key version {}. Parsing as version {}", (Object)version, (Object)0);
        }
        return key.getShort(2);
    }

    public static ControlRecordType fromTypeId(short typeId) {
        switch (typeId) {
            case 0: {
                return ABORT;
            }
            case 1: {
                return COMMIT;
            }
            case 2: {
                return LEADER_CHANGE;
            }
            case 3: {
                return SNAPSHOT_HEADER;
            }
            case 4: {
                return SNAPSHOT_FOOTER;
            }
        }
        return UNKNOWN;
    }

    public static ControlRecordType parse(ByteBuffer key) {
        return ControlRecordType.fromTypeId(ControlRecordType.parseTypeId(key));
    }

    static {
        log = LoggerFactory.getLogger(ControlRecordType.class);
        CONTROL_RECORD_KEY_SCHEMA_VERSION_V0 = new Schema(new Field("version", Type.INT16), new Field("type", Type.INT16));
    }
}

