/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.split;

import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.utils.SerializerUtils;
import io.debezium.relational.TableId;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.util.FlinkRuntimeException;

public class FinishedSnapshotSplitInfo {
    private static final ThreadLocal<DataOutputSerializer> SERIALIZER_CACHE = ThreadLocal.withInitial(() -> new DataOutputSerializer(64));
    private final TableId tableId;
    private final String splitId;
    private final Object[] splitStart;
    private final Object[] splitEnd;
    private final BinlogOffset highWatermark;

    public FinishedSnapshotSplitInfo(TableId tableId, String splitId, Object[] splitStart, Object[] splitEnd, BinlogOffset highWatermark) {
        this.tableId = tableId;
        this.splitId = splitId;
        this.splitStart = splitStart;
        this.splitEnd = splitEnd;
        this.highWatermark = highWatermark;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public String getSplitId() {
        return this.splitId;
    }

    public Object[] getSplitStart() {
        return this.splitStart;
    }

    public Object[] getSplitEnd() {
        return this.splitEnd;
    }

    public BinlogOffset getHighWatermark() {
        return this.highWatermark;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinishedSnapshotSplitInfo that = (FinishedSnapshotSplitInfo)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.splitId, that.splitId) && Arrays.equals(this.splitStart, that.splitStart) && Arrays.equals(this.splitEnd, that.splitEnd) && Objects.equals(this.highWatermark, that.highWatermark);
    }

    public int hashCode() {
        int result = Objects.hash(this.tableId, this.splitId, this.highWatermark);
        result = 31 * result + Arrays.hashCode(this.splitStart);
        result = 31 * result + Arrays.hashCode(this.splitEnd);
        return result;
    }

    public String toString() {
        return "FinishedSnapshotSplitInfo{tableId=" + this.tableId + ", splitId='" + this.splitId + '\'' + ", splitStart=" + Arrays.toString(this.splitStart) + ", splitEnd=" + Arrays.toString(this.splitEnd) + ", highWatermark=" + this.highWatermark + '}';
    }

    public static byte[] serialize(FinishedSnapshotSplitInfo splitInfo) {
        try {
            DataOutputSerializer out = SERIALIZER_CACHE.get();
            out.writeUTF(splitInfo.getTableId().toString());
            out.writeUTF(splitInfo.getSplitId());
            out.writeUTF(SerializerUtils.rowToSerializedString(splitInfo.getSplitStart()));
            out.writeUTF(SerializerUtils.rowToSerializedString(splitInfo.getSplitEnd()));
            SerializerUtils.writeBinlogPosition(splitInfo.getHighWatermark(), out);
            byte[] result = out.getCopyOfBuffer();
            out.clear();
            return result;
        }
        catch (IOException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public static FinishedSnapshotSplitInfo deserialize(byte[] serialized) {
        try {
            DataInputDeserializer in = new DataInputDeserializer(serialized);
            TableId tableId = TableId.parse(in.readUTF());
            String splitId = in.readUTF();
            Object[] splitStart = SerializerUtils.serializedStringToRow(in.readUTF());
            Object[] splitEnd = SerializerUtils.serializedStringToRow(in.readUTF());
            BinlogOffset highWatermark = SerializerUtils.readBinlogPosition(in);
            in.releaseArrays();
            return new FinishedSnapshotSplitInfo(tableId, splitId, splitStart, splitEnd, highWatermark);
        }
        catch (IOException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }
}

