/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnectionPropertyKey;
import com.vertica.core.VConnectionPropertyValue;
import com.vertica.core.VDriver;
import com.vertica.jdbc.VJDBCObjectFactory;
import com.vertica.jdbc.common.AbstractDataSource;
import com.vertica.jdbc.common.AbstractDriver;
import com.vertica.jdbc.common.JDBCObjectFactory;
import com.vertica.jdbc.common.utilities.WrapperUtilities;
import com.vertica.jdbc.hybrid.HybridAbstractDataSource;
import com.vertica.security.TLSMode;
import com.vertica.support.LogLevel;
import com.vertica.util.Versions;
import com.vertica.utilities.JDBCVersion;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class DataSource
extends HybridAbstractDataSource
implements javax.sql.DataSource {
    private Map<String, String> m_properties = new HashMap<String, String>();

    public boolean areBatchInsertsDirect() {
        String string = this.m_properties.get("directbatchinsert");
        if (null == string) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public String getDatabase() {
        return this.m_properties.get("database");
    }

    public String getHost() {
        return this.m_properties.get("host");
    }

    public String getLocale() {
        return this.m_properties.get("locale");
    }

    public String getSessionTimezone() {
        String string = this.m_properties.get("sessiontimezone");
        return string == null ? "" : string;
    }

    @Override
    public int getLoginTimeout() {
        String string = this.m_properties.get("logintimeout");
        if (null == string) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    public int getLoginNetworkTimeout() {
        String string = this.m_properties.get("loginnetworktimeout");
        if (null == string) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    public int getLoginNodeTimeout() {
        String string = this.m_properties.get("loginnodetimeout");
        if (null == string) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    public String getSocketFactoryName() {
        String string = this.m_properties.get("socketfactoryname");
        if (null == string) {
            return "";
        }
        return string;
    }

    public String getSSLSocketFactoryName() {
        String string = this.m_properties.get("sslsocketfactoryname");
        if (null == string) {
            return "";
        }
        return string;
    }

    public long getResultBufferSize() {
        String string = this.m_properties.get("resultbuffersize");
        if (null == string) {
            return 8192L;
        }
        return Long.valueOf(string);
    }

    public short getPort() {
        String string = this.m_properties.get("port");
        if (null == string) {
            return 5433;
        }
        return Short.valueOf(string);
    }

    public int getPortInt() {
        String string = this.m_properties.get("port");
        if (null == string) {
            return 5433;
        }
        return Integer.valueOf(string);
    }

    public boolean isReadOnly() {
        String string = this.m_properties.get("readonly");
        if (null == string) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public String getSearchPath() {
        String string = this.m_properties.get("searchpath");
        if (null == string) {
            return "";
        }
        return string;
    }

    public String getSessionLabel() {
        return this.m_properties.get("sessionlabel");
    }

    public int getTransactionIsolation() {
        String string = this.m_properties.get("transactionisolation");
        if (null == string) {
            return 2;
        }
        return Integer.valueOf(string);
    }

    public boolean isAutoCommitOnByDefault() {
        String string = this.m_properties.get("autocommit");
        if (null == string) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }

    public boolean isSslEnabled() {
        return TLSMode.fromString(this.getTLSMode()).requiresEncryption();
    }

    public String getTLSMode() {
        String string = this.m_properties.get("tlsmode");
        if (string != null) {
            return TLSMode.fromString(string).toString();
        }
        String string2 = this.m_properties.get("ssl");
        if (string2 != null) {
            return (Boolean.parseBoolean(string2) ? TLSMode.VERIFY_CA : TLSMode.DISABLE).toString();
        }
        return VConnectionPropertyValue.DEFAULT_TLSMODE.toString();
    }

    public String getHostNameVerifier() {
        return this.m_properties.get("hostnameverifier");
    }

    public boolean useConnectionLoadBalance() {
        String string = this.m_properties.get("connectionloadbalance");
        if (null == string) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public String getBackupServerNode() {
        return this.m_properties.get("backupservernode");
    }

    public String getUser() {
        return this.m_properties.get("user");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("java.util.logging not used");
    }

    public void setAutoCommitOnByDefault(boolean bl) {
        this.m_properties.put("autocommit", String.valueOf(bl));
    }

    @Deprecated
    public void setBatchInsertsDirect(boolean bl) {
        this.m_properties.put("directbatchinsert", String.valueOf(bl));
    }

    public void setDatabase(String string) {
        this.m_properties.put("database", string);
    }

    public void setHost(String string) {
        this.m_properties.put("host", string);
    }

    public void setLocale(String string) {
        this.m_properties.put("locale", string);
    }

    public void setSessionTimezone(String string) {
        this.m_properties.put("sessiontimezone", string);
    }

    @Override
    public void setLoginTimeout(int n) {
        this.m_properties.put("logintimeout", String.valueOf(n));
    }

    public void setLoginNetworkTimeout(int n) {
        this.m_properties.put("loginnetworktimeout", String.valueOf(n));
    }

    public void setLoginNodeTimeout(int n) {
        this.m_properties.put("loginnodetimeout", String.valueOf(n));
    }

    public void setSSLSocketFactoryName(String string) {
        if (string == null) {
            string = "";
        }
        this.m_properties.put("sslsocketfactoryname", string);
    }

    public void setSocketFactoryName(String string) {
        if (string == null) {
            string = "";
        }
        this.m_properties.put("socketfactoryname", string);
    }

    public void setResultBufferSize(long l) {
        this.m_properties.put("resultbuffersize", String.valueOf(l));
    }

    public void setPort(int n) {
        this.m_properties.put("port", String.valueOf(n));
    }

    public void setPort(short s) {
        this.m_properties.put("port", String.valueOf(s));
    }

    public void setReadOnly(boolean bl) {
        this.m_properties.put("readonly", String.valueOf(bl));
    }

    public void setSessionLabel(String string) {
        this.m_properties.put("sessionlabel", string);
    }

    public void setSslEnabled(boolean bl) {
        this.m_properties.put("ssl", String.valueOf(bl));
    }

    public void setTLSMode(String string) {
        TLSMode tLSMode = TLSMode.fromString(string);
        this.m_properties.put("tlsmode", tLSMode.toString());
    }

    public void setHostNameVerifier(String string) {
        this.m_properties.put("hostnameverifier", string);
    }

    public void setThreePartNaming(boolean bl) {
        this.m_properties.put("threepartnaming", String.valueOf(bl));
    }

    public void setSearchPath(String string) {
        this.m_properties.put("searchpath", string);
    }

    public void setBackupServerNode(String string) {
        this.m_properties.put("backupservernode", string);
    }

    public void setUser(String string) {
        this.m_properties.put("user", string);
    }

    public void setConnectionLoadBalance(boolean bl) {
        this.m_properties.put("connectionloadbalance", String.valueOf(bl));
    }

    public boolean useThreePartNaming() {
        String string = this.m_properties.get("threepartnaming");
        if (null == string) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }

    public String getJAASConfigName() {
        String string = this.m_properties.get("jaasconfigname");
        if (null == string) {
            return "verticajdbc";
        }
        return string;
    }

    public void setJAASConfigName(String string) {
        this.m_properties.put("jaasconfigname", string);
    }

    public String getKerberosServiceName() {
        String string = this.m_properties.get("kerberosservicename");
        if (null == string) {
            return "vertica";
        }
        return string;
    }

    public void setKerberosServiceName(String string) {
        this.m_properties.put("kerberosservicename", string);
    }

    public String getKerberosHostName() {
        String string = this.m_properties.get("kerberoshostname");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setKerberosHostName(String string) {
        this.m_properties.put("kerberoshostname", string);
    }

    public String getOAuthAccessToken() {
        String string = this.m_properties.get("oauthaccesstoken");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setOAuthAccessToken(String string) {
        this.m_properties.put("oauthaccesstoken", string);
    }

    public String getAuthMethod() {
        String string = this.m_properties.get("authmethod");
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setAuthMethod(String string) {
        this.m_properties.put("authmethod", string);
    }

    public String getOAuthRefreshToken() {
        String string = this.m_properties.get("oauthrefreshtoken");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setOAuthRefreshToken(String string) {
        this.m_properties.put("oauthrefreshtoken", string);
    }

    public String getOAuthTokenUrl() {
        String string = this.m_properties.get("oauthtokenurl");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setOAuthTokenUrl(String string) {
        this.m_properties.put("oauthtokenurl", string);
    }

    public String getOAuthClientId() {
        String string = this.m_properties.get("oauthclientid");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setOAuthClientId(String string) {
        this.m_properties.put("oauthclientid", string);
    }

    public String getOAuthClientSecret() {
        String string = this.m_properties.get("oauthclientsecret");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setOAuthClientSecret(String string) {
        this.m_properties.put("oauthclientsecret", string);
    }

    public String getOAuthDiscoveryUrl() {
        String string = this.m_properties.get("oauthdiscoveryurl");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setOAuthDiscoveryUrl(String string) {
        this.m_properties.put("oauthdiscoveryurl", string);
    }

    public String getOAuthScope() {
        String string = this.m_properties.get("oauthscope");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setOAuthScope(String string) {
        this.m_properties.put("oauthscope", string);
    }

    public boolean getStreamingBatchInsert() {
        String string = this.m_properties.get("streamingbatchinsert");
        if (string == null) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public void setStreamingBatchInsert(boolean bl) {
        this.m_properties.put("streamingbatchinsert", String.valueOf(bl));
    }

    public boolean getDisableCopyLocal() {
        String string = this.m_properties.get("disablecopylocal");
        if (string == null) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public void setDisableCopyLocal(boolean bl) {
        this.m_properties.put("disablecopylocal", String.valueOf(bl));
    }

    public boolean getBinaryTransfer() {
        String string = this.m_properties.get("binarytransfer");
        if (string == null) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }

    public void setBinaryTransfer(boolean bl) {
        this.m_properties.put("binarytransfer", String.valueOf(bl));
    }

    public boolean getRequestComplexTypes() {
        String string = this.m_properties.get("requestcomplextypes");
        if (string == null) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }

    public void setRequestComplexTypes(boolean bl) {
        this.m_properties.put("requestcomplextypes", String.valueOf(bl));
    }

    public String getWorkload() {
        String string = this.m_properties.get("workload");
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setWorkload(String string) {
        this.m_properties.put("workload", string);
    }

    public boolean getOAuthBackwardCompatibility() {
        String string = this.m_properties.get("oauthbackwardcompatibility");
        if (string == null) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public void setOAuthBackwardCompatibility(boolean bl) {
        this.m_properties.put("oauthbackwardcompatibility", String.valueOf(bl));
    }

    public void setConnSettings(String string) {
        this.m_properties.put("connsettings", string);
    }

    public String getConnSettings() {
        String string = this.m_properties.get("connsettings");
        if (null == string) {
            return "";
        }
        return string;
    }

    @Deprecated
    public boolean getEnableRoutableQueries() {
        String string = this.m_properties.get("enableroutablequeries");
        if (null == string) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    @Deprecated
    public void setEnableRoutableQueries(boolean bl) {
        this.m_properties.put("enableroutablequeries", String.valueOf(bl));
    }

    @Deprecated
    public boolean getFailOnMultiNodePlans() {
        String string = this.m_properties.get("failonmultinodeplans");
        if (null == string) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }

    @Deprecated
    public void setFailOnMultiNodePlans(boolean bl) {
        this.m_properties.put("failonmultinodeplans", String.valueOf(bl));
    }

    @Deprecated
    public void setMaxPooledConnectionUses(int n) {
        this.m_properties.put("maxpooledconnectionuses", String.valueOf(n));
    }

    @Deprecated
    public int getMaxPooledConnectionUses() {
        String string = this.m_properties.get("maxpooledconnectionuses");
        if (null == string) {
            return 1000;
        }
        return Integer.valueOf(string);
    }

    @Deprecated
    public void setMaxPooledConnections(int n) {
        this.m_properties.put("maxpooledconnections", String.valueOf(n));
    }

    @Deprecated
    public int getMaxPooledConnections() {
        String string = this.m_properties.get("maxpooledconnections");
        if (null == string) {
            return 20;
        }
        return Integer.valueOf(string);
    }

    @Deprecated
    public void setMaxPooledConnectionsPerNode(int n) {
        this.m_properties.put("maxpooledconnectionspernode", String.valueOf(n));
    }

    @Deprecated
    public int getMaxPooledConnectionsPerNode() {
        String string = this.m_properties.get("maxpooledconnectionspernode");
        if (null == string) {
            return 5;
        }
        return Integer.valueOf(string);
    }

    @Deprecated
    public int getMetadataCacheLifetime() {
        String string = this.m_properties.get("metadatacachelifetime");
        if (null == string) {
            return 300;
        }
        return Integer.valueOf(string);
    }

    @Deprecated
    public void setMetadataCacheLifetime(int n) {
        this.m_properties.put("metadatacachelifetime", String.valueOf(n));
    }

    @Deprecated
    public int getNodeDownWaitTime() {
        String string = this.m_properties.get("nodedownwaittime");
        if (null == string) {
            return 60;
        }
        return Integer.valueOf(string);
    }

    @Deprecated
    public void setNodeDownWaitTime(int n) {
        this.m_properties.put("nodedownwaittime", String.valueOf(n));
    }

    public void setPreferredAddressFamily(String string) {
        this.m_properties.put("preferredaddressfamily", string);
    }

    public String getPreferredAddressFamily() {
        String string = this.m_properties.get("preferredaddressfamily");
        if (null == string) {
            return VConnectionPropertyValue.DEFAULT_PREFERRED_ADDRESS_FAMILY.toString();
        }
        return string;
    }

    public void setMarsEnabled(boolean bl) {
        this.m_properties.put("mars", String.valueOf(bl));
    }

    public boolean getMarsEnabled() {
        String string = this.m_properties.get("mars");
        if (null == string) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public String getLogNameSpace() {
        String string = this.m_properties.get("lognamespace");
        if (null == string) {
            return "com.vertica".toString();
        }
        return string;
    }

    public void setNetworkTimeout(int n) {
        this.m_properties.put("networktimeout", String.valueOf(n));
    }

    public int getNetworkTimeout() {
        String string = this.m_properties.get("networktimeout");
        if (null == string) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    public void setLogNameSpace(String string) {
        this.m_properties.put("lognamespace", string);
    }

    @Override
    public void setLogLevel(String string) {
        super.setLogLevel(string);
        this.m_properties.put("loglevel", string);
    }

    @Override
    public LogLevel getLogLevel() {
        String string = this.m_properties.get("loglevel");
        if (null == string) {
            return VConnectionPropertyValue.DEFAULT_LOG_LEVEL;
        }
        return LogLevel.getLogLevel(string);
    }

    @Override
    public void setLogDirectory(String string) {
        super.setLogDirectory(string);
        this.m_properties.put("logpath", string);
    }

    @Override
    public String getLogDirectory() {
        String string = this.m_properties.get("logpath");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setKeyStorePath(String string) {
        this.m_properties.put("keystorepath", string);
    }

    public String getKeyStorePath() {
        String string = this.m_properties.get("keystorepath");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setTrustStorePath(String string) {
        this.m_properties.put("truststorepath", string);
    }

    public String getTrustStorePath() {
        String string = this.m_properties.get("truststorepath");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setTrustStorePassword(String string) {
        this.m_properties.put("truststorepassword", string);
    }

    public String getTrustStorePassword() {
        String string = this.m_properties.get("truststorepassword");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setKeyStorePassword(String string) {
        this.m_properties.put("keystorepassword", string);
    }

    public String getKeyStorePassword() {
        String string = this.m_properties.get("keystorepassword");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setOAuthTrustStorePath(String string) {
        this.m_properties.put("oauthtruststorepath", string);
    }

    public String getOAuthTrustStorePath() {
        String string = this.m_properties.get("oauthtruststorepath");
        if (null == string) {
            return "";
        }
        return string;
    }

    public void setOAuthTrustStorePassword(String string) {
        this.m_properties.put("oauthtruststorepassword", string);
    }

    public String getOAuthTrustStorePassword() {
        String string = this.m_properties.get("oauthtruststorepassword");
        if (null == string) {
            return "";
        }
        return string;
    }

    @Override
    protected JDBCObjectFactory createJDBCObjectFactory() {
        return new VJDBCObjectFactory(this.runningJDBCVersion());
    }

    @Override
    protected Properties getProperties() {
        Properties properties = super.getProperties();
        for (Map.Entry<String, String> entry : this.m_properties.entrySet()) {
            if (null == entry.getValue()) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    @Override
    protected String getSubProtocol() {
        return "vertica";
    }

    @Override
    protected boolean parseSubName(String string, Properties properties) {
        return VConnectionPropertyKey.parseSubName(string, properties);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    protected JDBCVersion runningJDBCVersion() {
        return Versions.getJDBCVersion();
    }

    static {
        AbstractDataSource.initialize(VDriver.class.getName());
        AbstractDriver.setErrorMessageComponentName("Vertica");
    }
}

