/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import java.io.UnsupportedEncodingException;

public class ProtocolUtils {
    public static final ProtocolVersion CURRENT_PROTOCOL_VERSION = ProtocolVersion.PROTOCOL_VERSION_3_16;

    public static int protocolStrToInt(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            return Integer.parseInt(stringArray[0]);
        }
        return Integer.parseInt(stringArray[0]) << 16 | Integer.parseInt(stringArray[1]);
    }

    public static byte[] encodeUTF8(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unexpected exception: UTF-8 charset not supported: " + unsupportedEncodingException);
        }
    }

    public static enum ProtocolVersion {
        PROTOCOL_VERSION_3_5("3.5", ProtocolUtils.protocolStrToInt("3.5")),
        PROTOCOL_VERSION_3_6("3.6", ProtocolUtils.protocolStrToInt("3.6")),
        PROTOCOL_VERSION_3_7("3.7", ProtocolUtils.protocolStrToInt("3.7")),
        PROTOCOL_VERSION_3_8("3.8", ProtocolUtils.protocolStrToInt("3.8")),
        PROTOCOL_VERSION_3_9("3.9", ProtocolUtils.protocolStrToInt("3.9")),
        PROTOCOL_VERSION_3_10("3.10", ProtocolUtils.protocolStrToInt("3.10")),
        PROTOCOL_VERSION_3_11("3.11", ProtocolUtils.protocolStrToInt("3.11")),
        PROTOCOL_VERSION_3_12("3.12", ProtocolUtils.protocolStrToInt("3.12")),
        PROTOCOL_VERSION_3_13("3.13", ProtocolUtils.protocolStrToInt("3.13")),
        PROTOCOL_VERSION_3_14("3.14", ProtocolUtils.protocolStrToInt("3.14")),
        PROTOCOL_VERSION_3_15("3.15", ProtocolUtils.protocolStrToInt("3.15")),
        PROTOCOL_VERSION_3_16("3.16", ProtocolUtils.protocolStrToInt("3.16"));

        private final String versionAsString;
        private final int versionAsInt;

        private ProtocolVersion(String string2, int n2) {
            this.versionAsString = string2;
            this.versionAsInt = n2;
        }

        public String stringValue() {
            return this.versionAsString;
        }

        public int intValue() {
            return this.versionAsInt;
        }

        public static ProtocolVersion fromInt(int n) {
            for (ProtocolVersion protocolVersion : ProtocolVersion.values()) {
                if (protocolVersion.versionAsInt != n) continue;
                return protocolVersion;
            }
            throw new IllegalArgumentException("No ProtocolVersion with int value: " + n);
        }

        public static ProtocolVersion fromString(String string) {
            int n = ProtocolUtils.protocolStrToInt(string);
            try {
                return ProtocolVersion.fromInt(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("No ProtocolVersion with string value: " + string);
            }
        }

        public short Major() {
            return (short)(this.versionAsInt >> 16);
        }

        public short Minor() {
            return (short)(this.versionAsInt & 0xFFFF);
        }

        public boolean isAtLeast(ProtocolVersion protocolVersion) {
            return this.versionAsInt >= protocolVersion.intValue();
        }
    }
}

