/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.conv;

import com.vertica.support.conv.ConversionResult;
import com.vertica.support.conv.ConverterConstants;
import com.vertica.support.conv.DateTimeConverter;
import com.vertica.support.conv.ExactNumConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.UUID;
import java.util.regex.Matcher;

public class CharConverter {
    private CharConverter() {
    }

    public static boolean toBoolean(String from, ConversionResult result) {
        if ("true".equalsIgnoreCase(from = from.trim())) {
            result.setState(ConversionResult.TypeConversionState.SUCCESS);
            return true;
        }
        if ("false".equalsIgnoreCase(from)) {
            result.setState(ConversionResult.TypeConversionState.SUCCESS);
            return false;
        }
        result.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
        return false;
    }

    public static BigInteger toBigInt(String from, ConversionResult out_result, boolean isSigned) {
        BigInteger upper = null;
        BigInteger lower = null;
        if (isSigned) {
            upper = ConverterConstants.SIGNED_BIGINT_MAX;
            lower = ConverterConstants.SIGNED_BIGINT_MIN;
        } else {
            upper = ConverterConstants.UNSIGNED_BIGINT_MAX;
            lower = BigInteger.ZERO;
        }
        return CharConverter.convertInteger(from, out_result, lower, upper);
    }

    public static boolean toBit(String from, ConversionResult out_result) {
        BigInteger upper;
        BigInteger lower;
        BigInteger result;
        if ((from = from.trim()).length() == 1) {
            if (from.charAt(0) == '0') {
                out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
                return false;
            }
            if (from.charAt(0) == '1') {
                out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
                return true;
            }
        }
        if (null == (result = CharConverter.convertInteger(from, out_result, lower = BigInteger.ZERO, upper = BigInteger.ONE))) {
            assert (ConversionResult.TypeConversionState.SUCCESS != out_result.getState());
            return false;
        }
        return result.compareTo(BigInteger.ONE) == 0;
    }

    public static String toChar(String input, long targetLength, ConversionResult out_result) {
        String result = input;
        if ((long)result.length() <= targetLength) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            result = result.substring(0, (int)targetLength);
        }
        return result;
    }

    public static Date toDate(String from, ConversionResult out_result, GregorianCalendar calendar) {
        if (null == calendar) {
            calendar = new GregorianCalendar();
        }
        calendar.clear();
        Matcher m = ConverterConstants.TIMESTAMP_PATTERN.matcher(from.trim());
        int[] field = CharConverter.parseTimestamp(calendar, m);
        if (field == null) {
            out_result.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        if (0 > field[0]) {
            calendar.set(0, 0);
            field[0] = field[0] * -1;
        }
        calendar.set(field[0], field[1] - 1, field[2], 0, 0, 0);
        calendar.set(14, 0);
        if (field[3] != 0 || field[4] != 0 || field[5] != 0 || field[6] != 0) {
            out_result.setState(ConversionResult.TypeConversionState.DATETIME_OVERFLOW);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return new Date(calendar.getTimeInMillis());
    }

    public static double toDouble(String from, ConversionResult out_result) {
        if ((from = from.trim()).equalsIgnoreCase("NaN")) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
            return Double.NaN;
        }
        if (from.equalsIgnoreCase("INFINITY")) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
            return Double.POSITIVE_INFINITY;
        }
        if (from.equalsIgnoreCase("-INFINITY")) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
            return Double.NEGATIVE_INFINITY;
        }
        double ret = 0.0;
        try {
            ret = Double.parseDouble(from);
        }
        catch (NumberFormatException nfe) {
            out_result.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return ret;
        }
        if (ret == Double.POSITIVE_INFINITY) {
            out_result.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else if (ret == Double.NEGATIVE_INFINITY) {
            out_result.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return ret;
    }

    public static BigDecimal toExactNum(String from, ConversionResult out_result, short precision, short scale) {
        BigDecimal input;
        if (CharConverter.isNanStr(from = from.trim())) {
            out_result.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        if (CharConverter.isPosInfStr(from)) {
            out_result.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        if (CharConverter.isNegInfStr(from)) {
            out_result.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        try {
            input = new BigDecimal(from);
        }
        catch (NumberFormatException e) {
            out_result.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        return ExactNumConverter.setPrecScale(input, precision, scale, out_result);
    }

    public static double toFloat(String from, ConversionResult out_result) {
        return CharConverter.toDouble(from, out_result);
    }

    public static UUID toGUID(String from, ConversionResult cr) {
        from = from.trim();
        byte[] output = new byte[16];
        if (!(36 == from.length() && CharConverter.convertHex(from.substring(0, 8), output, 0) && '-' == from.charAt(8) && CharConverter.convertHex(from.substring(9, 13), output, 4) && '-' == from.charAt(13) && CharConverter.convertHex(from.substring(14, 18), output, 6) && '-' == from.charAt(18) && CharConverter.convertHex(from.substring(19, 23), output, 8) && '-' == from.charAt(23) && CharConverter.convertHex(from.substring(24), output, 10))) {
            cr.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        long hiBits = 0L;
        for (int i = 0; i < 8; ++i) {
            hiBits = hiBits << 8 | (long)(output[i] & 0xFF);
        }
        long loBits = 0L;
        for (int i = 8; i < 16; ++i) {
            loBits = loBits << 8 | (long)(output[i] & 0xFF);
        }
        cr.setState(ConversionResult.TypeConversionState.SUCCESS);
        return new UUID(hiBits, loBits);
    }

    public static long toInteger(String from, ConversionResult out_result, boolean isSigned) {
        BigInteger upper = null;
        BigInteger lower = null;
        if (isSigned) {
            upper = ConverterConstants.SIGNED_INT_MAX;
            lower = ConverterConstants.SIGNED_INT_MIN;
        } else {
            upper = ConverterConstants.UNSIGNED_INT_MAX;
            lower = BigInteger.ZERO;
        }
        BigInteger result = CharConverter.convertInteger(from, out_result, lower, upper);
        if (result == null) {
            assert (ConversionResult.TypeConversionState.SUCCESS != out_result.getState());
            return -1L;
        }
        return result.longValue();
    }

    public static float toReal(String from, ConversionResult out_result) {
        if ((from = from.trim()).equalsIgnoreCase("NaN")) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
            return Float.NaN;
        }
        if (from.equalsIgnoreCase("INFINITY")) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
            return Float.POSITIVE_INFINITY;
        }
        if (from.equalsIgnoreCase("-INFINITY")) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
            return Float.NEGATIVE_INFINITY;
        }
        float ret = 0.0f;
        try {
            ret = Float.parseFloat(from);
        }
        catch (NumberFormatException e) {
            out_result.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return ret;
        }
        if (ret == Float.POSITIVE_INFINITY) {
            out_result.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else if (ret == Float.NEGATIVE_INFINITY) {
            out_result.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return ret;
    }

    public static int toSmallint(String from, ConversionResult out_result, boolean isSigned) {
        BigInteger upper = null;
        BigInteger lower = null;
        if (isSigned) {
            upper = ConverterConstants.SIGNED_SMALLINT_MAX;
            lower = ConverterConstants.SIGNED_SMALLINT_MIN;
        } else {
            upper = ConverterConstants.UNSIGNED_SMALLINT_MAX;
            lower = BigInteger.ZERO;
        }
        BigInteger result = CharConverter.convertInteger(from, out_result, lower, upper);
        if (result == null) {
            assert (ConversionResult.TypeConversionState.SUCCESS != out_result.getState());
            return -1;
        }
        return result.intValue();
    }

    public static Time toTime(String from, ConversionResult out_result, short precision, GregorianCalendar calendar) {
        int[] field;
        if (precision < 0 || precision > 9) {
            throw new IllegalArgumentException("Invalid precision");
        }
        if (null == calendar) {
            calendar = new GregorianCalendar();
        }
        if ((field = CharConverter.parseTime(from, calendar)) == null) {
            out_result.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        calendar.clear();
        calendar.set(1970, 0, 1, field[3], field[4], field[5]);
        int fractionalSec = DateTimeConverter.calculateFractionalSeconds(field[6], Math.min(precision, 3));
        calendar.set(14, fractionalSec / 1000000);
        Time result = new Time(calendar.getTimeInMillis());
        if (fractionalSec != field[6]) {
            out_result.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        if (field[0] != 0 || field[1] != 0 || field[2] != 0) {
            out_result.setState(ConversionResult.TypeConversionState.DATETIME_OVERFLOW);
        }
        return result;
    }

    public static Timestamp toTimestamp(String from, ConversionResult out_result, short precision, GregorianCalendar calendar) {
        Matcher m = ConverterConstants.TIMESTAMP_PATTERN.matcher(from.trim());
        if (m.matches()) {
            if (precision < 0 || precision > 9) {
                throw new IllegalArgumentException("Invalid precision");
            }
            if (null == calendar) {
                calendar = new GregorianCalendar();
            }
            return CharConverter.doTsStrToTimestamp(out_result, precision, calendar, m);
        }
        return CharConverter.timeStrToTimestamp(from, out_result, precision, calendar);
    }

    public static short toTinyint(String from, ConversionResult out_result, boolean isSigned) {
        BigInteger upper = null;
        BigInteger lower = null;
        if (isSigned) {
            upper = ConverterConstants.SIGNED_TINYINT_MAX;
            lower = ConverterConstants.SIGNED_TINYINT_MIN;
        } else {
            upper = ConverterConstants.UNSIGNED_TINYINT_MAX;
            lower = BigInteger.ZERO;
        }
        BigInteger result = CharConverter.convertInteger(from, out_result, lower, upper);
        if (result == null) {
            return -1;
        }
        return result.shortValue();
    }

    public static Timestamp tsStrToTimestamp(String from, ConversionResult out_result, short precision, GregorianCalendar calendar) {
        if (precision < 0 || precision > 9) {
            throw new IllegalArgumentException("Invalid precision");
        }
        if (null == calendar) {
            calendar = new GregorianCalendar();
        }
        Matcher m = ConverterConstants.TIMESTAMP_PATTERN.matcher(from.trim());
        return CharConverter.doTsStrToTimestamp(out_result, precision, calendar, m);
    }

    public static Timestamp timeStrToTimestamp(String from, ConversionResult out_result, short precision, GregorianCalendar calendar) {
        int[] field;
        if (precision < 0 || precision > 9) {
            throw new IllegalArgumentException("Invalid precision");
        }
        if (null == calendar) {
            calendar = new GregorianCalendar();
        }
        if ((field = CharConverter.parseTime(from, calendar)) == null) {
            out_result.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        calendar.clear();
        calendar.set(1970, 0, 1, field[3], field[4], field[5]);
        int fractionalSec = DateTimeConverter.calculateFractionalSeconds(field[6], Math.min(precision, 3));
        calendar.set(14, fractionalSec / 1000000);
        Timestamp result = new Timestamp(calendar.getTimeInMillis());
        if (fractionalSec != field[6]) {
            out_result.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return result;
    }

    private static boolean convertHex(CharSequence charSeq, byte[] output, int offset) {
        int len = charSeq.length();
        if (0 != len % 2) {
            return false;
        }
        int i = 0;
        while (i < len) {
            int a = Character.digit(charSeq.charAt(i++), 16);
            int b = Character.digit(charSeq.charAt(i++), 16);
            if (0 > a || 0 > b) {
                return false;
            }
            output[offset++] = (byte)(a << 4 | b);
        }
        return true;
    }

    private static BigInteger convertInteger(String val, ConversionResult out_result, BigInteger lowerLimit, BigInteger upperLimit) {
        if (CharConverter.isNanStr(val = val.trim())) {
            out_result.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        if (CharConverter.isPosInfStr(val)) {
            out_result.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        if (CharConverter.isNegInfStr(val)) {
            out_result.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        BigDecimal bigDecVal = null;
        try {
            bigDecVal = new BigDecimal(val.trim());
        }
        catch (NumberFormatException nfe) {
            out_result.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        BigInteger bigIntVal = bigDecVal.toBigInteger();
        if (bigIntVal.compareTo(lowerLimit) < 0) {
            out_result.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        if (bigIntVal.compareTo(upperLimit) > 0) {
            out_result.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        if (bigDecVal.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0) {
            if (bigDecVal.compareTo(BigDecimal.ZERO) > 0) {
                out_result.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else {
                out_result.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            }
        } else {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return bigIntVal;
    }

    private static Timestamp doTsStrToTimestamp(ConversionResult out_result, short precision, GregorianCalendar calendar, Matcher m) {
        int[] field = CharConverter.parseTimestamp(calendar, m);
        if (field == null) {
            out_result.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        calendar.clear();
        calendar.set(0, field[0] < 0 ? 0 : 1);
        calendar.set(Math.abs(field[0]), field[1] - 1, field[2], field[3], field[4], field[5]);
        Timestamp result = new Timestamp(calendar.getTimeInMillis());
        int fractionalSec = DateTimeConverter.calculateFractionalSeconds(field[6], precision);
        result.setNanos(fractionalSec);
        if (fractionalSec != field[6]) {
            out_result.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return result;
    }

    private static int[] parseTimestamp(GregorianCalendar cal, Matcher m) {
        if (!m.matches()) {
            return null;
        }
        int[] ret = new int[7];
        for (int i = 0; i < 6; ++i) {
            String group = m.group(i + 1);
            ret[i] = group == null ? 0 : Integer.parseInt(group);
        }
        if (!CharConverter.checkGregorianDate(ret[0], ret[1], ret[2], cal) || !CharConverter.checkTime(ret[3], ret[4], ret[5])) {
            return null;
        }
        String fraction = m.group(7);
        if (fraction == null) {
            ret[6] = 0;
            return ret;
        }
        ret[6] = Integer.parseInt(fraction) * ConverterConstants.FRACTIONAL_MOD[fraction.length()];
        return ret;
    }

    private static int[] parseTime(String val, GregorianCalendar cal) {
        Matcher m = ConverterConstants.TIME_PATTERN.matcher(val.trim());
        if (!m.matches()) {
            return null;
        }
        String yearStr = m.group(1);
        String monthStr = m.group(2);
        String dayStr = m.group(3);
        int[] ret = new int[7];
        if (yearStr != null) {
            ret[0] = Integer.parseInt(yearStr);
            ret[1] = Integer.parseInt(monthStr);
            ret[2] = Integer.parseInt(dayStr);
            if (!CharConverter.checkGregorianDate(ret[0], ret[1], ret[2], cal)) {
                return null;
            }
        } else {
            ret[0] = 0;
            ret[1] = 0;
            ret[2] = 0;
        }
        ret[3] = Integer.parseInt(m.group(4));
        ret[4] = Integer.parseInt(m.group(5));
        ret[5] = Integer.parseInt(m.group(6));
        if (!CharConverter.checkTime(ret[3], ret[4], ret[5])) {
            return null;
        }
        String fraction = m.group(7);
        if (fraction == null) {
            ret[6] = 0;
            return ret;
        }
        ret[6] = Integer.parseInt(fraction) * ConverterConstants.FRACTIONAL_MOD[fraction.length()];
        return ret;
    }

    private static boolean checkGregorianDate(int year, int month, int day, GregorianCalendar gCal) {
        if (year == 0) {
            return false;
        }
        gCal.clear();
        gCal.set(0, year < 0 ? 0 : 1);
        gCal.set(Math.abs(year), --month, day);
        return gCal.get(1) == Math.abs(year) && gCal.get(2) == month && gCal.get(5) == day;
    }

    private static boolean checkTime(int hour, int minute, int second) {
        if (hour < 0 || hour > 23) {
            return false;
        }
        if (minute < 0 || minute > 59) {
            return false;
        }
        return second >= 0 && second <= 61;
    }

    private static boolean isPosInfStr(String val) {
        return val.equalsIgnoreCase("INFINITY");
    }

    private static boolean isNegInfStr(String val) {
        return val.equalsIgnoreCase("-INFINITY");
    }

    private static boolean isNanStr(String val) {
        return val.equalsIgnoreCase("NaN");
    }
}

