/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.deserializer.impl;

import com.vertica.deserializer.MultiFormatDeserializer;
import com.vertica.deserializer.impl.TimestampDeserializerImpl;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.util.ClientErrorException;
import com.vertica.util.TimeStampParser;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;

public class TimestampTZDeserializerImpl
implements MultiFormatDeserializer {
    public int m_oid;
    TimeStampParser m_Parser;

    public TimestampTZDeserializerImpl(int n) {
        this.m_oid = n;
    }

    @Override
    public boolean deserializeBinary(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        TimestampDeserializerImpl.deserializeTimestampBinary(this.m_oid, dataWrapper, byArray, hashMap);
        return false;
    }

    @Override
    public boolean deserializeText(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        if (TimestampDeserializerImpl.deserializeInfinityTimestamp(dataWrapper, byArray)) {
            return false;
        }
        if (this.m_Parser == null) {
            this.m_Parser = new TimeStampParser();
        }
        this.m_Parser.setData(byArray);
        Calendar calendar = this.m_Parser.getCalendar(13);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(this.m_Parser.getNanoseconds());
        dataWrapper.setTimestamp(new TimestampTz(timestamp, calendar));
        return false;
    }
}

