/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.deserializer.impl;

import com.vertica.deserializer.MultiFormatDeserializer;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.TimeTz;
import com.vertica.util.ClientErrorException;
import com.vertica.util.TimeParser;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class TimeDeserializerImpl
implements MultiFormatDeserializer {
    private int m_oid;
    private static final int ASCII_OFFSET = 48;

    public TimeDeserializerImpl(int n) {
        this.m_oid = n;
    }

    @Override
    public boolean deserializeBinary(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        long l3 = ByteBuffer.wrap(byArray).getLong();
        switch (this.m_oid) {
            case 15: {
                int n = (int)(86400L - (l3 & 0xFFFFFFL)) * 1000;
                long l4 = l3 >> 24;
                long l5 = l4 / 1000L;
                int n2 = (int)TimeUnit.MILLISECONDS.toHours(l5 += (long)n);
                int n3 = (int)TimeUnit.MILLISECONDS.toMinutes(l5) % 60;
                int n4 = (int)TimeUnit.MILLISECONDS.toSeconds(l5) % 60;
                int n5 = (int)(l4 % 1000000L);
                Calendar calendar = Calendar.getInstance();
                calendar.set(1970, 0, 1, n2, n3, n4);
                calendar.set(14, n5 / 1000000);
                TimeTz timeTz = new TimeTz(new Time(calendar.getTimeInMillis()), calendar);
                dataWrapper.setTime(timeTz);
                break;
            }
            case 11: {
                long l6 = Math.round((double)l3 / 1000.0);
                long l7 = Calendar.getInstance().getTimeZone().getOffset(0L);
                dataWrapper.setTime(new Time(l6 -= l7));
                break;
            }
            default: {
                throw new ClientErrorException("Invalid time/timetz type " + this.m_oid);
            }
        }
        return false;
    }

    @Override
    public boolean deserializeText(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        TimeParser timeParser = new TimeParser(byArray);
        long l3 = timeParser.calculateMilliSeconds() - (long)timeParser.getTimzoneOffset();
        switch (this.m_oid) {
            case 15: {
                if (!timeParser.hasTimezone()) {
                    throw new ClientErrorException("Invalid timetz data. Time zone was expected but not found. " + this.m_oid);
                }
                Calendar calendar = Calendar.getInstance();
                calendar.set(1970, 0, 1, timeParser.getHours(), timeParser.getMinutes(), timeParser.getSeconds());
                calendar.set(14, timeParser.getFraction() / 1000000);
                TimeTz timeTz = new TimeTz(new Time(calendar.getTimeInMillis()), calendar);
                dataWrapper.setTime(timeTz);
                break;
            }
            case 11: {
                if (timeParser.hasTimezone()) {
                    throw new ClientErrorException("Invalid time data. Time zone was found but not expected. " + this.m_oid);
                }
                long l4 = Calendar.getInstance().getTimeZone().getOffset(0L);
                dataWrapper.setTime(new Time(l3 -= l4));
                break;
            }
            default: {
                throw new ClientErrorException("Invalid time/timetz type " + this.m_oid);
            }
        }
        return false;
    }
}

