/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.deserializer.impl;

import com.vertica.core.VConnection;
import com.vertica.deserializer.MultiFormatDeserializer;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;

public class NumericDeserializerImpl
implements MultiFormatDeserializer {
    private int m_typeMod;

    public NumericDeserializerImpl(int n) {
        this.m_typeMod = n;
    }

    @Override
    public boolean deserializeBinary(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException {
        if (this.m_typeMod == -1) {
            throw new RuntimeException("Numeric types may not be accessed in binary transfer mode with this version of the server. Please upgrade to version 11.1 or greater, or turn off binary transfer mode.");
        }
        BigInteger bigInteger = new BigInteger(byArray);
        int n = NumericDeserializerImpl.getNumericScale(this.m_typeMod);
        dataWrapper.setNumeric(new BigDecimal(bigInteger, n));
        return false;
    }

    @Override
    public boolean deserializeText(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException {
        dataWrapper.setVarChar(new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET));
        return false;
    }

    public static int getNumericScale(int n) {
        return n == -1 ? 15 : n - 4 & 0xFF;
    }
}

