/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.security.TrustStoreResolver;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class OAuthConnection {
    String refreshToken;
    String tokenUrl;
    String clientId;
    String clientSecret;
    String discoveryUrl;
    String scope;
    boolean validateCertHostname = true;
    TrustStoreResolver m_trustStore;
    DSILogger m_log;

    public OAuthConnection(String string, String string2, String string3, String string4, String string5, String string6, String string7, TrustStoreResolver trustStoreResolver, DSILogger dSILogger) {
        this.refreshToken = string;
        this.tokenUrl = string2;
        this.clientId = string3;
        this.clientSecret = string4;
        this.discoveryUrl = string5;
        this.scope = string6;
        this.m_trustStore = trustStoreResolver;
        this.m_log = dSILogger;
        if (string7 != null && !string7.isEmpty()) {
            this.ParseJsonConfig(string7);
        }
    }

    private String ParseJsonField(JsonObject jsonObject, String string) {
        JsonElement jsonElement = jsonObject.get(string);
        if (jsonElement != null) {
            return jsonElement.getAsString();
        }
        JsonElement jsonElement2 = jsonObject.get(string.toLowerCase());
        if (jsonElement2 != null) {
            return jsonElement2.getAsString();
        }
        return "";
    }

    public void ParseJsonConfig(String string) {
        try {
            JsonElement jsonElement = new JsonParser().parse(string);
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String string2 = "";
            string2 = this.ParseJsonField(jsonObject, "OAuthTokenUrl");
            if (!string2.isEmpty()) {
                this.tokenUrl = string2;
            } else if (!this.tokenUrl.isEmpty()) {
                LogUtilities.logWarning("Value for field OAuthTokenUrl is set in both json config and direct parameter.", (ILogger)this.m_log);
            }
            string2 = this.ParseJsonField(jsonObject, "OAuthDiscoveryUrl");
            if (!string2.isEmpty()) {
                this.discoveryUrl = string2;
            } else if (!this.discoveryUrl.isEmpty()) {
                LogUtilities.logWarning("Value for field OAuthDiscoveryUrl is set in both json config and direct parameter.", (ILogger)this.m_log);
            }
            string2 = this.ParseJsonField(jsonObject, "OAuthClientId");
            if (!string2.isEmpty()) {
                this.clientId = string2;
            } else if (!this.clientId.isEmpty()) {
                LogUtilities.logWarning("Value for field OAuthClientId is set in both json config and direct parameter.", (ILogger)this.m_log);
            }
            string2 = this.ParseJsonField(jsonObject, "OAuthClientSecret");
            if (!string2.isEmpty()) {
                this.clientSecret = string2;
            } else if (!this.clientSecret.isEmpty()) {
                LogUtilities.logWarning("Value for field OAuthClientSecret is set in both json config and direct parameter.", (ILogger)this.m_log);
            }
            string2 = this.ParseJsonField(jsonObject, "OAuthScope");
            if (!string2.isEmpty()) {
                this.scope = string2;
            } else if (!this.scope.isEmpty()) {
                LogUtilities.logWarning("Value for field OAuthScope is set in both json config and direct parameter.", (ILogger)this.m_log);
            }
            string2 = this.ParseJsonField(jsonObject, "OAuthValidateHostname");
            if (!string2.isEmpty() && string2.equals("false")) {
                this.validateCertHostname = false;
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            throw new OAuthConfigurationException("Invalid JSON string provided for OAuth configuration", jsonSyntaxException);
        }
    }

    private void SetHostnameValidation(HttpURLConnection httpURLConnection) {
        if (!this.validateCertHostname && httpURLConnection instanceof HttpsURLConnection) {
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(hostnameVerifier);
        }
    }

    private void SetCustomizedSSLSocketFactory(HttpURLConnection httpURLConnection) {
        if (httpURLConnection instanceof HttpsURLConnection) {
            try {
                KeyStore keyStore = this.m_trustStore.getKeyStore();
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(sSLSocketFactory);
                LogUtilities.logInfo("set CustomizedSSLSocketFactory for OAuth", (ILogger)this.m_log);
            }
            catch (Exception exception) {
                throw new OAuthConfigurationException("Cannot set Customized SSLSocketFactory", exception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String GetTokenResponse(String string) {
        try {
            String string2 = "grant_type=refresh_token&client_secret=" + this.clientSecret + "&client_id=" + this.clientId + "&refresh_token=" + this.refreshToken;
            if (this.scope != null && !this.scope.isEmpty()) {
                string2 = string2 + "&scope=" + this.scope;
            }
            byte[] byArray = string2.getBytes("UTF-8");
            int n = byArray.length;
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            try {
                String string3;
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                httpURLConnection.setRequestProperty("Content-Length", Integer.toString(n));
                httpURLConnection.setRequestProperty("charset", "UTF-8");
                httpURLConnection.setRequestProperty("Accept", "application/json");
                this.SetCustomizedSSLSocketFactory(httpURLConnection);
                this.SetHostnameValidation(httpURLConnection);
                httpURLConnection.getOutputStream().write(byArray);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = bufferedInputStream.read();
                while (n2 != -1) {
                    byteArrayOutputStream.write((byte)n2);
                    n2 = bufferedInputStream.read();
                }
                String string4 = string3 = byteArrayOutputStream.toString("UTF-8");
                return string4;
            }
            catch (Exception exception) {
                String string5 = "";
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getErrorStream());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n3 = bufferedInputStream.read();
                    while (true) {
                        if (n3 == -1) {
                            string5 = byteArrayOutputStream.toString("UTF-8");
                            throw new OAuthTokenRefreshException("Error when trying to refresh token, response was: " + string5, exception);
                        }
                        byteArrayOutputStream.write((byte)n3);
                        n3 = bufferedInputStream.read();
                    }
                }
                catch (Exception exception2) {
                    LogUtilities.logWarning("Error reading error stream from failed OAuth token refresh: " + exception2.toString(), (ILogger)this.m_log);
                    throw new OAuthTokenRefreshException("Error when trying to refresh token", exception);
                }
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
        catch (OAuthTokenRefreshException oAuthTokenRefreshException) {
            throw oAuthTokenRefreshException;
        }
        catch (Exception exception) {
            throw new OAuthTokenRefreshException("Error connecting to token refresh server: ", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String DiscoverTokenEndpoint(String string) {
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            try {
                String string2;
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setRequestMethod("GET");
                this.SetCustomizedSSLSocketFactory(httpURLConnection);
                this.SetHostnameValidation(httpURLConnection);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = bufferedInputStream.read();
                while (n != -1) {
                    byteArrayOutputStream.write((byte)n);
                    n = bufferedInputStream.read();
                }
                String string3 = byteArrayOutputStream.toString("UTF-8");
                JsonElement jsonElement = new JsonParser().parse(string3);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String string4 = string2 = jsonObject.get("token_endpoint").getAsString();
                return string4;
            }
            catch (Exception exception) {
                String string5 = "";
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getErrorStream());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n = bufferedInputStream.read();
                    while (true) {
                        if (n == -1) {
                            string5 = byteArrayOutputStream.toString("UTF-8");
                            throw new OAuthEndpointDiscoveryException("Error when fetching token endpoints, response was: " + string5, exception);
                        }
                        byteArrayOutputStream.write((byte)n);
                        n = bufferedInputStream.read();
                    }
                }
                catch (Exception exception2) {
                    LogUtilities.logWarning("Error reading error stream from failed OAuth token endpoint discovery: " + exception2.toString(), (ILogger)this.m_log);
                    throw new OAuthEndpointDiscoveryException("Error when fetching token endpoints", exception);
                }
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
        catch (OAuthEndpointDiscoveryException oAuthEndpointDiscoveryException) {
            throw oAuthEndpointDiscoveryException;
        }
        catch (Exception exception) {
            throw new OAuthEndpointDiscoveryException("Error connecting to identity provider: ", exception);
        }
    }

    public String GetActiveToken() {
        String string = this.tokenUrl;
        if (this.discoveryUrl.length() > 0) {
            string = this.DiscoverTokenEndpoint(this.discoveryUrl);
        }
        String string2 = this.GetTokenResponse(string);
        try {
            JsonElement jsonElement = new JsonParser().parse(string2);
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String string3 = jsonObject.get("access_token").getAsString();
            return string3;
        }
        catch (Exception exception) {
            throw new OAuthTokenRefreshException("Failed when parsing token refresh response. ", exception);
        }
    }

    public static class OAuthMissingParameterException
    extends RuntimeException {
        public OAuthMissingParameterException(String string) {
            super(string);
        }
    }

    public class OAuthEndpointDiscoveryException
    extends RuntimeException {
        public OAuthEndpointDiscoveryException(String string, Exception exception) {
            super(string, exception);
        }
    }

    public class OAuthTokenRefreshException
    extends RuntimeException {
        public OAuthTokenRefreshException(String string, Exception exception) {
            super(string, exception);
        }
    }

    public class OAuthConfigurationException
    extends RuntimeException {
        public OAuthConfigurationException(String string, Exception exception) {
            super(string, exception);
        }
    }
}

