/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnection;
import com.vertica.dataengine.VQueryExecutor;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.VerticaPreparedStatement;
import com.vertica.jdbc.VerticaStatementSharedImpl;
import com.vertica.jdbc.jdbc4.S4Connection;
import com.vertica.jdbc.jdbc4.S4PreparedStatement;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.FeatureNotSupportedException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;

final class VerticaJdbc4PreparedStatementImpl
extends S4PreparedStatement
implements VerticaPreparedStatement {
    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    protected VerticaJdbc4PreparedStatementImpl(String string, IStatement iStatement, S4Connection s4Connection, int n) throws SQLException {
        super(string, iStatement, s4Connection, n);
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        ((VQueryExecutor)this.m_queryExecutor).setIsPreparedExecuteBatch(true);
        int[] nArray = null;
        try {
            nArray = super.executeBatch();
        }
        finally {
            ((VQueryExecutor)this.m_queryExecutor).setIsPreparedExecuteBatch(false);
        }
        return nArray;
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        if (this.m_statement != null) {
            VConnection vConnection = (VConnection)this.m_statement.getParentConnection();
            FeatureNotSupportedException featureNotSupportedException = VerticaStatementSharedImpl.getInstance().validateClearBatch(vConnection, this.m_queryExecutor);
            if (featureNotSupportedException != null) {
                throw ExceptionConverter.getInstance().toSQLException(featureNotSupportedException, vConnection.getWarningListener());
            }
            super.clearBatch();
        }
    }

    @Override
    public void cancel() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        super.cancel();
        VerticaStatementSharedImpl.getInstance().cancel(this, this.m_warningListener, this.m_logger);
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        VerticaStatementSharedImpl.getInstance().setNull((ParameterMetadata)this.m_parameterMetadata.get(n - 1), n, this.m_warningListener);
        super.setNull(n, n2);
    }
}

