/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.webview;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import com.verizon.ads.EnvironmentInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.support.utils.ActivityUtils;
import com.verizon.ads.utils.IOUtils;
import java.io.File;

public class MediaUtils {
    private static final Logger logger = Logger.getInstance(MediaUtils.class);

    public static void savePicture(final Context context, String url, String fileName, final SavePictureListener pictureListener) {
        if (pictureListener == null) {
            logger.e("PictureListener is required");
            return;
        }
        EnvironmentInfo environmentInfo = new EnvironmentInfo(context);
        if (!environmentInfo.getDeviceInfo().isExternalStorageWritable()) {
            pictureListener.onError("Storage not mounted, cannot add image to photo library");
            return;
        }
        if (url == null) {
            pictureListener.onError("url is required");
            return;
        }
        Uri pictureUri = Uri.parse((String)url);
        if (pictureUri.getScheme().startsWith("http")) {
            File picturesDir = MediaUtils.getPicturesDirectory(context);
            if (picturesDir == null) {
                pictureListener.onError("Cannot access pictures directory");
                return;
            }
            File pictureFile = fileName == null ? IOUtils.getUniqueFileName((File)picturesDir, (String)pictureUri.getLastPathSegment()) : IOUtils.getUniqueFileName((File)picturesDir, (String)fileName);
            if (pictureFile == null) {
                pictureListener.onError("Unable to store photo");
                return;
            }
            IOUtils.downloadFile((String)url, null, (File)pictureFile, (IOUtils.DownloadListener)new IOUtils.DownloadListener(){

                public void onDownloadSucceeded(File downloadedFile) {
                    if (Logger.isLogLevelEnabled((int)3)) {
                        logger.d("Picture downloaded to: " + downloadedFile.getAbsolutePath());
                    }
                    MediaUtils.scanPicture(context, downloadedFile, pictureListener, true);
                }

                public void onDownloadFailed(Throwable throwable) {
                    pictureListener.onError("Unable to download file");
                }
            });
        } else {
            File pictureFile = new File(pictureUri.getPath());
            if (!pictureFile.exists()) {
                pictureListener.onError("No file found at " + pictureFile.getAbsolutePath());
                return;
            }
            MediaUtils.scanPicture(context, pictureFile, pictureListener, false);
        }
    }

    public static void startVideoPlayer(Context context, String url, PlayVideoListener videoListener) {
        if (videoListener == null) {
            logger.e("VideoListener is required");
            return;
        }
        if (url == null) {
            videoListener.onError("url is required");
            return;
        }
        Uri videoUri = Uri.parse((String)url);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(videoUri, "video/*");
        if (ActivityUtils.startActivity((Context)context, (Intent)intent)) {
            videoListener.onVideoStarted(videoUri);
        } else {
            videoListener.onError("No video application installed");
        }
    }

    private static void scanPicture(Context context, final File file, final SavePictureListener pictureListener, final boolean deleteOnFailure) {
        MediaScannerConnection.scanFile((Context)context, (String[])new String[]{file.getAbsolutePath()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

            public void onScanCompleted(String path, Uri uri) {
                if (uri == null) {
                    if (deleteOnFailure) {
                        file.delete();
                    }
                    pictureListener.onError("Failed to scan file " + path);
                } else {
                    pictureListener.onPictureSaved(file);
                }
            }
        });
    }

    private static File getPicturesDirectory(Context context) {
        File picturesDir = null;
        if (Build.VERSION.SDK_INT >= 23) {
            File[] externalMediaDirs = context.getExternalMediaDirs();
            if (externalMediaDirs.length > 0) {
                picturesDir = externalMediaDirs[0];
            }
        } else {
            picturesDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        }
        String applicationName = "Saved";
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            applicationName = packageManager.getApplicationLabel(appInfo).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            logger.e("Could not retrieve the application label", (Throwable)e);
        }
        if (picturesDir != null) {
            picturesDir = new File(picturesDir.getAbsolutePath() + File.separator + "Verizon" + File.separator + applicationName);
            picturesDir.mkdirs();
        }
        return picturesDir;
    }

    public static interface PlayVideoListener {
        public void onVideoStarted(Uri var1);

        public void onError(String var1);
    }

    public static interface SavePictureListener {
        public void onPictureSaved(File var1);

        public void onError(String var1);
    }
}

