/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper;

import com.veracode.util.http.WebClient;
import com.veracode.util.lang.StringUtility;
import java.net.Proxy;
import javax.xml.bind.DatatypeConverter;

public abstract class AbstractAPIWrapper {
    protected WebClient webClient = new WebClient();

    public void setUpProxy(Proxy proxy) {
        this.webClient.proxy = proxy;
    }

    public void setUpProxy(String host, String port) {
        this.setUpProxy(host, port, null, null);
    }

    public void setUpProxy(String host, String port, String username, String password) {
        int portNumber = 0;
        try {
            portNumber = Integer.parseInt(port);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.webClient.setProxy(host, portNumber, username, password);
    }

    public void setUpCredentials(String username, String password) {
        String credentials = String.valueOf(username) + ":" + password;
        String encodedCredentials = DatatypeConverter.printBase64Binary((byte[])StringUtility.getBytes(credentials, "UTF-8"));
        String authorization = "Basic " + encodedCredentials;
        this.webClient.headers.put("Authorization", authorization);
    }

    protected AbstractAPIWrapper() {
    }
}

