/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.gfx;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ViewConfiguration;
import com.vccorp.content.R;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="gfx")
public class ViewConfigurationHelper {
    public static final float MIN_SCALING_SPAN_MM = 12.0f;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public ViewConfiguration mViewConfiguration = ViewConfiguration.get((Context)ContextUtils.getApplicationContext());
    public float mDensity;

    public ViewConfigurationHelper() {
        this.mDensity = ContextUtils.getApplicationContext().getResources().getDisplayMetrics().density;
        if (!$assertionsDisabled && !(this.mDensity > 0.0f)) {
            throw new AssertionError();
        }
    }

    private void registerListener() {
        ContextUtils.getApplicationContext().registerComponentCallbacks(new ComponentCallbacks(){

            public void onConfigurationChanged(Configuration configuration) {
                ViewConfigurationHelper.this.updateNativeViewConfigurationIfNecessary();
            }

            public void onLowMemory() {
            }
        });
    }

    private void updateNativeViewConfigurationIfNecessary() {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)ContextUtils.getApplicationContext());
        if (this.mViewConfiguration == viewConfiguration) {
            if (!$assertionsDisabled && this.mDensity != ContextUtils.getApplicationContext().getResources().getDisplayMetrics().density) {
                throw new AssertionError();
            }
            return;
        }
        ViewConfigurationHelper viewConfigurationHelper = this;
        viewConfigurationHelper.mViewConfiguration = viewConfiguration;
        viewConfigurationHelper.mDensity = ContextUtils.getApplicationContext().getResources().getDisplayMetrics().density;
        if (!$assertionsDisabled && !(this.mDensity > 0.0f)) {
            throw new AssertionError();
        }
        ViewConfigurationHelper viewConfigurationHelper2 = this;
        viewConfigurationHelper2.nativeUpdateSharedViewConfiguration(viewConfigurationHelper2.getMaximumFlingVelocity(), this.getMinimumFlingVelocity(), this.getTouchSlop(), this.getDoubleTapSlop(), this.getMinScalingSpan());
    }

    public static int getDoubleTapTimeout() {
        return ViewConfiguration.getDoubleTapTimeout();
    }

    public static int getLongPressTimeout() {
        return ViewConfiguration.getLongPressTimeout();
    }

    public static int getTapTimeout() {
        return ViewConfiguration.getTapTimeout();
    }

    private float getMaximumFlingVelocity() {
        ViewConfigurationHelper viewConfigurationHelper = this;
        return viewConfigurationHelper.toDips(viewConfigurationHelper.mViewConfiguration.getScaledMaximumFlingVelocity());
    }

    private float getMinimumFlingVelocity() {
        ViewConfigurationHelper viewConfigurationHelper = this;
        return viewConfigurationHelper.toDips(viewConfigurationHelper.mViewConfiguration.getScaledMinimumFlingVelocity());
    }

    private float getTouchSlop() {
        ViewConfigurationHelper viewConfigurationHelper = this;
        return viewConfigurationHelper.toDips(viewConfigurationHelper.mViewConfiguration.getScaledTouchSlop());
    }

    private float getDoubleTapSlop() {
        ViewConfigurationHelper viewConfigurationHelper = this;
        return viewConfigurationHelper.toDips(viewConfigurationHelper.mViewConfiguration.getScaledDoubleTapSlop());
    }

    private float getMinScalingSpan() {
        ViewConfigurationHelper viewConfigurationHelper = this;
        return viewConfigurationHelper.toDips(viewConfigurationHelper.getScaledMinScalingSpan());
    }

    private int getScaledMinScalingSpan() {
        ViewConfigurationHelper viewConfigurationHelper = ContextUtils.getApplicationContext().getResources();
        try {
            return viewConfigurationHelper.getDimensionPixelSize(R.dimen.config_min_scaling_span);
        }
        catch (Resources.NotFoundException notFoundException) {
            if ($assertionsDisabled) {
                viewConfigurationHelper = viewConfigurationHelper.getDisplayMetrics();
                return (int)TypedValue.applyDimension((int)5, (float)12.0f, (DisplayMetrics)viewConfigurationHelper);
            }
            throw new AssertionError((Object)"MinScalingSpan resource lookup failed.");
        }
    }

    private float toDips(int n2) {
        return (float)n2 / this.mDensity;
    }

    public static ViewConfigurationHelper createWithListener() {
        ViewConfigurationHelper viewConfigurationHelper = new ViewConfigurationHelper();
        viewConfigurationHelper.registerListener();
        return viewConfigurationHelper;
    }

    private native void nativeUpdateSharedViewConfiguration(float var1, float var2, float var3, float var4, float var5);

    static {
        $assertionsDisabled = ViewConfigurationHelper.class.desiredAssertionStatus() ^ true;
    }
}

