/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.gfx;

import android.graphics.Bitmap;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="gfx")
public class BitmapHelper {
    public static Bitmap createBitmap(int n2, int n3, int n4) {
        return Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)BitmapHelper.getBitmapConfigForFormat(n4));
    }

    public static int getBitmapFormatForConfig(Bitmap.Config config) {
        switch (config) {
            default: {
                return 0;
            }
            case RGB_565: {
                return 4;
            }
            case ARGB_8888: {
                return 3;
            }
            case ARGB_4444: {
                return 2;
            }
            case ALPHA_8: 
        }
        return 1;
    }

    public static Bitmap.Config getBitmapConfigForFormat(int n2) {
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 4) {
                    return Bitmap.Config.ARGB_8888;
                }
                return Bitmap.Config.RGB_565;
            }
            return Bitmap.Config.ARGB_4444;
        }
        return Bitmap.Config.ALPHA_8;
    }

    public static int getByteCount(Bitmap bitmap) {
        return bitmap.getByteCount();
    }
}

