/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import a.b.a.a;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.SystemClock;
import java.util.concurrent.TimeUnit;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="ui")
public class IdleDetector
extends BroadcastReceiver {
    public static final String TAG = "IdleDetector";
    public boolean mIdle;
    public long mLast;

    public IdleDetector() {
        IntentFilter intentFilter;
        IdleDetector idleDetector = this;
        if (idleDetector.isScreenLocked()) {
            this.start();
        } else {
            this.reset();
        }
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter().addAction("android.intent.action.SCREEN_OFF");
        intentFilter2.addAction("android.intent.action.USER_PRESENT");
        ContextUtils.getApplicationContext().registerReceiver((BroadcastReceiver)this, intentFilter2);
    }

    public static IdleDetector create() {
        return new IdleDetector();
    }

    private long now() {
        return SystemClock.elapsedRealtime();
    }

    private void start() {
        this.mIdle = true;
        this.mLast = this.now();
    }

    private void reset() {
        IdleDetector idleDetector = this;
        idleDetector.mIdle = false;
        idleDetector.mLast = 0L;
    }

    private long getIdleTime() {
        if (!this.mIdle) {
            return 0L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(this.now() - this.mLast);
    }

    private boolean isScreenLocked() {
        IdleDetector idleDetector = ContextUtils.getApplicationContext();
        return ((KeyguardManager)idleDetector.getSystemService("keyguard")).inKeyguardRestrictedInputMode() || !a.a((Context)idleDetector);
    }

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
            this.start();
        } else if (intent.getAction().equals("android.intent.action.USER_PRESENT")) {
            this.reset();
        }
    }
}

